/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder$WrappedHttpRequest;

final class HttpPostRequestEncoder$WrappedFullHttpRequest
extends HttpPostRequestEncoder$WrappedHttpRequest
implements FullHttpRequest {
    private final HttpContent content;

    private HttpPostRequestEncoder$WrappedFullHttpRequest(HttpRequest httpRequest, HttpContent httpContent) {
        super(httpRequest);
        this.content = httpContent;
    }

    @Override
    public FullHttpRequest setProtocolVersion(HttpVersion httpVersion) {
        super.setProtocolVersion(httpVersion);
        return this;
    }

    @Override
    public FullHttpRequest setMethod(HttpMethod httpMethod) {
        super.setMethod(httpMethod);
        return this;
    }

    @Override
    public FullHttpRequest setUri(String string) {
        super.setUri(string);
        return this;
    }

    @Override
    public FullHttpRequest copy() {
        return this.replace(this.content().copy());
    }

    @Override
    public FullHttpRequest duplicate() {
        return this.replace(this.content().duplicate());
    }

    @Override
    public FullHttpRequest retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public FullHttpRequest replace(ByteBuf byteBuf) {
        DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(this.protocolVersion(), this.method(), this.uri(), byteBuf);
        defaultFullHttpRequest.headers().set(this.headers());
        defaultFullHttpRequest.trailingHeaders().set(this.trailingHeaders());
        return defaultFullHttpRequest;
    }

    @Override
    public FullHttpRequest retain(int n2) {
        this.content.retain(n2);
        return this;
    }

    @Override
    public FullHttpRequest retain() {
        this.content.retain();
        return this;
    }

    @Override
    public FullHttpRequest touch() {
        this.content.touch();
        return this;
    }

    @Override
    public FullHttpRequest touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    public ByteBuf content() {
        return this.content.content();
    }

    @Override
    public HttpHeaders trailingHeaders() {
        if (this.content instanceof LastHttpContent) {
            return ((LastHttpContent)this.content).trailingHeaders();
        }
        return EmptyHttpHeaders.INSTANCE;
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public boolean release(int n2) {
        return this.content.release(n2);
    }
}

