/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$ErrorDataDecoderException;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.util.internal.StringUtil;
import java.nio.charset.Charset;
import java.util.List;

public class HttpPostRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    static final int DEFAULT_DISCARD_THRESHOLD = 0xA00000;
    private final InterfaceHttpPostRequestDecoder decoder;

    public HttpPostRequestDecoder(HttpRequest httpRequest) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest) {
        this(httpDataFactory, httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset) {
        if (httpDataFactory == null) {
            throw new NullPointerException("factory");
        }
        if (httpRequest == null) {
            throw new NullPointerException("request");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.decoder = HttpPostRequestDecoder.isMultipart(httpRequest) ? new HttpPostMultipartRequestDecoder(httpDataFactory, httpRequest, charset) : new HttpPostStandardRequestDecoder(httpDataFactory, httpRequest, charset);
    }

    public static boolean isMultipart(HttpRequest httpRequest) {
        if (httpRequest.headers().contains(HttpHeaderNames.CONTENT_TYPE)) {
            return HttpPostRequestDecoder.getMultipartDataBoundary(httpRequest.headers().get(HttpHeaderNames.CONTENT_TYPE)) != null;
        }
        return false;
    }

    protected static String[] getMultipartDataBoundary(String string) {
        String string2;
        String[] stringArray = HttpPostRequestDecoder.splitHeaderContentType(string);
        if (stringArray[0].regionMatches(true, 0, string2 = HttpHeaderValues.MULTIPART_FORM_DATA.toString(), 0, string2.length())) {
            String string3;
            int n2;
            String string4;
            int n3;
            int n4;
            String string5 = HttpHeaderValues.BOUNDARY.toString();
            if (stringArray[1].regionMatches(true, 0, string5, 0, string5.length())) {
                n4 = 1;
                n3 = 2;
            } else if (stringArray[2].regionMatches(true, 0, string5, 0, string5.length())) {
                n4 = 2;
                n3 = 1;
            } else {
                return null;
            }
            String string6 = StringUtil.substringAfter(stringArray[n4], '=');
            if (string6 == null) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("Needs a boundary value");
            }
            if (string6.charAt(0) == '\"' && (string4 = string6.trim()).charAt(n2 = string4.length() - 1) == '\"') {
                string6 = string4.substring(1, n2);
            }
            if (stringArray[n3].regionMatches(true, 0, string4 = HttpHeaderValues.CHARSET.toString(), 0, string4.length()) && (string3 = StringUtil.substringAfter(stringArray[n3], '=')) != null) {
                return new String[]{"--" + string6, string3};
            }
            return new String[]{"--" + string6};
        }
        return null;
    }

    @Override
    public boolean isMultipart() {
        return this.decoder.isMultipart();
    }

    @Override
    public void setDiscardThreshold(int n2) {
        this.decoder.setDiscardThreshold(n2);
    }

    @Override
    public int getDiscardThreshold() {
        return this.decoder.getDiscardThreshold();
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        return this.decoder.getBodyHttpDatas();
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String string) {
        return this.decoder.getBodyHttpDatas(string);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String string) {
        return this.decoder.getBodyHttpData(string);
    }

    @Override
    public InterfaceHttpPostRequestDecoder offer(HttpContent httpContent) {
        return this.decoder.offer(httpContent);
    }

    @Override
    public boolean hasNext() {
        return this.decoder.hasNext();
    }

    @Override
    public InterfaceHttpData next() {
        return this.decoder.next();
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        return this.decoder.currentPartialHttpData();
    }

    @Override
    public void destroy() {
        this.decoder.destroy();
    }

    @Override
    public void cleanFiles() {
        this.decoder.cleanFiles();
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData interfaceHttpData) {
        this.decoder.removeHttpDataFromClean(interfaceHttpData);
    }

    private static String[] splitHeaderContentType(String string) {
        int n2;
        int n3 = HttpPostBodyUtil.findNonWhitespace(string, 0);
        int n4 = string.indexOf(59);
        if (n4 == -1) {
            return new String[]{string, "", ""};
        }
        int n5 = HttpPostBodyUtil.findNonWhitespace(string, n4 + 1);
        if (string.charAt(n4 - 1) == ' ') {
            --n4;
        }
        if ((n2 = string.indexOf(59, n5)) == -1) {
            n2 = HttpPostBodyUtil.findEndOfString(string);
            return new String[]{string.substring(n3, n4), string.substring(n5, n2), ""};
        }
        int n6 = HttpPostBodyUtil.findNonWhitespace(string, n2 + 1);
        if (string.charAt(n2 - 1) == ' ') {
            --n2;
        }
        int n7 = HttpPostBodyUtil.findEndOfString(string);
        return new String[]{string.substring(n3, n4), string.substring(n5, n2), string.substring(n6, n7)};
    }
}

