/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.http.cookie.CookieUtil;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.CharBuffer;

public abstract class CookieDecoder {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private final boolean strict;

    protected CookieDecoder(boolean bl2) {
        this.strict = bl2;
    }

    protected DefaultCookie initCookie(String string, int n2, int n3, int n4, int n5) {
        boolean bl2;
        int n6;
        if (n2 == -1 || n2 == n3) {
            this.logger.debug("Skipping cookie with null name");
            return null;
        }
        if (n4 == -1) {
            this.logger.debug("Skipping cookie with null value");
            return null;
        }
        CharBuffer charBuffer = CharBuffer.wrap(string, n4, n5);
        CharSequence charSequence = CookieUtil.unwrapValue(charBuffer);
        if (charSequence == null) {
            this.logger.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)charBuffer);
            return null;
        }
        String string2 = string.substring(n2, n3);
        if (this.strict && (n6 = CookieUtil.firstInvalidCookieNameOctet(string2)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because name '{}' contains invalid char '{}'", (Object)string2, (Object)Character.valueOf(string2.charAt(n6)));
            }
            return null;
        }
        boolean bl3 = bl2 = charSequence.length() != n5 - n4;
        if (this.strict && (n6 = CookieUtil.firstInvalidCookieValueOctet(charSequence)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because value '{}' contains invalid char '{}'", (Object)charSequence, (Object)Character.valueOf(charSequence.charAt(n6)));
            }
            return null;
        }
        DefaultCookie defaultCookie = new DefaultCookie(string2, charSequence.toString());
        defaultCookie.setWrap(bl2);
        return defaultCookie;
    }
}

