/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.util.Date;

class ClientCookieDecoder$CookieBuilder {
    private final String header;
    private final DefaultCookie cookie;
    private String domain;
    private String path;
    private long maxAge = Long.MIN_VALUE;
    private int expiresStart;
    private int expiresEnd;
    private boolean secure;
    private boolean httpOnly;

    ClientCookieDecoder$CookieBuilder(DefaultCookie defaultCookie, String string) {
        this.cookie = defaultCookie;
        this.header = string;
    }

    private long mergeMaxAgeAndExpires() {
        Date date;
        if (this.maxAge != Long.MIN_VALUE) {
            return this.maxAge;
        }
        if (ClientCookieDecoder$CookieBuilder.isValueDefined(this.expiresStart, this.expiresEnd) && (date = DateFormatter.parseHttpDate(this.header, this.expiresStart, this.expiresEnd)) != null) {
            long l2 = date.getTime() - System.currentTimeMillis();
            return l2 / 1000L + (long)(l2 % 1000L != 0L ? 1 : 0);
        }
        return Long.MIN_VALUE;
    }

    Cookie cookie() {
        this.cookie.setDomain(this.domain);
        this.cookie.setPath(this.path);
        this.cookie.setMaxAge(this.mergeMaxAgeAndExpires());
        this.cookie.setSecure(this.secure);
        this.cookie.setHttpOnly(this.httpOnly);
        return this.cookie;
    }

    void appendAttribute(int n2, int n3, int n4, int n5) {
        int n6 = n3 - n2;
        if (n6 == 4) {
            this.parse4(n2, n4, n5);
        } else if (n6 == 6) {
            this.parse6(n2, n4, n5);
        } else if (n6 == 7) {
            this.parse7(n2, n4, n5);
        } else if (n6 == 8) {
            this.parse8(n2);
        }
    }

    private void parse4(int n2, int n3, int n4) {
        if (this.header.regionMatches(true, n2, "Path", 0, 4)) {
            this.path = this.computeValue(n3, n4);
        }
    }

    private void parse6(int n2, int n3, int n4) {
        if (this.header.regionMatches(true, n2, "Domain", 0, 5)) {
            this.domain = this.computeValue(n3, n4);
        } else if (this.header.regionMatches(true, n2, "Secure", 0, 5)) {
            this.secure = true;
        }
    }

    private void setMaxAge(String string) {
        try {
            this.maxAge = Math.max(Long.parseLong(string), 0L);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void parse7(int n2, int n3, int n4) {
        if (this.header.regionMatches(true, n2, "Expires", 0, 7)) {
            this.expiresStart = n3;
            this.expiresEnd = n4;
        } else if (this.header.regionMatches(true, n2, "Max-Age", 0, 7)) {
            this.setMaxAge(this.computeValue(n3, n4));
        }
    }

    private void parse8(int n2) {
        if (this.header.regionMatches(true, n2, "HTTPOnly", 0, 8)) {
            this.httpOnly = true;
        }
    }

    private static boolean isValueDefined(int n2, int n3) {
        return n2 != -1 && n2 != n3;
    }

    private String computeValue(int n2, int n3) {
        return ClientCookieDecoder$CookieBuilder.isValueDefined(n2, n3) ? this.header.substring(n2, n3) : null;
    }
}

