/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpConstants;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryStringDecoder {
    private static final int DEFAULT_MAX_PARAMS = 1024;
    private final Charset charset;
    private final String uri;
    private final int maxParams;
    private int pathEndIdx;
    private String path;
    private Map<String, List<String>> params;

    public QueryStringDecoder(String string) {
        this(string, HttpConstants.DEFAULT_CHARSET);
    }

    public QueryStringDecoder(String string, boolean bl2) {
        this(string, HttpConstants.DEFAULT_CHARSET, bl2);
    }

    public QueryStringDecoder(String string, Charset charset) {
        this(string, charset, true);
    }

    public QueryStringDecoder(String string, Charset charset, boolean bl2) {
        this(string, charset, bl2, 1024);
    }

    public QueryStringDecoder(String string, Charset charset, boolean bl2, int n2) {
        this.uri = ObjectUtil.checkNotNull(string, "uri");
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
        this.maxParams = ObjectUtil.checkPositive(n2, "maxParams");
        this.pathEndIdx = bl2 ? -1 : 0;
    }

    public QueryStringDecoder(URI uRI) {
        this(uRI, HttpConstants.DEFAULT_CHARSET);
    }

    public QueryStringDecoder(URI uRI, Charset charset) {
        this(uRI, charset, 1024);
    }

    public QueryStringDecoder(URI uRI, Charset charset, int n2) {
        String string;
        String string2 = uRI.getRawPath();
        if (string2 == null) {
            string2 = "";
        }
        this.uri = (string = uRI.getRawQuery()) == null ? string2 : string2 + '?' + string;
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
        this.maxParams = ObjectUtil.checkPositive(n2, "maxParams");
        this.pathEndIdx = string2.length();
    }

    public String toString() {
        return this.uri();
    }

    public String uri() {
        return this.uri;
    }

    public String path() {
        if (this.path == null) {
            this.path = QueryStringDecoder.decodeComponent(this.uri, 0, this.pathEndIdx(), this.charset, true);
        }
        return this.path;
    }

    public Map<String, List<String>> parameters() {
        if (this.params == null) {
            this.params = QueryStringDecoder.decodeParams(this.uri, this.pathEndIdx(), this.charset, this.maxParams);
        }
        return this.params;
    }

    public String rawPath() {
        return this.uri.substring(0, this.pathEndIdx());
    }

    public String rawQuery() {
        int n2 = this.pathEndIdx() + 1;
        return n2 < this.uri.length() ? this.uri.substring(n2) : "";
    }

    private int pathEndIdx() {
        if (this.pathEndIdx == -1) {
            this.pathEndIdx = QueryStringDecoder.findPathEndIndex(this.uri);
        }
        return this.pathEndIdx;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Map<String, List<String>> decodeParams(String string, int n2, Charset charset, int n3) {
        int n4;
        int n5 = string.length();
        if (n2 >= n5) {
            return Collections.emptyMap();
        }
        if (string.charAt(n2) == '?') {
            ++n2;
        }
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        int n6 = n2;
        int n7 = -1;
        block5: for (n4 = n2; n4 < n5; ++n4) {
            switch (string.charAt(n4)) {
                case '=': {
                    if (n6 == n4) {
                        n6 = n4 + 1;
                        break;
                    }
                    if (n7 >= n6) break;
                    n7 = n4 + 1;
                    break;
                }
                case '&': 
                case ';': {
                    if (QueryStringDecoder.addParam(string, n6, n7, n4, linkedHashMap, charset) && --n3 == 0) {
                        return linkedHashMap;
                    }
                    n6 = n4 + 1;
                    break;
                }
                case '#': {
                    break block5;
                }
            }
        }
        QueryStringDecoder.addParam(string, n6, n7, n4, linkedHashMap, charset);
        return linkedHashMap;
    }

    private static boolean addParam(String string, int n2, int n3, int n4, Map<String, List<String>> map, Charset charset) {
        if (n2 >= n4) {
            return false;
        }
        if (n3 <= n2) {
            n3 = n4 + 1;
        }
        String string2 = QueryStringDecoder.decodeComponent(string, n2, n3 - 1, charset, false);
        String string3 = QueryStringDecoder.decodeComponent(string, n3, n4, charset, false);
        List<String> list = map.get(string2);
        if (list == null) {
            list = new ArrayList<String>(1);
            map.put(string2, list);
        }
        list.add(string3);
        return true;
    }

    public static String decodeComponent(String string) {
        return QueryStringDecoder.decodeComponent(string, HttpConstants.DEFAULT_CHARSET);
    }

    public static String decodeComponent(String string, Charset charset) {
        if (string == null) {
            return "";
        }
        return QueryStringDecoder.decodeComponent(string, 0, string.length(), charset, false);
    }

    private static String decodeComponent(String string, int n2, int n3, Charset charset, boolean bl2) {
        int n4;
        int n5 = n3 - n2;
        if (n5 <= 0) {
            return "";
        }
        int n6 = -1;
        for (int i2 = n2; i2 < n3; ++i2) {
            n4 = string.charAt(i2);
            if (n4 != 37 && (n4 != 43 || bl2)) continue;
            n6 = i2;
            break;
        }
        if (n6 == -1) {
            return string.substring(n2, n3);
        }
        CharsetDecoder charsetDecoder = CharsetUtil.decoder(charset);
        n4 = (n3 - n6) / 3;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n4);
        CharBuffer charBuffer = CharBuffer.allocate(n4);
        StringBuilder stringBuilder = new StringBuilder(n5);
        stringBuilder.append(string, n2, n6);
        for (int i3 = n6; i3 < n3; ++i3) {
            char c2 = string.charAt(i3);
            if (c2 != '%') {
                stringBuilder.append(c2 != '+' || bl2 ? c2 : (char)' ');
                continue;
            }
            byteBuffer.clear();
            do {
                if (i3 + 3 > n3) {
                    throw new IllegalArgumentException("unterminated escape sequence at index " + i3 + " of: " + string);
                }
                byteBuffer.put(StringUtil.decodeHexByte(string, i3 + 1));
            } while ((i3 += 3) < n3 && string.charAt(i3) == '%');
            --i3;
            byteBuffer.flip();
            charBuffer.clear();
            CoderResult coderResult = charsetDecoder.reset().decode(byteBuffer, charBuffer, true);
            try {
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = charsetDecoder.flush(charBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new IllegalStateException(characterCodingException);
            }
            stringBuilder.append(charBuffer.flip());
        }
        return stringBuilder.toString();
    }

    private static int findPathEndIndex(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '?' && c2 != '#') continue;
            return i2;
        }
        return n2;
    }
}

