/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerUpgradeHandler$SourceCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler$UpgradeCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler$UpgradeCodecFactory;
import io.netty.handler.codec.http.HttpServerUpgradeHandler$UpgradeEvent;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HttpServerUpgradeHandler
extends HttpObjectAggregator {
    private final HttpServerUpgradeHandler$SourceCodec sourceCodec;
    private final HttpServerUpgradeHandler$UpgradeCodecFactory upgradeCodecFactory;
    private boolean handlingUpgrade;

    public HttpServerUpgradeHandler(HttpServerUpgradeHandler$SourceCodec httpServerUpgradeHandler$SourceCodec, HttpServerUpgradeHandler$UpgradeCodecFactory upgradeCodecFactory) {
        this(httpServerUpgradeHandler$SourceCodec, upgradeCodecFactory, 0);
    }

    public HttpServerUpgradeHandler(HttpServerUpgradeHandler$SourceCodec httpServerUpgradeHandler$SourceCodec, HttpServerUpgradeHandler$UpgradeCodecFactory upgradeCodecFactory, int n2) {
        super(n2);
        this.sourceCodec = ObjectUtil.checkNotNull(httpServerUpgradeHandler$SourceCodec, "sourceCodec");
        this.upgradeCodecFactory = ObjectUtil.checkNotNull(upgradeCodecFactory, "upgradeCodecFactory");
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        FullHttpRequest fullHttpRequest;
        this.handlingUpgrade |= HttpServerUpgradeHandler.isUpgradeRequest(httpObject);
        if (!this.handlingUpgrade) {
            ReferenceCountUtil.retain(httpObject);
            list.add(httpObject);
            return;
        }
        if (httpObject instanceof FullHttpRequest) {
            fullHttpRequest = (FullHttpRequest)httpObject;
            ReferenceCountUtil.retain(httpObject);
            list.add(httpObject);
        } else {
            super.decode(channelHandlerContext, httpObject, list);
            if (list.isEmpty()) {
                return;
            }
            assert (list.size() == 1);
            this.handlingUpgrade = false;
            fullHttpRequest = (FullHttpRequest)list.get(0);
        }
        if (this.upgrade(channelHandlerContext, fullHttpRequest)) {
            list.clear();
        }
    }

    private static boolean isUpgradeRequest(HttpObject httpObject) {
        return httpObject instanceof HttpRequest && ((HttpRequest)httpObject).headers().get(HttpHeaderNames.UPGRADE) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upgrade(ChannelHandlerContext channelHandlerContext, FullHttpRequest fullHttpRequest) {
        Object object;
        List<CharSequence> list;
        Object object2;
        List<CharSequence> list2 = HttpServerUpgradeHandler.splitHeader(fullHttpRequest.headers().get(HttpHeaderNames.UPGRADE));
        int n2 = list2.size();
        HttpServerUpgradeHandler$UpgradeCodec httpServerUpgradeHandler$UpgradeCodec = null;
        Object object3 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            object2 = list2.get(i2);
            list = this.upgradeCodecFactory.newUpgradeCodec((CharSequence)object2);
            if (list == null) continue;
            object3 = object2;
            httpServerUpgradeHandler$UpgradeCodec = list;
            break;
        }
        if (httpServerUpgradeHandler$UpgradeCodec == null) {
            return false;
        }
        String string = fullHttpRequest.headers().get(HttpHeaderNames.CONNECTION);
        if (string == null) {
            return false;
        }
        object2 = httpServerUpgradeHandler$UpgradeCodec.requiredUpgradeHeaders();
        list = HttpServerUpgradeHandler.splitHeader(string);
        if (!AsciiString.containsContentEqualsIgnoreCase((Collection<CharSequence>)list, HttpHeaderNames.UPGRADE) || !AsciiString.containsAllContentEqualsIgnoreCase((Collection<CharSequence>)list, (Collection<CharSequence>)object2)) {
            return false;
        }
        Object object4 = object2.iterator();
        while (object4.hasNext()) {
            object = (CharSequence)object4.next();
            if (fullHttpRequest.headers().contains((CharSequence)object)) continue;
            return false;
        }
        object4 = HttpServerUpgradeHandler.createUpgradeResponse((CharSequence)object3);
        if (!httpServerUpgradeHandler$UpgradeCodec.prepareUpgradeResponse(channelHandlerContext, fullHttpRequest, object4.headers())) {
            return false;
        }
        object = new HttpServerUpgradeHandler$UpgradeEvent((CharSequence)object3, fullHttpRequest);
        try {
            ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(object4);
            this.sourceCodec.upgradeFrom(channelHandlerContext);
            httpServerUpgradeHandler$UpgradeCodec.upgradeTo(channelHandlerContext, fullHttpRequest);
            channelHandlerContext.pipeline().remove(this);
            channelHandlerContext.fireUserEventTriggered(((HttpServerUpgradeHandler$UpgradeEvent)object).retain());
            channelFuture.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        }
        finally {
            ((HttpServerUpgradeHandler$UpgradeEvent)object).release();
        }
        return true;
    }

    private static FullHttpResponse createUpgradeResponse(CharSequence charSequence) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, false);
        defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)charSequence);
        return defaultFullHttpResponse;
    }

    private static List<CharSequence> splitHeader(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(4);
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            if (c2 == ',') {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }
}

