/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.HttpObjectEncoder;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.CharsetUtil;

public class HttpRequestEncoder
extends HttpObjectEncoder<HttpRequest> {
    private static final char SLASH = '/';
    private static final char QUESTION_MARK = '?';
    private static final int SLASH_AND_SPACE_SHORT = 12064;
    private static final int SPACE_SLASH_AND_SPACE_MEDIUM = 0x202F20;

    @Override
    public boolean acceptOutboundMessage(Object object) {
        return super.acceptOutboundMessage(object) && !(object instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(ByteBuf byteBuf, HttpRequest httpRequest) {
        ByteBufUtil.copy(httpRequest.method().asciiName(), byteBuf);
        String string = httpRequest.uri();
        if (string.isEmpty()) {
            ByteBufUtil.writeMediumBE(byteBuf, 0x202F20);
        } else {
            CharSequence charSequence = string;
            boolean bl2 = false;
            int n2 = string.indexOf("://");
            if (n2 != -1 && string.charAt(0) != '/') {
                int n3 = string.indexOf(63, n2 += 3);
                if (n3 == -1) {
                    if (string.lastIndexOf(47) < n2) {
                        bl2 = true;
                    }
                } else if (string.lastIndexOf(47, n3) < n2) {
                    charSequence = new StringBuilder(string).insert(n3, '/');
                }
            }
            byteBuf.writeByte(32).writeCharSequence(charSequence, CharsetUtil.UTF_8);
            if (bl2) {
                ByteBufUtil.writeShortBE(byteBuf, 12064);
            } else {
                byteBuf.writeByte(32);
            }
        }
        httpRequest.protocolVersion().encode(byteBuf);
        ByteBufUtil.writeShortBE(byteBuf, 3338);
    }
}

