/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectDecoder$1;
import io.netty.handler.codec.http.HttpObjectDecoder$HeaderParser;
import io.netty.handler.codec.http.HttpObjectDecoder$LineParser;
import io.netty.handler.codec.http.HttpObjectDecoder$State;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.internal.AppendableCharSequence;
import java.util.List;

public abstract class HttpObjectDecoder
extends ByteToMessageDecoder {
    private static final String EMPTY_VALUE = "";
    private final int maxChunkSize;
    private final boolean chunkedSupported;
    protected final boolean validateHeaders;
    private final HttpObjectDecoder$HeaderParser headerParser;
    private final HttpObjectDecoder$LineParser lineParser;
    private HttpMessage message;
    private long chunkSize;
    private long contentLength = Long.MIN_VALUE;
    private volatile boolean resetRequested;
    private CharSequence name;
    private CharSequence value;
    private LastHttpContent trailer;
    private HttpObjectDecoder$State currentState = HttpObjectDecoder$State.SKIP_CONTROL_CHARS;

    protected HttpObjectDecoder() {
        this(4096, 8192, 8192, true);
    }

    protected HttpObjectDecoder(int n2, int n3, int n4, boolean bl2) {
        this(n2, n3, n4, bl2, true);
    }

    protected HttpObjectDecoder(int n2, int n3, int n4, boolean bl2, boolean bl3) {
        this(n2, n3, n4, bl2, bl3, 128);
    }

    protected HttpObjectDecoder(int n2, int n3, int n4, boolean bl2, boolean bl3, int n5) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxInitialLineLength must be a positive integer: " + n2);
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be a positive integer: " + n3);
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("maxChunkSize must be a positive integer: " + n4);
        }
        AppendableCharSequence appendableCharSequence = new AppendableCharSequence(n5);
        this.lineParser = new HttpObjectDecoder$LineParser(appendableCharSequence, n2);
        this.headerParser = new HttpObjectDecoder$HeaderParser(appendableCharSequence, n3);
        this.maxChunkSize = n4;
        this.chunkedSupported = bl2;
        this.validateHeaders = bl3;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.resetRequested) {
            this.resetNow();
        }
        switch (this.currentState) {
            case SKIP_CONTROL_CHARS: {
                if (!HttpObjectDecoder.skipControlCharacters(byteBuf)) {
                    return;
                }
                this.currentState = HttpObjectDecoder$State.READ_INITIAL;
            }
            case READ_INITIAL: {
                Object object;
                try {
                    object = this.lineParser.parse(byteBuf);
                    if (object == null) {
                        return;
                    }
                    String[] stringArray = HttpObjectDecoder.splitInitialLine((AppendableCharSequence)object);
                    if (stringArray.length < 3) {
                        this.currentState = HttpObjectDecoder$State.SKIP_CONTROL_CHARS;
                        return;
                    }
                    this.message = this.createMessage(stringArray);
                    this.currentState = HttpObjectDecoder$State.READ_HEADER;
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(byteBuf, exception));
                    return;
                }
            }
            case READ_HEADER: {
                Object object;
                try {
                    object = this.readHeaders(byteBuf);
                    if (object == null) {
                        return;
                    }
                    this.currentState = object;
                    switch (HttpObjectDecoder$1.$SwitchMap$io$netty$handler$codec$http$HttpObjectDecoder$State[((Enum)object).ordinal()]) {
                        case 1: {
                            list.add(this.message);
                            list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                            this.resetNow();
                            return;
                        }
                        case 2: {
                            if (!this.chunkedSupported) {
                                throw new IllegalArgumentException("Chunked messages not supported");
                            }
                            list.add(this.message);
                            return;
                        }
                    }
                    long l2 = this.contentLength();
                    if (l2 == 0L || l2 == -1L && this.isDecodingRequest()) {
                        list.add(this.message);
                        list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                        this.resetNow();
                        return;
                    }
                    assert (object == HttpObjectDecoder$State.READ_FIXED_LENGTH_CONTENT || object == HttpObjectDecoder$State.READ_VARIABLE_LENGTH_CONTENT);
                    list.add(this.message);
                    if (object == HttpObjectDecoder$State.READ_FIXED_LENGTH_CONTENT) {
                        this.chunkSize = l2;
                    }
                    return;
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(byteBuf, exception));
                    return;
                }
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int n2 = Math.min(byteBuf.readableBytes(), this.maxChunkSize);
                if (n2 > 0) {
                    ByteBuf byteBuf2 = byteBuf.readRetainedSlice(n2);
                    list.add(new DefaultHttpContent(byteBuf2));
                }
                return;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                int n3 = byteBuf.readableBytes();
                if (n3 == 0) {
                    return;
                }
                int n4 = Math.min(n3, this.maxChunkSize);
                if ((long)n4 > this.chunkSize) {
                    n4 = (int)this.chunkSize;
                }
                ByteBuf byteBuf3 = byteBuf.readRetainedSlice(n4);
                this.chunkSize -= (long)n4;
                if (this.chunkSize == 0L) {
                    list.add(new DefaultLastHttpContent(byteBuf3, this.validateHeaders));
                    this.resetNow();
                } else {
                    list.add(new DefaultHttpContent(byteBuf3));
                }
                return;
            }
            case READ_CHUNK_SIZE: {
                try {
                    AppendableCharSequence appendableCharSequence = this.lineParser.parse(byteBuf);
                    if (appendableCharSequence == null) {
                        return;
                    }
                    int n5 = HttpObjectDecoder.getChunkSize(appendableCharSequence.toString());
                    this.chunkSize = n5;
                    if (n5 == 0) {
                        this.currentState = HttpObjectDecoder$State.READ_CHUNK_FOOTER;
                        return;
                    }
                    this.currentState = HttpObjectDecoder$State.READ_CHUNKED_CONTENT;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                int n6 = Math.min((int)this.chunkSize, this.maxChunkSize);
                if ((n6 = Math.min(n6, byteBuf.readableBytes())) == 0) {
                    return;
                }
                DefaultHttpContent defaultHttpContent = new DefaultHttpContent(byteBuf.readRetainedSlice(n6));
                this.chunkSize -= (long)n6;
                list.add(defaultHttpContent);
                if (this.chunkSize != 0L) {
                    return;
                }
                this.currentState = HttpObjectDecoder$State.READ_CHUNK_DELIMITER;
            }
            case READ_CHUNK_DELIMITER: {
                int n6 = byteBuf.writerIndex();
                int n7 = byteBuf.readerIndex();
                while (n6 > n7) {
                    byte by2;
                    if ((by2 = byteBuf.getByte(n7++)) != 10) continue;
                    this.currentState = HttpObjectDecoder$State.READ_CHUNK_SIZE;
                    break;
                }
                byteBuf.readerIndex(n7);
                return;
            }
            case READ_CHUNK_FOOTER: {
                try {
                    LastHttpContent lastHttpContent = this.readTrailingHeaders(byteBuf);
                    if (lastHttpContent == null) {
                        return;
                    }
                    list.add(lastHttpContent);
                    this.resetNow();
                    return;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case BAD_MESSAGE: {
                byteBuf.skipBytes(byteBuf.readableBytes());
                break;
            }
            case UPGRADED: {
                int n8 = byteBuf.readableBytes();
                if (n8 <= 0) break;
                list.add(byteBuf.readBytes(n8));
                break;
            }
        }
    }

    @Override
    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        super.decodeLast(channelHandlerContext, byteBuf, list);
        if (this.resetRequested) {
            this.resetNow();
        }
        if (this.message != null) {
            boolean bl2;
            boolean bl3 = HttpUtil.isTransferEncodingChunked(this.message);
            if (this.currentState == HttpObjectDecoder$State.READ_VARIABLE_LENGTH_CONTENT && !byteBuf.isReadable() && !bl3) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                this.resetNow();
                return;
            }
            if (this.currentState == HttpObjectDecoder$State.READ_HEADER) {
                list.add(this.invalidMessage(Unpooled.EMPTY_BUFFER, new PrematureChannelClosureException("Connection closed before received headers")));
                this.resetNow();
                return;
            }
            if (this.isDecodingRequest() || bl3) {
                bl2 = true;
            } else {
                boolean bl4 = bl2 = this.contentLength() > 0L;
            }
            if (!bl2) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
            }
            this.resetNow();
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof HttpExpectationFailedEvent) {
            switch (this.currentState) {
                case READ_CHUNK_SIZE: 
                case READ_VARIABLE_LENGTH_CONTENT: 
                case READ_FIXED_LENGTH_CONTENT: {
                    this.reset();
                    break;
                }
            }
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
        if (httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            int n2 = httpResponse.status().code();
            if (n2 >= 100 && n2 < 200) {
                return n2 != 101 || httpResponse.headers().contains(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT) || !httpResponse.headers().contains(HttpHeaderNames.UPGRADE, HttpHeaderValues.WEBSOCKET, true);
            }
            switch (n2) {
                case 204: 
                case 304: {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isSwitchingToNonHttp1Protocol(HttpResponse httpResponse) {
        if (httpResponse.status().code() != HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
            return false;
        }
        String string = httpResponse.headers().get(HttpHeaderNames.UPGRADE);
        return string == null || !string.contains(HttpVersion.HTTP_1_0.text()) && !string.contains(HttpVersion.HTTP_1_1.text());
    }

    public void reset() {
        this.resetRequested = true;
    }

    private void resetNow() {
        HttpResponse httpResponse;
        HttpMessage httpMessage = this.message;
        this.message = null;
        this.name = null;
        this.value = null;
        this.contentLength = Long.MIN_VALUE;
        this.lineParser.reset();
        this.headerParser.reset();
        this.trailer = null;
        if (!this.isDecodingRequest() && (httpResponse = (HttpResponse)httpMessage) != null && this.isSwitchingToNonHttp1Protocol(httpResponse)) {
            this.currentState = HttpObjectDecoder$State.UPGRADED;
            return;
        }
        this.resetRequested = false;
        this.currentState = HttpObjectDecoder$State.SKIP_CONTROL_CHARS;
    }

    private HttpMessage invalidMessage(ByteBuf byteBuf, Exception exception) {
        this.currentState = HttpObjectDecoder$State.BAD_MESSAGE;
        byteBuf.skipBytes(byteBuf.readableBytes());
        if (this.message == null) {
            this.message = this.createInvalidMessage();
        }
        this.message.setDecoderResult(DecoderResult.failure(exception));
        HttpMessage httpMessage = this.message;
        this.message = null;
        return httpMessage;
    }

    private HttpContent invalidChunk(ByteBuf byteBuf, Exception exception) {
        this.currentState = HttpObjectDecoder$State.BAD_MESSAGE;
        byteBuf.skipBytes(byteBuf.readableBytes());
        DefaultLastHttpContent defaultLastHttpContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
        defaultLastHttpContent.setDecoderResult(DecoderResult.failure(exception));
        this.message = null;
        this.trailer = null;
        return defaultLastHttpContent;
    }

    private static boolean skipControlCharacters(ByteBuf byteBuf) {
        boolean bl2 = false;
        int n2 = byteBuf.writerIndex();
        int n3 = byteBuf.readerIndex();
        while (n2 > n3) {
            short s2;
            if (Character.isISOControl(s2 = byteBuf.getUnsignedByte(n3++)) || Character.isWhitespace(s2)) continue;
            --n3;
            bl2 = true;
            break;
        }
        byteBuf.readerIndex(n3);
        return bl2;
    }

    private HttpObjectDecoder$State readHeaders(ByteBuf byteBuf) {
        HttpObjectDecoder$State httpObjectDecoder$State;
        HttpMessage httpMessage = this.message;
        HttpHeaders httpHeaders = httpMessage.headers();
        AppendableCharSequence appendableCharSequence = this.headerParser.parse(byteBuf);
        if (appendableCharSequence == null) {
            return null;
        }
        if (appendableCharSequence.length() > 0) {
            do {
                char c2 = appendableCharSequence.charAt(0);
                if (this.name != null && (c2 == ' ' || c2 == '\t')) {
                    String string = appendableCharSequence.toString().trim();
                    String string2 = String.valueOf(this.value);
                    this.value = string2 + ' ' + string;
                } else {
                    if (this.name != null) {
                        httpHeaders.add(this.name, (Object)this.value);
                    }
                    this.splitHeader(appendableCharSequence);
                }
                appendableCharSequence = this.headerParser.parse(byteBuf);
                if (appendableCharSequence != null) continue;
                return null;
            } while (appendableCharSequence.length() > 0);
        }
        if (this.name != null) {
            httpHeaders.add(this.name, (Object)this.value);
        }
        this.name = null;
        this.value = null;
        if (this.isContentAlwaysEmpty(httpMessage)) {
            HttpUtil.setTransferEncodingChunked(httpMessage, false);
            httpObjectDecoder$State = HttpObjectDecoder$State.SKIP_CONTROL_CHARS;
        } else {
            httpObjectDecoder$State = HttpUtil.isTransferEncodingChunked(httpMessage) ? HttpObjectDecoder$State.READ_CHUNK_SIZE : (this.contentLength() >= 0L ? HttpObjectDecoder$State.READ_FIXED_LENGTH_CONTENT : HttpObjectDecoder$State.READ_VARIABLE_LENGTH_CONTENT);
        }
        return httpObjectDecoder$State;
    }

    private long contentLength() {
        if (this.contentLength == Long.MIN_VALUE) {
            this.contentLength = HttpUtil.getContentLength(this.message, -1L);
        }
        return this.contentLength;
    }

    private LastHttpContent readTrailingHeaders(ByteBuf byteBuf) {
        AppendableCharSequence appendableCharSequence = this.headerParser.parse(byteBuf);
        if (appendableCharSequence == null) {
            return null;
        }
        CharSequence charSequence = null;
        if (appendableCharSequence.length() > 0) {
            LastHttpContent lastHttpContent = this.trailer;
            if (lastHttpContent == null) {
                lastHttpContent = this.trailer = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.validateHeaders);
            }
            do {
                List<String> list;
                char c2 = appendableCharSequence.charAt(0);
                if (charSequence != null && (c2 == ' ' || c2 == '\t')) {
                    list = lastHttpContent.trailingHeaders().getAll(charSequence);
                    if (!list.isEmpty()) {
                        int n2 = list.size() - 1;
                        String string = appendableCharSequence.toString().trim();
                        String string2 = (String)list.get(n2);
                        list.set(n2, string2 + string);
                    }
                } else {
                    this.splitHeader(appendableCharSequence);
                    list = this.name;
                    if (!(HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)((Object)list)) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase((CharSequence)((Object)list)) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase((CharSequence)((Object)list)))) {
                        lastHttpContent.trailingHeaders().add((CharSequence)((Object)list), (Object)this.value);
                    }
                    charSequence = this.name;
                    this.name = null;
                    this.value = null;
                }
                appendableCharSequence = this.headerParser.parse(byteBuf);
                if (appendableCharSequence != null) continue;
                return null;
            } while (appendableCharSequence.length() > 0);
            this.trailer = null;
            return lastHttpContent;
        }
        return LastHttpContent.EMPTY_LAST_CONTENT;
    }

    protected abstract boolean isDecodingRequest();

    protected abstract HttpMessage createMessage(String[] var1);

    protected abstract HttpMessage createInvalidMessage();

    private static int getChunkSize(String string) {
        string = string.trim();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != ';' && !Character.isWhitespace(c2) && !Character.isISOControl(c2)) continue;
            string = string.substring(0, i2);
            break;
        }
        return Integer.parseInt(string, 16);
    }

    private static String[] splitInitialLine(AppendableCharSequence appendableCharSequence) {
        int n2 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, 0);
        int n3 = HttpObjectDecoder.findWhitespace(appendableCharSequence, n2);
        int n4 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, n3);
        int n5 = HttpObjectDecoder.findWhitespace(appendableCharSequence, n4);
        int n6 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, n5);
        int n7 = HttpObjectDecoder.findEndOfString(appendableCharSequence);
        return new String[]{appendableCharSequence.subStringUnsafe(n2, n3), appendableCharSequence.subStringUnsafe(n4, n5), n6 < n7 ? appendableCharSequence.subStringUnsafe(n6, n7) : EMPTY_VALUE};
    }

    private void splitHeader(AppendableCharSequence appendableCharSequence) {
        int n2;
        int n3;
        char c2;
        int n4;
        int n5 = appendableCharSequence.length();
        for (n4 = n3 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, 0); n4 < n5 && (c2 = appendableCharSequence.charAt(n4)) != ':' && !Character.isWhitespace(c2); ++n4) {
        }
        for (n2 = n4; n2 < n5; ++n2) {
            if (appendableCharSequence.charAt(n2) != ':') continue;
            ++n2;
            break;
        }
        this.name = appendableCharSequence.subStringUnsafe(n3, n4);
        int n6 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, n2);
        if (n6 == n5) {
            this.value = EMPTY_VALUE;
        } else {
            int n7 = HttpObjectDecoder.findEndOfString(appendableCharSequence);
            this.value = appendableCharSequence.subStringUnsafe(n6, n7);
        }
    }

    private static int findNonWhitespace(AppendableCharSequence appendableCharSequence, int n2) {
        for (int i2 = n2; i2 < appendableCharSequence.length(); ++i2) {
            if (Character.isWhitespace(appendableCharSequence.charAtUnsafe(i2))) continue;
            return i2;
        }
        return appendableCharSequence.length();
    }

    private static int findWhitespace(AppendableCharSequence appendableCharSequence, int n2) {
        for (int i2 = n2; i2 < appendableCharSequence.length(); ++i2) {
            if (!Character.isWhitespace(appendableCharSequence.charAtUnsafe(i2))) continue;
            return i2;
        }
        return appendableCharSequence.length();
    }

    private static int findEndOfString(AppendableCharSequence appendableCharSequence) {
        for (int i2 = appendableCharSequence.length() - 1; i2 > 0; --i2) {
            if (Character.isWhitespace(appendableCharSequence.charAtUnsafe(i2))) continue;
            return i2 + 1;
        }
        return 0;
    }
}

