/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.AppendableCharSequence;

class HttpObjectDecoder$HeaderParser
implements ByteProcessor {
    private final AppendableCharSequence seq;
    private final int maxLength;
    private int size;

    HttpObjectDecoder$HeaderParser(AppendableCharSequence appendableCharSequence, int n2) {
        this.seq = appendableCharSequence;
        this.maxLength = n2;
    }

    public AppendableCharSequence parse(ByteBuf byteBuf) {
        int n2 = this.size;
        this.seq.reset();
        int n3 = byteBuf.forEachByte(this);
        if (n3 == -1) {
            this.size = n2;
            return null;
        }
        byteBuf.readerIndex(n3 + 1);
        return this.seq;
    }

    public void reset() {
        this.size = 0;
    }

    @Override
    public boolean process(byte by2) {
        char c2 = (char)(by2 & 0xFF);
        if (c2 == '\r') {
            return true;
        }
        if (c2 == '\n') {
            return false;
        }
        if (++this.size > this.maxLength) {
            throw this.newException(this.maxLength);
        }
        this.seq.append(c2);
        return true;
    }

    protected TooLongFrameException newException(int n2) {
        return new TooLongFrameException("HTTP header is larger than " + n2 + " bytes.");
    }
}

