/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.HeadersUtils;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class HttpHeaders
implements Iterable<Map.Entry<String, String>> {
    @Deprecated
    public static final HttpHeaders EMPTY_HEADERS = EmptyHttpHeaders.instance();

    @Deprecated
    public static boolean isKeepAlive(HttpMessage httpMessage) {
        return HttpUtil.isKeepAlive(httpMessage);
    }

    @Deprecated
    public static void setKeepAlive(HttpMessage httpMessage, boolean bl2) {
        HttpUtil.setKeepAlive(httpMessage, bl2);
    }

    @Deprecated
    public static String getHeader(HttpMessage httpMessage, String string) {
        return httpMessage.headers().get(string);
    }

    @Deprecated
    public static String getHeader(HttpMessage httpMessage, CharSequence charSequence) {
        return httpMessage.headers().get(charSequence);
    }

    @Deprecated
    public static String getHeader(HttpMessage httpMessage, String string, String string2) {
        return httpMessage.headers().get(string, string2);
    }

    @Deprecated
    public static String getHeader(HttpMessage httpMessage, CharSequence charSequence, String string) {
        return httpMessage.headers().get(charSequence, string);
    }

    @Deprecated
    public static void setHeader(HttpMessage httpMessage, String string, Object object) {
        httpMessage.headers().set(string, object);
    }

    @Deprecated
    public static void setHeader(HttpMessage httpMessage, CharSequence charSequence, Object object) {
        httpMessage.headers().set(charSequence, object);
    }

    @Deprecated
    public static void setHeader(HttpMessage httpMessage, String string, Iterable<?> iterable) {
        httpMessage.headers().set(string, iterable);
    }

    @Deprecated
    public static void setHeader(HttpMessage httpMessage, CharSequence charSequence, Iterable<?> iterable) {
        httpMessage.headers().set(charSequence, iterable);
    }

    @Deprecated
    public static void addHeader(HttpMessage httpMessage, String string, Object object) {
        httpMessage.headers().add(string, object);
    }

    @Deprecated
    public static void addHeader(HttpMessage httpMessage, CharSequence charSequence, Object object) {
        httpMessage.headers().add(charSequence, object);
    }

    @Deprecated
    public static void removeHeader(HttpMessage httpMessage, String string) {
        httpMessage.headers().remove(string);
    }

    @Deprecated
    public static void removeHeader(HttpMessage httpMessage, CharSequence charSequence) {
        httpMessage.headers().remove(charSequence);
    }

    @Deprecated
    public static void clearHeaders(HttpMessage httpMessage) {
        httpMessage.headers().clear();
    }

    @Deprecated
    public static int getIntHeader(HttpMessage httpMessage, String string) {
        return HttpHeaders.getIntHeader(httpMessage, (CharSequence)string);
    }

    @Deprecated
    public static int getIntHeader(HttpMessage httpMessage, CharSequence charSequence) {
        String string = httpMessage.headers().get(charSequence);
        if (string == null) {
            throw new NumberFormatException("header not found: " + charSequence);
        }
        return Integer.parseInt(string);
    }

    @Deprecated
    public static int getIntHeader(HttpMessage httpMessage, String string, int n2) {
        return httpMessage.headers().getInt(string, n2);
    }

    @Deprecated
    public static int getIntHeader(HttpMessage httpMessage, CharSequence charSequence, int n2) {
        return httpMessage.headers().getInt(charSequence, n2);
    }

    @Deprecated
    public static void setIntHeader(HttpMessage httpMessage, String string, int n2) {
        httpMessage.headers().setInt(string, n2);
    }

    @Deprecated
    public static void setIntHeader(HttpMessage httpMessage, CharSequence charSequence, int n2) {
        httpMessage.headers().setInt(charSequence, n2);
    }

    @Deprecated
    public static void setIntHeader(HttpMessage httpMessage, String string, Iterable<Integer> iterable) {
        httpMessage.headers().set(string, iterable);
    }

    @Deprecated
    public static void setIntHeader(HttpMessage httpMessage, CharSequence charSequence, Iterable<Integer> iterable) {
        httpMessage.headers().set(charSequence, iterable);
    }

    @Deprecated
    public static void addIntHeader(HttpMessage httpMessage, String string, int n2) {
        httpMessage.headers().add(string, (Object)n2);
    }

    @Deprecated
    public static void addIntHeader(HttpMessage httpMessage, CharSequence charSequence, int n2) {
        httpMessage.headers().addInt(charSequence, n2);
    }

    @Deprecated
    public static Date getDateHeader(HttpMessage httpMessage, String string) {
        return HttpHeaders.getDateHeader(httpMessage, (CharSequence)string);
    }

    @Deprecated
    public static Date getDateHeader(HttpMessage httpMessage, CharSequence charSequence) {
        String string = httpMessage.headers().get(charSequence);
        if (string == null) {
            throw new ParseException("header not found: " + charSequence, 0);
        }
        Date date = DateFormatter.parseHttpDate(string);
        if (date == null) {
            throw new ParseException("header can't be parsed into a Date: " + string, 0);
        }
        return date;
    }

    @Deprecated
    public static Date getDateHeader(HttpMessage httpMessage, String string, Date date) {
        return HttpHeaders.getDateHeader(httpMessage, (CharSequence)string, date);
    }

    @Deprecated
    public static Date getDateHeader(HttpMessage httpMessage, CharSequence charSequence, Date date) {
        String string = HttpHeaders.getHeader(httpMessage, charSequence);
        Date date2 = DateFormatter.parseHttpDate(string);
        return date2 != null ? date2 : date;
    }

    @Deprecated
    public static void setDateHeader(HttpMessage httpMessage, String string, Date date) {
        HttpHeaders.setDateHeader(httpMessage, (CharSequence)string, date);
    }

    @Deprecated
    public static void setDateHeader(HttpMessage httpMessage, CharSequence charSequence, Date date) {
        if (date != null) {
            httpMessage.headers().set(charSequence, (Object)DateFormatter.format(date));
        } else {
            httpMessage.headers().set(charSequence, null);
        }
    }

    @Deprecated
    public static void setDateHeader(HttpMessage httpMessage, String string, Iterable<Date> iterable) {
        httpMessage.headers().set(string, iterable);
    }

    @Deprecated
    public static void setDateHeader(HttpMessage httpMessage, CharSequence charSequence, Iterable<Date> iterable) {
        httpMessage.headers().set(charSequence, iterable);
    }

    @Deprecated
    public static void addDateHeader(HttpMessage httpMessage, String string, Date date) {
        httpMessage.headers().add(string, (Object)date);
    }

    @Deprecated
    public static void addDateHeader(HttpMessage httpMessage, CharSequence charSequence, Date date) {
        httpMessage.headers().add(charSequence, (Object)date);
    }

    @Deprecated
    public static long getContentLength(HttpMessage httpMessage) {
        return HttpUtil.getContentLength(httpMessage);
    }

    @Deprecated
    public static long getContentLength(HttpMessage httpMessage, long l2) {
        return HttpUtil.getContentLength(httpMessage, l2);
    }

    @Deprecated
    public static void setContentLength(HttpMessage httpMessage, long l2) {
        HttpUtil.setContentLength(httpMessage, l2);
    }

    @Deprecated
    public static String getHost(HttpMessage httpMessage) {
        return httpMessage.headers().get(HttpHeaderNames.HOST);
    }

    @Deprecated
    public static String getHost(HttpMessage httpMessage, String string) {
        return httpMessage.headers().get(HttpHeaderNames.HOST, string);
    }

    @Deprecated
    public static void setHost(HttpMessage httpMessage, String string) {
        httpMessage.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)string);
    }

    @Deprecated
    public static void setHost(HttpMessage httpMessage, CharSequence charSequence) {
        httpMessage.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)charSequence);
    }

    @Deprecated
    public static Date getDate(HttpMessage httpMessage) {
        return HttpHeaders.getDateHeader(httpMessage, HttpHeaderNames.DATE);
    }

    @Deprecated
    public static Date getDate(HttpMessage httpMessage, Date date) {
        return HttpHeaders.getDateHeader(httpMessage, HttpHeaderNames.DATE, date);
    }

    @Deprecated
    public static void setDate(HttpMessage httpMessage, Date date) {
        httpMessage.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)date);
    }

    @Deprecated
    public static boolean is100ContinueExpected(HttpMessage httpMessage) {
        return HttpUtil.is100ContinueExpected(httpMessage);
    }

    @Deprecated
    public static void set100ContinueExpected(HttpMessage httpMessage) {
        HttpUtil.set100ContinueExpected(httpMessage, true);
    }

    @Deprecated
    public static void set100ContinueExpected(HttpMessage httpMessage, boolean bl2) {
        HttpUtil.set100ContinueExpected(httpMessage, bl2);
    }

    @Deprecated
    public static boolean isTransferEncodingChunked(HttpMessage httpMessage) {
        return HttpUtil.isTransferEncodingChunked(httpMessage);
    }

    @Deprecated
    public static void removeTransferEncodingChunked(HttpMessage httpMessage) {
        HttpUtil.setTransferEncodingChunked(httpMessage, false);
    }

    @Deprecated
    public static void setTransferEncodingChunked(HttpMessage httpMessage) {
        HttpUtil.setTransferEncodingChunked(httpMessage, true);
    }

    @Deprecated
    public static boolean isContentLengthSet(HttpMessage httpMessage) {
        return HttpUtil.isContentLengthSet(httpMessage);
    }

    @Deprecated
    public static boolean equalsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return AsciiString.contentEqualsIgnoreCase(charSequence, charSequence2);
    }

    @Deprecated
    public static void encodeAscii(CharSequence charSequence, ByteBuf byteBuf) {
        if (charSequence instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)charSequence, 0, byteBuf, charSequence.length());
        } else {
            byteBuf.writeCharSequence(charSequence, CharsetUtil.US_ASCII);
        }
    }

    @Deprecated
    public static CharSequence newEntity(String string) {
        return new AsciiString(string);
    }

    protected HttpHeaders() {
    }

    public abstract String get(String var1);

    public String get(CharSequence charSequence) {
        return this.get(charSequence.toString());
    }

    public String get(CharSequence charSequence, String string) {
        String string2 = this.get(charSequence);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public abstract Integer getInt(CharSequence var1);

    public abstract int getInt(CharSequence var1, int var2);

    public abstract Short getShort(CharSequence var1);

    public abstract short getShort(CharSequence var1, short var2);

    public abstract Long getTimeMillis(CharSequence var1);

    public abstract long getTimeMillis(CharSequence var1, long var2);

    public abstract List<String> getAll(String var1);

    public List<String> getAll(CharSequence charSequence) {
        return this.getAll(charSequence.toString());
    }

    public abstract List<Map.Entry<String, String>> entries();

    public abstract boolean contains(String var1);

    @Override
    @Deprecated
    public abstract Iterator<Map.Entry<String, String>> iterator();

    public abstract Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence();

    public Iterator<String> valueStringIterator(CharSequence charSequence) {
        return this.getAll(charSequence).iterator();
    }

    public Iterator<? extends CharSequence> valueCharSequenceIterator(CharSequence charSequence) {
        return this.valueStringIterator(charSequence);
    }

    public boolean contains(CharSequence charSequence) {
        return this.contains(charSequence.toString());
    }

    public abstract boolean isEmpty();

    public abstract int size();

    public abstract Set<String> names();

    public abstract HttpHeaders add(String var1, Object var2);

    public HttpHeaders add(CharSequence charSequence, Object object) {
        return this.add(charSequence.toString(), object);
    }

    public abstract HttpHeaders add(String var1, Iterable<?> var2);

    public HttpHeaders add(CharSequence charSequence, Iterable<?> iterable) {
        return this.add(charSequence.toString(), iterable);
    }

    public HttpHeaders add(HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            throw new NullPointerException("headers");
        }
        for (Map.Entry<String, String> entry : httpHeaders) {
            this.add(entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    public abstract HttpHeaders addInt(CharSequence var1, int var2);

    public abstract HttpHeaders addShort(CharSequence var1, short var2);

    public abstract HttpHeaders set(String var1, Object var2);

    public HttpHeaders set(CharSequence charSequence, Object object) {
        return this.set(charSequence.toString(), object);
    }

    public abstract HttpHeaders set(String var1, Iterable<?> var2);

    public HttpHeaders set(CharSequence charSequence, Iterable<?> iterable) {
        return this.set(charSequence.toString(), iterable);
    }

    public HttpHeaders set(HttpHeaders httpHeaders) {
        ObjectUtil.checkNotNull(httpHeaders, "headers");
        this.clear();
        if (httpHeaders.isEmpty()) {
            return this;
        }
        for (Map.Entry<String, String> entry : httpHeaders) {
            this.add(entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    public HttpHeaders setAll(HttpHeaders httpHeaders) {
        ObjectUtil.checkNotNull(httpHeaders, "headers");
        if (httpHeaders.isEmpty()) {
            return this;
        }
        for (Map.Entry<String, String> entry : httpHeaders) {
            this.set(entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    public abstract HttpHeaders setInt(CharSequence var1, int var2);

    public abstract HttpHeaders setShort(CharSequence var1, short var2);

    public abstract HttpHeaders remove(String var1);

    public HttpHeaders remove(CharSequence charSequence) {
        return this.remove(charSequence.toString());
    }

    public abstract HttpHeaders clear();

    public boolean contains(String string, String string2, boolean bl2) {
        Iterator<String> iterator = this.valueStringIterator(string);
        if (bl2) {
            while (iterator.hasNext()) {
                if (!iterator.next().equalsIgnoreCase(string2)) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!iterator.next().equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsValue(CharSequence charSequence, CharSequence charSequence2, boolean bl2) {
        Iterator<? extends CharSequence> iterator = this.valueCharSequenceIterator(charSequence);
        while (iterator.hasNext()) {
            if (!HttpHeaders.containsCommaSeparatedTrimmed(iterator.next(), charSequence2, bl2)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCommaSeparatedTrimmed(CharSequence charSequence, CharSequence charSequence2, boolean bl2) {
        int n2 = 0;
        if (bl2) {
            int n3 = AsciiString.indexOf(charSequence, ',', n2);
            if (n3 == -1) {
                if (AsciiString.contentEqualsIgnoreCase(AsciiString.trim(charSequence), charSequence2)) {
                    return true;
                }
            } else {
                do {
                    if (!AsciiString.contentEqualsIgnoreCase(AsciiString.trim(charSequence.subSequence(n2, n3)), charSequence2)) continue;
                    return true;
                } while ((n3 = AsciiString.indexOf(charSequence, ',', n2 = n3 + 1)) != -1);
                if (n2 < charSequence.length() && AsciiString.contentEqualsIgnoreCase(AsciiString.trim(charSequence.subSequence(n2, charSequence.length())), charSequence2)) {
                    return true;
                }
            }
        } else {
            int n4 = AsciiString.indexOf(charSequence, ',', n2);
            if (n4 == -1) {
                if (AsciiString.contentEquals(AsciiString.trim(charSequence), charSequence2)) {
                    return true;
                }
            } else {
                do {
                    if (!AsciiString.contentEquals(AsciiString.trim(charSequence.subSequence(n2, n4)), charSequence2)) continue;
                    return true;
                } while ((n4 = AsciiString.indexOf(charSequence, ',', n2 = n4 + 1)) != -1);
                if (n2 < charSequence.length() && AsciiString.contentEquals(AsciiString.trim(charSequence.subSequence(n2, charSequence.length())), charSequence2)) {
                    return true;
                }
            }
        }
        return false;
    }

    public final String getAsString(CharSequence charSequence) {
        return this.get(charSequence);
    }

    public final List<String> getAllAsString(CharSequence charSequence) {
        return this.getAll(charSequence);
    }

    public final Iterator<Map.Entry<String, String>> iteratorAsString() {
        return this.iterator();
    }

    public boolean contains(CharSequence charSequence, CharSequence charSequence2, boolean bl2) {
        return this.contains(charSequence.toString(), charSequence2.toString(), bl2);
    }

    public String toString() {
        return HeadersUtils.toString(this.getClass(), this.iteratorCharSequence(), this.size());
    }

    public HttpHeaders copy() {
        return new DefaultHttpHeaders().set(this);
    }
}

