/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.ComposedLastHttpContent;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecoder;
import io.netty.handler.codec.http.HttpContentEncoder$Result;
import io.netty.handler.codec.http.HttpContentEncoder$State;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public abstract class HttpContentEncoder
extends MessageToMessageCodec<HttpRequest, HttpObject> {
    private static final CharSequence ZERO_LENGTH_HEAD = "HEAD";
    private static final CharSequence ZERO_LENGTH_CONNECT = "CONNECT";
    private static final int CONTINUE_CODE = HttpResponseStatus.CONTINUE.code();
    private final Queue<CharSequence> acceptEncodingQueue = new ArrayDeque<CharSequence>();
    private EmbeddedChannel encoder;
    private HttpContentEncoder$State state = HttpContentEncoder$State.AWAIT_HEADERS;

    @Override
    public boolean acceptOutboundMessage(Object object) {
        return object instanceof HttpContent || object instanceof HttpResponse;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest, List<Object> list) {
        HttpMethod httpMethod;
        CharSequence charSequence = httpRequest.headers().get(HttpHeaderNames.ACCEPT_ENCODING);
        if (charSequence == null) {
            charSequence = HttpContentDecoder.IDENTITY;
        }
        if ((httpMethod = httpRequest.method()) == HttpMethod.HEAD) {
            charSequence = ZERO_LENGTH_HEAD;
        } else if (httpMethod == HttpMethod.CONNECT) {
            charSequence = ZERO_LENGTH_CONNECT;
        }
        this.acceptEncodingQueue.add(charSequence);
        list.add(ReferenceCountUtil.retain(httpRequest));
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        boolean bl2 = httpObject instanceof HttpResponse && httpObject instanceof LastHttpContent;
        switch (this.state) {
            case AWAIT_HEADERS: {
                CharSequence charSequence;
                HttpContentEncoder.ensureHeaders(httpObject);
                assert (this.encoder == null);
                HttpResponse httpResponse = (HttpResponse)httpObject;
                int n2 = httpResponse.status().code();
                if (n2 == CONTINUE_CODE) {
                    charSequence = null;
                } else {
                    charSequence = this.acceptEncodingQueue.poll();
                    if (charSequence == null) {
                        throw new IllegalStateException("cannot send more responses than requests");
                    }
                }
                if (HttpContentEncoder.isPassthru(httpResponse.protocolVersion(), n2, charSequence)) {
                    if (bl2) {
                        list.add(ReferenceCountUtil.retain(httpResponse));
                        break;
                    }
                    list.add(httpResponse);
                    this.state = HttpContentEncoder$State.PASS_THROUGH;
                    break;
                }
                if (bl2 && !((ByteBufHolder)((Object)httpResponse)).content().isReadable()) {
                    list.add(ReferenceCountUtil.retain(httpResponse));
                    break;
                }
                HttpContentEncoder$Result httpContentEncoder$Result = this.beginEncode(httpResponse, charSequence.toString());
                if (httpContentEncoder$Result == null) {
                    if (bl2) {
                        list.add(ReferenceCountUtil.retain(httpResponse));
                        break;
                    }
                    list.add(httpResponse);
                    this.state = HttpContentEncoder$State.PASS_THROUGH;
                    break;
                }
                this.encoder = httpContentEncoder$Result.contentEncoder();
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)httpContentEncoder$Result.targetContentEncoding());
                if (bl2) {
                    DefaultHttpResponse defaultHttpResponse = new DefaultHttpResponse(httpResponse.protocolVersion(), httpResponse.status());
                    defaultHttpResponse.headers().set(httpResponse.headers());
                    list.add(defaultHttpResponse);
                    HttpContentEncoder.ensureContent(httpResponse);
                    this.encodeFullResponse(defaultHttpResponse, (HttpContent)((Object)httpResponse), list);
                    break;
                }
                httpResponse.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
                httpResponse.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                list.add(httpResponse);
                this.state = HttpContentEncoder$State.AWAIT_CONTENT;
                if (!(httpObject instanceof HttpContent)) break;
            }
            case AWAIT_CONTENT: {
                HttpContentEncoder.ensureContent(httpObject);
                if (!this.encodeContent((HttpContent)httpObject, list)) break;
                this.state = HttpContentEncoder$State.AWAIT_HEADERS;
                break;
            }
            case PASS_THROUGH: {
                HttpContentEncoder.ensureContent(httpObject);
                list.add(ReferenceCountUtil.retain(httpObject));
                if (!(httpObject instanceof LastHttpContent)) break;
                this.state = HttpContentEncoder$State.AWAIT_HEADERS;
            }
        }
    }

    private void encodeFullResponse(HttpResponse httpResponse, HttpContent httpContent, List<Object> list) {
        int n2 = list.size();
        this.encodeContent(httpContent, list);
        if (HttpUtil.isContentLengthSet(httpResponse)) {
            int n3 = 0;
            for (int i2 = n2; i2 < list.size(); ++i2) {
                Object object = list.get(i2);
                if (!(object instanceof HttpContent)) continue;
                n3 += ((HttpContent)object).content().readableBytes();
            }
            HttpUtil.setContentLength(httpResponse, n3);
        } else {
            httpResponse.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
    }

    private static boolean isPassthru(HttpVersion httpVersion, int n2, CharSequence charSequence) {
        return n2 < 200 || n2 == 204 || n2 == 304 || charSequence == ZERO_LENGTH_HEAD || charSequence == ZERO_LENGTH_CONNECT && n2 == 200 || httpVersion == HttpVersion.HTTP_1_0;
    }

    private static void ensureHeaders(HttpObject httpObject) {
        if (!(httpObject instanceof HttpResponse)) {
            throw new IllegalStateException("unexpected message type: " + httpObject.getClass().getName() + " (expected: " + HttpResponse.class.getSimpleName() + ')');
        }
    }

    private static void ensureContent(HttpObject httpObject) {
        if (!(httpObject instanceof HttpContent)) {
            throw new IllegalStateException("unexpected message type: " + httpObject.getClass().getName() + " (expected: " + HttpContent.class.getSimpleName() + ')');
        }
    }

    private boolean encodeContent(HttpContent httpContent, List<Object> list) {
        ByteBuf byteBuf = httpContent.content();
        this.encode(byteBuf, list);
        if (httpContent instanceof LastHttpContent) {
            this.finishEncode(list);
            LastHttpContent lastHttpContent = (LastHttpContent)httpContent;
            HttpHeaders httpHeaders = lastHttpContent.trailingHeaders();
            if (httpHeaders.isEmpty()) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                list.add(new ComposedLastHttpContent(httpHeaders));
            }
            return true;
        }
        return false;
    }

    protected abstract HttpContentEncoder$Result beginEncode(HttpResponse var1, String var2);

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.cleanupSafely(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.cleanupSafely(channelHandlerContext);
        super.channelInactive(channelHandlerContext);
    }

    private void cleanup() {
        if (this.encoder != null) {
            this.encoder.finishAndReleaseAll();
            this.encoder = null;
        }
    }

    private void cleanupSafely(ChannelHandlerContext channelHandlerContext) {
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
    }

    private void encode(ByteBuf byteBuf, List<Object> list) {
        this.encoder.writeOutbound(byteBuf.retain());
        this.fetchEncoderOutput(list);
    }

    private void finishEncode(List<Object> list) {
        if (this.encoder.finish()) {
            this.fetchEncoderOutput(list);
        }
        this.encoder = null;
    }

    private void fetchEncoderOutput(List<Object> list) {
        ByteBuf byteBuf;
        while ((byteBuf = (ByteBuf)this.encoder.readOutbound()) != null) {
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                continue;
            }
            list.add(new DefaultHttpContent(byteBuf));
        }
    }
}

