/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentEncoder;
import io.netty.handler.codec.http.HttpContentEncoder$Result;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;

public class HttpContentCompressor
extends HttpContentEncoder {
    private final int compressionLevel;
    private final int windowBits;
    private final int memLevel;
    private final int contentSizeThreshold;
    private ChannelHandlerContext ctx;

    public HttpContentCompressor() {
        this(6);
    }

    public HttpContentCompressor(int n2) {
        this(n2, 15, 8, 0);
    }

    public HttpContentCompressor(int n2, int n3, int n4) {
        this(n2, n3, n4, 0);
    }

    public HttpContentCompressor(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || n2 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n2 + " (expected: 0-9)");
        }
        if (n3 < 9 || n3 > 15) {
            throw new IllegalArgumentException("windowBits: " + n3 + " (expected: 9-15)");
        }
        if (n4 < 1 || n4 > 9) {
            throw new IllegalArgumentException("memLevel: " + n4 + " (expected: 1-9)");
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("contentSizeThreshold: " + n5 + " (expected: non negative number)");
        }
        this.compressionLevel = n2;
        this.windowBits = n3;
        this.memLevel = n4;
        this.contentSizeThreshold = n5;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    @Override
    protected HttpContentEncoder$Result beginEncode(HttpResponse httpResponse, String string) {
        String string2;
        if (this.contentSizeThreshold > 0 && httpResponse instanceof HttpContent && ((HttpContent)((Object)httpResponse)).content().readableBytes() < this.contentSizeThreshold) {
            return null;
        }
        String string3 = httpResponse.headers().get(HttpHeaderNames.CONTENT_ENCODING);
        if (string3 != null) {
            return null;
        }
        ZlibWrapper zlibWrapper = this.determineWrapper(string);
        if (zlibWrapper == null) {
            return null;
        }
        switch (zlibWrapper) {
            case GZIP: {
                string2 = "gzip";
                break;
            }
            case ZLIB: {
                string2 = "deflate";
                break;
            }
            default: {
                throw new Error();
            }
        }
        return new HttpContentEncoder$Result(string2, new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibEncoder(zlibWrapper, this.compressionLevel, this.windowBits, this.memLevel)));
    }

    protected ZlibWrapper determineWrapper(String string) {
        float f2 = -1.0f;
        float f3 = -1.0f;
        float f4 = -1.0f;
        for (String string2 : string.split(",")) {
            float f5 = 1.0f;
            int n2 = string2.indexOf(61);
            if (n2 != -1) {
                try {
                    f5 = Float.parseFloat(string2.substring(n2 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    f5 = 0.0f;
                }
            }
            if (string2.contains("*")) {
                f2 = f5;
                continue;
            }
            if (string2.contains("gzip") && f5 > f3) {
                f3 = f5;
                continue;
            }
            if (!string2.contains("deflate") || !(f5 > f4)) continue;
            f4 = f5;
        }
        if (f3 > 0.0f || f4 > 0.0f) {
            if (f3 >= f4) {
                return ZlibWrapper.GZIP;
            }
            return ZlibWrapper.ZLIB;
        }
        if (f2 > 0.0f) {
            if (f3 == -1.0f) {
                return ZlibWrapper.GZIP;
            }
            if (f4 == -1.0f) {
                return ZlibWrapper.ZLIB;
            }
        }
        return null;
    }
}

