/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessageUtil;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.internal.ObjectUtil;

public class DefaultHttpRequest
extends DefaultHttpMessage
implements HttpRequest {
    private static final int HASH_CODE_PRIME = 31;
    private HttpMethod method;
    private String uri;

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string) {
        this(httpVersion, httpMethod, string, true);
    }

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, boolean bl2) {
        super(httpVersion, bl2, false);
        this.method = ObjectUtil.checkNotNull(httpMethod, "method");
        this.uri = ObjectUtil.checkNotNull(string, "uri");
    }

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, HttpHeaders httpHeaders) {
        super(httpVersion, httpHeaders);
        this.method = ObjectUtil.checkNotNull(httpMethod, "method");
        this.uri = ObjectUtil.checkNotNull(string, "uri");
    }

    @Override
    @Deprecated
    public HttpMethod getMethod() {
        return this.method();
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    @Deprecated
    public String getUri() {
        return this.uri();
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public HttpRequest setMethod(HttpMethod httpMethod) {
        if (httpMethod == null) {
            throw new NullPointerException("method");
        }
        this.method = httpMethod;
        return this;
    }

    @Override
    public HttpRequest setUri(String string) {
        if (string == null) {
            throw new NullPointerException("uri");
        }
        this.uri = string;
        return this;
    }

    @Override
    public HttpRequest setProtocolVersion(HttpVersion httpVersion) {
        super.setProtocolVersion(httpVersion);
        return this;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.method.hashCode();
        n2 = 31 * n2 + this.uri.hashCode();
        n2 = 31 * n2 + super.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttpRequest)) {
            return false;
        }
        DefaultHttpRequest defaultHttpRequest = (DefaultHttpRequest)object;
        return this.method().equals(defaultHttpRequest.method()) && this.uri().equalsIgnoreCase(defaultHttpRequest.uri()) && super.equals(object);
    }

    public String toString() {
        return HttpMessageUtil.appendRequest(new StringBuilder(256), this).toString();
    }
}

