/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.CombinedHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpObject;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.internal.ObjectUtil;

public abstract class DefaultHttpMessage
extends DefaultHttpObject
implements HttpMessage {
    private static final int HASH_CODE_PRIME = 31;
    private HttpVersion version;
    private final HttpHeaders headers;

    protected DefaultHttpMessage(HttpVersion httpVersion) {
        this(httpVersion, true, false);
    }

    protected DefaultHttpMessage(HttpVersion httpVersion, boolean bl2, boolean bl3) {
        this(httpVersion, bl3 ? new CombinedHttpHeaders(bl2) : new DefaultHttpHeaders(bl2));
    }

    protected DefaultHttpMessage(HttpVersion httpVersion, HttpHeaders httpHeaders) {
        this.version = ObjectUtil.checkNotNull(httpVersion, "version");
        this.headers = ObjectUtil.checkNotNull(httpHeaders, "headers");
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    @Deprecated
    public HttpVersion getProtocolVersion() {
        return this.protocolVersion();
    }

    @Override
    public HttpVersion protocolVersion() {
        return this.version;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.headers.hashCode();
        n2 = 31 * n2 + this.version.hashCode();
        n2 = 31 * n2 + super.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttpMessage)) {
            return false;
        }
        DefaultHttpMessage defaultHttpMessage = (DefaultHttpMessage)object;
        return this.headers().equals(defaultHttpMessage.headers()) && this.protocolVersion().equals(defaultHttpMessage.protocolVersion()) && super.equals(object);
    }

    @Override
    public HttpMessage setProtocolVersion(HttpVersion httpVersion) {
        if (httpVersion == null) {
            throw new NullPointerException("version");
        }
        this.version = httpVersion;
        return this;
    }
}

