/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.DefaultHeaders$NameValidator;
import io.netty.handler.codec.DefaultHeadersImpl;
import io.netty.handler.codec.HeadersUtils;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.DefaultHttpHeaders$1;
import io.netty.handler.codec.http.DefaultHttpHeaders$2;
import io.netty.handler.codec.http.DefaultHttpHeaders$3;
import io.netty.handler.codec.http.DefaultHttpHeaders$HeaderValueConverter;
import io.netty.handler.codec.http.DefaultHttpHeaders$HeaderValueConverterAndValidator;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHttpHeaders
extends HttpHeaders {
    private static final int HIGHEST_INVALID_VALUE_CHAR_MASK = -16;
    private static final ByteProcessor HEADER_NAME_VALIDATOR = new DefaultHttpHeaders$1();
    static final DefaultHeaders$NameValidator<CharSequence> HttpNameValidator = new DefaultHttpHeaders$2();
    private final DefaultHeaders<CharSequence, CharSequence, ?> headers;

    public DefaultHttpHeaders() {
        this(true);
    }

    public DefaultHttpHeaders(boolean bl2) {
        this(bl2, DefaultHttpHeaders.nameValidator(bl2));
    }

    protected DefaultHttpHeaders(boolean bl2, DefaultHeaders$NameValidator<CharSequence> defaultHeaders$NameValidator) {
        this(new DefaultHeadersImpl<CharSequence, CharSequence>(AsciiString.CASE_INSENSITIVE_HASHER, DefaultHttpHeaders.valueConverter(bl2), defaultHeaders$NameValidator));
    }

    protected DefaultHttpHeaders(DefaultHeaders<CharSequence, CharSequence, ?> defaultHeaders) {
        this.headers = defaultHeaders;
    }

    @Override
    public HttpHeaders add(HttpHeaders httpHeaders) {
        if (httpHeaders instanceof DefaultHttpHeaders) {
            this.headers.add(((DefaultHttpHeaders)httpHeaders).headers);
            return this;
        }
        return super.add(httpHeaders);
    }

    @Override
    public HttpHeaders set(HttpHeaders httpHeaders) {
        if (httpHeaders instanceof DefaultHttpHeaders) {
            this.headers.set(((DefaultHttpHeaders)httpHeaders).headers);
            return this;
        }
        return super.set(httpHeaders);
    }

    @Override
    public HttpHeaders add(String string, Object object) {
        this.headers.addObject((CharSequence)string, object);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence charSequence, Object object) {
        this.headers.addObject(charSequence, object);
        return this;
    }

    @Override
    public HttpHeaders add(String string, Iterable<?> iterable) {
        this.headers.addObject((CharSequence)string, iterable);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence charSequence, Iterable<?> iterable) {
        this.headers.addObject(charSequence, iterable);
        return this;
    }

    @Override
    public HttpHeaders addInt(CharSequence charSequence, int n2) {
        this.headers.addInt(charSequence, n2);
        return this;
    }

    @Override
    public HttpHeaders addShort(CharSequence charSequence, short s2) {
        this.headers.addShort(charSequence, s2);
        return this;
    }

    @Override
    public HttpHeaders remove(String string) {
        this.headers.remove(string);
        return this;
    }

    @Override
    public HttpHeaders remove(CharSequence charSequence) {
        this.headers.remove(charSequence);
        return this;
    }

    @Override
    public HttpHeaders set(String string, Object object) {
        this.headers.setObject((CharSequence)string, object);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence charSequence, Object object) {
        this.headers.setObject(charSequence, object);
        return this;
    }

    @Override
    public HttpHeaders set(String string, Iterable<?> iterable) {
        this.headers.setObject((CharSequence)string, iterable);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence charSequence, Iterable<?> iterable) {
        this.headers.setObject(charSequence, iterable);
        return this;
    }

    @Override
    public HttpHeaders setInt(CharSequence charSequence, int n2) {
        this.headers.setInt(charSequence, n2);
        return this;
    }

    @Override
    public HttpHeaders setShort(CharSequence charSequence, short s2) {
        this.headers.setShort(charSequence, s2);
        return this;
    }

    @Override
    public HttpHeaders clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public String get(String string) {
        return this.get((CharSequence)string);
    }

    @Override
    public String get(CharSequence charSequence) {
        return HeadersUtils.getAsString(this.headers, charSequence);
    }

    @Override
    public Integer getInt(CharSequence charSequence) {
        return this.headers.getInt(charSequence);
    }

    @Override
    public int getInt(CharSequence charSequence, int n2) {
        return this.headers.getInt(charSequence, n2);
    }

    @Override
    public Short getShort(CharSequence charSequence) {
        return this.headers.getShort(charSequence);
    }

    @Override
    public short getShort(CharSequence charSequence, short s2) {
        return this.headers.getShort(charSequence, s2);
    }

    @Override
    public Long getTimeMillis(CharSequence charSequence) {
        return this.headers.getTimeMillis(charSequence);
    }

    @Override
    public long getTimeMillis(CharSequence charSequence, long l2) {
        return this.headers.getTimeMillis(charSequence, l2);
    }

    @Override
    public List<String> getAll(String string) {
        return this.getAll((CharSequence)string);
    }

    @Override
    public List<String> getAll(CharSequence charSequence) {
        return HeadersUtils.getAllAsString(this.headers, charSequence);
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(this.headers.size());
        for (Map.Entry<String, String> entry : this) {
            arrayList.add(entry);
        }
        return arrayList;
    }

    @Override
    @Deprecated
    public Iterator<Map.Entry<String, String>> iterator() {
        return HeadersUtils.iteratorAsString(this.headers);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return this.headers.iterator();
    }

    @Override
    public Iterator<String> valueStringIterator(CharSequence charSequence) {
        Iterator<CharSequence> iterator = this.valueCharSequenceIterator(charSequence);
        return new DefaultHttpHeaders$3(this, iterator);
    }

    public Iterator<CharSequence> valueCharSequenceIterator(CharSequence charSequence) {
        return this.headers.valueIterator(charSequence);
    }

    @Override
    public boolean contains(String string) {
        return this.contains((CharSequence)string);
    }

    @Override
    public boolean contains(CharSequence charSequence) {
        return this.headers.contains(charSequence);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean contains(String string, String string2, boolean bl2) {
        return this.contains((CharSequence)string, (CharSequence)string2, bl2);
    }

    @Override
    public boolean contains(CharSequence charSequence, CharSequence charSequence2, boolean bl2) {
        return this.headers.contains(charSequence, charSequence2, bl2 ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public Set<String> names() {
        return HeadersUtils.namesAsString(this.headers);
    }

    public boolean equals(Object object) {
        return object instanceof DefaultHttpHeaders && this.headers.equals(((DefaultHttpHeaders)object).headers, AsciiString.CASE_SENSITIVE_HASHER);
    }

    public int hashCode() {
        return this.headers.hashCode(AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public HttpHeaders copy() {
        return new DefaultHttpHeaders(this.headers.copy());
    }

    private static void validateHeaderNameElement(byte by2) {
        switch (by2) {
            case 0: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: 
            case 44: 
            case 58: 
            case 59: 
            case 61: {
                throw new IllegalArgumentException("a header name cannot contain the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + by2);
            }
        }
        if (by2 < 0) {
            throw new IllegalArgumentException("a header name cannot contain non-ASCII character: " + by2);
        }
    }

    private static void validateHeaderNameElement(char c2) {
        switch (c2) {
            case '\u0000': 
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case ';': 
            case '=': {
                throw new IllegalArgumentException("a header name cannot contain the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + c2);
            }
        }
        if (c2 > '\u007f') {
            throw new IllegalArgumentException("a header name cannot contain non-ASCII character: " + c2);
        }
    }

    static ValueConverter<CharSequence> valueConverter(boolean bl2) {
        return bl2 ? DefaultHttpHeaders$HeaderValueConverterAndValidator.INSTANCE : DefaultHttpHeaders$HeaderValueConverter.INSTANCE;
    }

    static DefaultHeaders$NameValidator<CharSequence> nameValidator(boolean bl2) {
        return bl2 ? HttpNameValidator : DefaultHeaders$NameValidator.NOT_NULL;
    }

    static /* synthetic */ void access$000(byte by2) {
        DefaultHttpHeaders.validateHeaderNameElement(by2);
    }

    static /* synthetic */ ByteProcessor access$100() {
        return HEADER_NAME_VALIDATOR;
    }

    static /* synthetic */ void access$200(char c2) {
        DefaultHttpHeaders.validateHeaderNameElement(c2);
    }
}

