/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessageUtil;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;

public class DefaultFullHttpRequest
extends DefaultHttpRequest
implements FullHttpRequest {
    private final ByteBuf content;
    private final HttpHeaders trailingHeader;
    private int hash;

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string) {
        this(httpVersion, httpMethod, string, Unpooled.buffer(0));
    }

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, ByteBuf byteBuf) {
        this(httpVersion, httpMethod, string, byteBuf, true);
    }

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, boolean bl2) {
        this(httpVersion, httpMethod, string, Unpooled.buffer(0), bl2);
    }

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, ByteBuf byteBuf, boolean bl2) {
        super(httpVersion, httpMethod, string, bl2);
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.trailingHeader = new DefaultHttpHeaders(bl2);
    }

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, ByteBuf byteBuf, HttpHeaders httpHeaders, HttpHeaders httpHeaders2) {
        super(httpVersion, httpMethod, string, httpHeaders);
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.trailingHeader = ObjectUtil.checkNotNull(httpHeaders2, "trailingHeader");
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeader;
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public FullHttpRequest retain() {
        this.content.retain();
        return this;
    }

    @Override
    public FullHttpRequest retain(int n2) {
        this.content.retain(n2);
        return this;
    }

    @Override
    public FullHttpRequest touch() {
        this.content.touch();
        return this;
    }

    @Override
    public FullHttpRequest touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public boolean release(int n2) {
        return this.content.release(n2);
    }

    @Override
    public FullHttpRequest setProtocolVersion(HttpVersion httpVersion) {
        super.setProtocolVersion(httpVersion);
        return this;
    }

    @Override
    public FullHttpRequest setMethod(HttpMethod httpMethod) {
        super.setMethod(httpMethod);
        return this;
    }

    @Override
    public FullHttpRequest setUri(String string) {
        super.setUri(string);
        return this;
    }

    @Override
    public FullHttpRequest copy() {
        return this.replace(this.content().copy());
    }

    @Override
    public FullHttpRequest duplicate() {
        return this.replace(this.content().duplicate());
    }

    @Override
    public FullHttpRequest retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public FullHttpRequest replace(ByteBuf byteBuf) {
        DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(this.protocolVersion(), this.method(), this.uri(), byteBuf, this.headers().copy(), this.trailingHeaders().copy());
        defaultFullHttpRequest.setDecoderResult(this.decoderResult());
        return defaultFullHttpRequest;
    }

    @Override
    public int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            if (this.content().refCnt() != 0) {
                try {
                    n2 = 31 + this.content().hashCode();
                }
                catch (IllegalReferenceCountException illegalReferenceCountException) {
                    n2 = 31;
                }
            } else {
                n2 = 31;
            }
            n2 = 31 * n2 + this.trailingHeaders().hashCode();
            this.hash = n2 = 31 * n2 + super.hashCode();
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultFullHttpRequest)) {
            return false;
        }
        DefaultFullHttpRequest defaultFullHttpRequest = (DefaultFullHttpRequest)object;
        return super.equals(defaultFullHttpRequest) && this.content().equals(defaultFullHttpRequest.content()) && this.trailingHeaders().equals(defaultFullHttpRequest.trailingHeaders());
    }

    @Override
    public String toString() {
        return HttpMessageUtil.appendFullRequest(new StringBuilder(256), this).toString();
    }
}

