/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.DefaultHeaders$NameValidator;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.CombinedHttpHeaders$CombinedHttpHeadersImpl$1;
import io.netty.handler.codec.http.CombinedHttpHeaders$CombinedHttpHeadersImpl$2;
import io.netty.handler.codec.http.CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.StringUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class CombinedHttpHeaders$CombinedHttpHeadersImpl
extends DefaultHeaders<CharSequence, CharSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl> {
    private static final int VALUE_LENGTH_ESTIMATE = 10;
    private CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper<Object> objectEscaper;
    private CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper<CharSequence> charSequenceEscaper;

    private CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper<Object> objectEscaper() {
        if (this.objectEscaper == null) {
            this.objectEscaper = new CombinedHttpHeaders$CombinedHttpHeadersImpl$1(this);
        }
        return this.objectEscaper;
    }

    private CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper<CharSequence> charSequenceEscaper() {
        if (this.charSequenceEscaper == null) {
            this.charSequenceEscaper = new CombinedHttpHeaders$CombinedHttpHeadersImpl$2(this);
        }
        return this.charSequenceEscaper;
    }

    public CombinedHttpHeaders$CombinedHttpHeadersImpl(HashingStrategy<CharSequence> hashingStrategy, ValueConverter<CharSequence> valueConverter, DefaultHeaders$NameValidator<CharSequence> defaultHeaders$NameValidator) {
        super(hashingStrategy, valueConverter, defaultHeaders$NameValidator);
    }

    @Override
    public Iterator<CharSequence> valueIterator(CharSequence charSequence) {
        Iterator<CharSequence> iterator = super.valueIterator(charSequence);
        if (!iterator.hasNext()) {
            return iterator;
        }
        Iterator<CharSequence> iterator2 = StringUtil.unescapeCsvFields(iterator.next()).iterator();
        if (iterator.hasNext()) {
            throw new IllegalStateException("CombinedHttpHeaders should only have one value");
        }
        return iterator2;
    }

    @Override
    public List<CharSequence> getAll(CharSequence charSequence) {
        List<CharSequence> list = super.getAll(charSequence);
        if (list.isEmpty()) {
            return list;
        }
        if (list.size() != 1) {
            throw new IllegalStateException("CombinedHttpHeaders should only have one value");
        }
        return StringUtil.unescapeCsvFields(list.get(0));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        if (headers == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        if (headers instanceof CombinedHttpHeaders$CombinedHttpHeadersImpl) {
            if (this.isEmpty()) {
                this.addImpl(headers);
            } else {
                for (Map.Entry<CharSequence, CharSequence> entry : headers) {
                    this.addEscapedValue(entry.getKey(), entry.getValue());
                }
            }
        } else {
            for (Map.Entry<CharSequence, CharSequence> entry : headers) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        if (headers == this) {
            return this;
        }
        this.clear();
        return this.add((Headers)headers);
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        if (headers == this) {
            return this;
        }
        for (CharSequence charSequence : headers.names()) {
            this.remove(charSequence);
        }
        return this.add(headers);
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl add(CharSequence charSequence, CharSequence charSequence2) {
        return this.addEscapedValue(charSequence, this.charSequenceEscaper().escape(charSequence2));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl add(CharSequence charSequence, CharSequence ... charSequenceArray) {
        return this.addEscapedValue(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(this.charSequenceEscaper(), charSequenceArray));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl add(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        return this.addEscapedValue(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(this.charSequenceEscaper(), iterable));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl addObject(CharSequence charSequence, Object object) {
        return this.addEscapedValue(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), object));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl addObject(CharSequence charSequence, Iterable<?> iterable) {
        return this.addEscapedValue(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), iterable));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl addObject(CharSequence charSequence, Object ... objectArray) {
        return this.addEscapedValue(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), objectArray));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl set(CharSequence charSequence, CharSequence ... charSequenceArray) {
        super.set(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(this.charSequenceEscaper(), charSequenceArray));
        return this;
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl set(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        super.set(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(this.charSequenceEscaper(), iterable));
        return this;
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl setObject(CharSequence charSequence, Object object) {
        super.set(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), object));
        return this;
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl setObject(CharSequence charSequence, Object ... objectArray) {
        super.set(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), objectArray));
        return this;
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl setObject(CharSequence charSequence, Iterable<?> iterable) {
        super.set(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), iterable));
        return this;
    }

    private CombinedHttpHeaders$CombinedHttpHeadersImpl addEscapedValue(CharSequence charSequence, CharSequence charSequence2) {
        CharSequence charSequence3 = (CharSequence)super.get(charSequence);
        if (charSequence3 == null) {
            super.add(charSequence, charSequence2);
        } else {
            super.set(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparateEscapedValues(charSequence3, charSequence2));
        }
        return this;
    }

    private static <T> CharSequence commaSeparate(CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper<T> combinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper, T ... TArray) {
        StringBuilder stringBuilder = new StringBuilder(TArray.length * 10);
        if (TArray.length > 0) {
            int n2 = TArray.length - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(combinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper.escape(TArray[i2])).append(',');
            }
            stringBuilder.append(combinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper.escape(TArray[n2]));
        }
        return stringBuilder;
    }

    private static <T> CharSequence commaSeparate(CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper<T> combinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper, Iterable<? extends T> iterable) {
        StringBuilder stringBuilder = iterable instanceof Collection ? new StringBuilder(((Collection)iterable).size() * 10) : new StringBuilder();
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T t2 = iterator.next();
            while (iterator.hasNext()) {
                stringBuilder.append(combinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper.escape(t2)).append(',');
                t2 = iterator.next();
            }
            stringBuilder.append(combinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper.escape(t2));
        }
        return stringBuilder;
    }

    private static CharSequence commaSeparateEscapedValues(CharSequence charSequence, CharSequence charSequence2) {
        return new StringBuilder(charSequence.length() + 1 + charSequence2.length()).append(charSequence).append(',').append(charSequence2);
    }

    static /* synthetic */ ValueConverter access$000(CombinedHttpHeaders$CombinedHttpHeadersImpl combinedHttpHeaders$CombinedHttpHeadersImpl) {
        return combinedHttpHeaders$CombinedHttpHeadersImpl.valueConverter();
    }
}

