/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.handler.codec.dns.AbstractDnsMessage;
import io.netty.handler.codec.dns.DnsMessageUtil;
import io.netty.handler.codec.dns.DnsOpCode;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.util.internal.ObjectUtil;

public class DefaultDnsResponse
extends AbstractDnsMessage
implements DnsResponse {
    private boolean authoritativeAnswer;
    private boolean truncated;
    private boolean recursionAvailable;
    private DnsResponseCode code;

    public DefaultDnsResponse(int n2) {
        this(n2, DnsOpCode.QUERY, DnsResponseCode.NOERROR);
    }

    public DefaultDnsResponse(int n2, DnsOpCode dnsOpCode) {
        this(n2, dnsOpCode, DnsResponseCode.NOERROR);
    }

    public DefaultDnsResponse(int n2, DnsOpCode dnsOpCode, DnsResponseCode dnsResponseCode) {
        super(n2, dnsOpCode);
        this.setCode(dnsResponseCode);
    }

    @Override
    public boolean isAuthoritativeAnswer() {
        return this.authoritativeAnswer;
    }

    @Override
    public DnsResponse setAuthoritativeAnswer(boolean bl2) {
        this.authoritativeAnswer = bl2;
        return this;
    }

    @Override
    public boolean isTruncated() {
        return this.truncated;
    }

    @Override
    public DnsResponse setTruncated(boolean bl2) {
        this.truncated = bl2;
        return this;
    }

    @Override
    public boolean isRecursionAvailable() {
        return this.recursionAvailable;
    }

    @Override
    public DnsResponse setRecursionAvailable(boolean bl2) {
        this.recursionAvailable = bl2;
        return this;
    }

    @Override
    public DnsResponseCode code() {
        return this.code;
    }

    @Override
    public DnsResponse setCode(DnsResponseCode dnsResponseCode) {
        this.code = ObjectUtil.checkNotNull(dnsResponseCode, "code");
        return this;
    }

    @Override
    public DnsResponse setId(int n2) {
        return (DnsResponse)super.setId(n2);
    }

    @Override
    public DnsResponse setOpCode(DnsOpCode dnsOpCode) {
        return (DnsResponse)super.setOpCode(dnsOpCode);
    }

    @Override
    public DnsResponse setRecursionDesired(boolean bl2) {
        return (DnsResponse)super.setRecursionDesired(bl2);
    }

    @Override
    public DnsResponse setZ(int n2) {
        return (DnsResponse)super.setZ(n2);
    }

    @Override
    public DnsResponse setRecord(DnsSection dnsSection, DnsRecord dnsRecord) {
        return (DnsResponse)super.setRecord(dnsSection, dnsRecord);
    }

    @Override
    public DnsResponse addRecord(DnsSection dnsSection, DnsRecord dnsRecord) {
        return (DnsResponse)super.addRecord(dnsSection, dnsRecord);
    }

    @Override
    public DnsResponse addRecord(DnsSection dnsSection, int n2, DnsRecord dnsRecord) {
        return (DnsResponse)super.addRecord(dnsSection, n2, dnsRecord);
    }

    @Override
    public DnsResponse clear(DnsSection dnsSection) {
        return (DnsResponse)super.clear(dnsSection);
    }

    @Override
    public DnsResponse clear() {
        return (DnsResponse)super.clear();
    }

    @Override
    public DnsResponse touch() {
        return (DnsResponse)super.touch();
    }

    @Override
    public DnsResponse touch(Object object) {
        return (DnsResponse)super.touch(object);
    }

    @Override
    public DnsResponse retain() {
        return (DnsResponse)super.retain();
    }

    @Override
    public DnsResponse retain(int n2) {
        return (DnsResponse)super.retain(n2);
    }

    public String toString() {
        return DnsMessageUtil.appendResponse(new StringBuilder(128), this).toString();
    }
}

