/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.dns.DnsOptEcsRecord;
import io.netty.handler.codec.dns.DnsOptPseudoRecord;
import io.netty.handler.codec.dns.DnsPtrRecord;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordEncoder;
import io.netty.util.internal.StringUtil;

public class DefaultDnsRecordEncoder
implements DnsRecordEncoder {
    private static final int PREFIX_MASK = 7;

    protected DefaultDnsRecordEncoder() {
    }

    @Override
    public final void encodeQuestion(DnsQuestion dnsQuestion, ByteBuf byteBuf) {
        this.encodeName(dnsQuestion.name(), byteBuf);
        byteBuf.writeShort(dnsQuestion.type().intValue());
        byteBuf.writeShort(dnsQuestion.dnsClass());
    }

    @Override
    public void encodeRecord(DnsRecord dnsRecord, ByteBuf byteBuf) {
        if (dnsRecord instanceof DnsQuestion) {
            this.encodeQuestion((DnsQuestion)dnsRecord, byteBuf);
        } else if (dnsRecord instanceof DnsPtrRecord) {
            this.encodePtrRecord((DnsPtrRecord)dnsRecord, byteBuf);
        } else if (dnsRecord instanceof DnsOptEcsRecord) {
            this.encodeOptEcsRecord((DnsOptEcsRecord)dnsRecord, byteBuf);
        } else if (dnsRecord instanceof DnsOptPseudoRecord) {
            this.encodeOptPseudoRecord((DnsOptPseudoRecord)dnsRecord, byteBuf);
        } else if (dnsRecord instanceof DnsRawRecord) {
            this.encodeRawRecord((DnsRawRecord)dnsRecord, byteBuf);
        } else {
            throw new UnsupportedMessageTypeException(StringUtil.simpleClassName(dnsRecord));
        }
    }

    private void encodeRecord0(DnsRecord dnsRecord, ByteBuf byteBuf) {
        this.encodeName(dnsRecord.name(), byteBuf);
        byteBuf.writeShort(dnsRecord.type().intValue());
        byteBuf.writeShort(dnsRecord.dnsClass());
        byteBuf.writeInt((int)dnsRecord.timeToLive());
    }

    private void encodePtrRecord(DnsPtrRecord dnsPtrRecord, ByteBuf byteBuf) {
        this.encodeRecord0(dnsPtrRecord, byteBuf);
        this.encodeName(dnsPtrRecord.hostname(), byteBuf);
    }

    private void encodeOptPseudoRecord(DnsOptPseudoRecord dnsOptPseudoRecord, ByteBuf byteBuf) {
        this.encodeRecord0(dnsOptPseudoRecord, byteBuf);
        byteBuf.writeShort(0);
    }

    private void encodeOptEcsRecord(DnsOptEcsRecord dnsOptEcsRecord, ByteBuf byteBuf) {
        this.encodeRecord0(dnsOptEcsRecord, byteBuf);
        int n2 = dnsOptEcsRecord.sourcePrefixLength();
        int n3 = dnsOptEcsRecord.scopePrefixLength();
        int n4 = n2 & 7;
        byte[] byArray = dnsOptEcsRecord.address();
        int n5 = byArray.length << 3;
        if (n5 < n2 || n2 < 0) {
            throw new IllegalArgumentException(n2 + ": " + n2 + " (expected: 0 >= " + n5 + ')');
        }
        short s2 = (short)(byArray.length == 4 ? InternetProtocolFamily.IPv4.addressNumber() : InternetProtocolFamily.IPv6.addressNumber());
        int n6 = DefaultDnsRecordEncoder.calculateEcsAddressLength(n2, n4);
        int n7 = 8 + n6;
        byteBuf.writeShort(n7);
        byteBuf.writeShort(8);
        byteBuf.writeShort(n7 - 4);
        byteBuf.writeShort(s2);
        byteBuf.writeByte(n2);
        byteBuf.writeByte(n3);
        if (n4 > 0) {
            int n8 = n6 - 1;
            byteBuf.writeBytes(byArray, 0, n8);
            byteBuf.writeByte(DefaultDnsRecordEncoder.padWithZeros(byArray[n8], n4));
        } else {
            byteBuf.writeBytes(byArray, 0, n6);
        }
    }

    static int calculateEcsAddressLength(int n2, int n3) {
        return (n2 >>> 3) + (n3 != 0 ? 1 : 0);
    }

    private void encodeRawRecord(DnsRawRecord dnsRawRecord, ByteBuf byteBuf) {
        this.encodeRecord0(dnsRawRecord, byteBuf);
        ByteBuf byteBuf2 = dnsRawRecord.content();
        int n2 = byteBuf2.readableBytes();
        byteBuf.writeShort(n2);
        byteBuf.writeBytes(byteBuf2, byteBuf2.readerIndex(), n2);
    }

    protected void encodeName(String string, ByteBuf byteBuf) {
        String string2;
        int n2;
        String[] stringArray;
        if (".".equals(string)) {
            byteBuf.writeByte(0);
            return;
        }
        String[] stringArray2 = stringArray = string.split("\\.");
        int n3 = stringArray2.length;
        for (int i2 = 0; i2 < n3 && (n2 = (string2 = stringArray2[i2]).length()) != 0; ++i2) {
            byteBuf.writeByte(n2);
            ByteBufUtil.writeAscii(byteBuf, (CharSequence)string2);
        }
        byteBuf.writeByte(0);
    }

    private static byte padWithZeros(byte by2, int n2) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                return (byte)(0x80 & by2);
            }
            case 2: {
                return (byte)(0xC0 & by2);
            }
            case 3: {
                return (byte)(0xE0 & by2);
            }
            case 4: {
                return (byte)(0xF0 & by2);
            }
            case 5: {
                return (byte)(0xF8 & by2);
            }
            case 6: {
                return (byte)(0xFC & by2);
            }
            case 7: {
                return (byte)(0xFE & by2);
            }
            case 8: {
                return by2;
            }
        }
        throw new IllegalArgumentException("lowOrderBitsToPreserve: " + n2);
    }
}

