/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.dns.DefaultDnsPtrRecord;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordDecoder;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.util.CharsetUtil;

public class DefaultDnsRecordDecoder
implements DnsRecordDecoder {
    static final String ROOT = ".";

    protected DefaultDnsRecordDecoder() {
    }

    @Override
    public final DnsQuestion decodeQuestion(ByteBuf byteBuf) {
        String string = DefaultDnsRecordDecoder.decodeName(byteBuf);
        DnsRecordType dnsRecordType = DnsRecordType.valueOf(byteBuf.readUnsignedShort());
        int n2 = byteBuf.readUnsignedShort();
        return new DefaultDnsQuestion(string, dnsRecordType, n2);
    }

    @Override
    public final <T extends DnsRecord> T decodeRecord(ByteBuf byteBuf) {
        int n2 = byteBuf.readerIndex();
        String string = DefaultDnsRecordDecoder.decodeName(byteBuf);
        int n3 = byteBuf.writerIndex();
        if (n3 - n2 < 10) {
            byteBuf.readerIndex(n2);
            return null;
        }
        DnsRecordType dnsRecordType = DnsRecordType.valueOf(byteBuf.readUnsignedShort());
        int n4 = byteBuf.readUnsignedShort();
        long l2 = byteBuf.readUnsignedInt();
        int n5 = byteBuf.readUnsignedShort();
        int n6 = byteBuf.readerIndex();
        if (n3 - n6 < n5) {
            byteBuf.readerIndex(n2);
            return null;
        }
        DnsRecord dnsRecord = this.decodeRecord(string, dnsRecordType, n4, l2, byteBuf, n6, n5);
        byteBuf.readerIndex(n6 + n5);
        return (T)dnsRecord;
    }

    protected DnsRecord decodeRecord(String string, DnsRecordType dnsRecordType, int n2, long l2, ByteBuf byteBuf, int n3, int n4) {
        if (dnsRecordType == DnsRecordType.PTR) {
            return new DefaultDnsPtrRecord(string, n2, l2, this.decodeName0(byteBuf.duplicate().setIndex(n3, n3 + n4)));
        }
        return new DefaultDnsRawRecord(string, dnsRecordType, n2, l2, byteBuf.retainedDuplicate().setIndex(n3, n3 + n4));
    }

    protected String decodeName0(ByteBuf byteBuf) {
        return DefaultDnsRecordDecoder.decodeName(byteBuf);
    }

    public static String decodeName(ByteBuf byteBuf) {
        int n2 = -1;
        int n3 = 0;
        int n4 = byteBuf.writerIndex();
        int n5 = byteBuf.readableBytes();
        if (n5 == 0) {
            return ROOT;
        }
        StringBuilder stringBuilder = new StringBuilder(n5 << 1);
        while (byteBuf.isReadable()) {
            boolean bl2;
            short s2 = byteBuf.readUnsignedByte();
            boolean bl3 = bl2 = (s2 & 0xC0) == 192;
            if (bl2) {
                if (n2 == -1) {
                    n2 = byteBuf.readerIndex() + 1;
                }
                if (!byteBuf.isReadable()) {
                    throw new CorruptedFrameException("truncated pointer in a name");
                }
                int n6 = (s2 & 0x3F) << 8 | byteBuf.readUnsignedByte();
                if (n6 >= n4) {
                    throw new CorruptedFrameException("name has an out-of-range pointer");
                }
                byteBuf.readerIndex(n6);
                if ((n3 += 2) < n4) continue;
                throw new CorruptedFrameException("name contains a loop.");
            }
            if (s2 == 0) break;
            if (!byteBuf.isReadable(s2)) {
                throw new CorruptedFrameException("truncated label in a name");
            }
            stringBuilder.append(byteBuf.toString(byteBuf.readerIndex(), s2, CharsetUtil.UTF_8)).append('.');
            byteBuf.skipBytes(s2);
        }
        if (n2 != -1) {
            byteBuf.readerIndex(n2);
        }
        if (stringBuilder.length() == 0) {
            return ROOT;
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) != '.') {
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }
}

