/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler$Sharable;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.dns.DatagramDnsResponse;
import io.netty.handler.codec.dns.DnsOpCode;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordDecoder;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.util.List;

@ChannelHandler$Sharable
public class DatagramDnsResponseDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private final DnsRecordDecoder recordDecoder;

    public DatagramDnsResponseDecoder() {
        this(DnsRecordDecoder.DEFAULT);
    }

    public DatagramDnsResponseDecoder(DnsRecordDecoder dnsRecordDecoder) {
        this.recordDecoder = ObjectUtil.checkNotNull(dnsRecordDecoder, "recordDecoder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, DatagramPacket datagramPacket, List<Object> list) {
        ByteBuf byteBuf = (ByteBuf)datagramPacket.content();
        DnsResponse dnsResponse = DatagramDnsResponseDecoder.newResponse(datagramPacket, byteBuf);
        boolean bl2 = false;
        try {
            int n2 = byteBuf.readUnsignedShort();
            int n3 = byteBuf.readUnsignedShort();
            int n4 = byteBuf.readUnsignedShort();
            int n5 = byteBuf.readUnsignedShort();
            this.decodeQuestions(dnsResponse, byteBuf, n2);
            this.decodeRecords(dnsResponse, DnsSection.ANSWER, byteBuf, n3);
            this.decodeRecords(dnsResponse, DnsSection.AUTHORITY, byteBuf, n4);
            this.decodeRecords(dnsResponse, DnsSection.ADDITIONAL, byteBuf, n5);
            list.add(dnsResponse);
            bl2 = true;
        }
        finally {
            if (!bl2) {
                dnsResponse.release();
            }
        }
    }

    private static DnsResponse newResponse(DatagramPacket datagramPacket, ByteBuf byteBuf) {
        int n2 = byteBuf.readUnsignedShort();
        int n3 = byteBuf.readUnsignedShort();
        if (n3 >> 15 == 0) {
            throw new CorruptedFrameException("not a response");
        }
        DatagramDnsResponse datagramDnsResponse = new DatagramDnsResponse((InetSocketAddress)datagramPacket.sender(), (InetSocketAddress)datagramPacket.recipient(), n2, DnsOpCode.valueOf((byte)(n3 >> 11 & 0xF)), DnsResponseCode.valueOf((byte)(n3 & 0xF)));
        datagramDnsResponse.setRecursionDesired((n3 >> 8 & 1) == 1);
        datagramDnsResponse.setAuthoritativeAnswer((n3 >> 10 & 1) == 1);
        datagramDnsResponse.setTruncated((n3 >> 9 & 1) == 1);
        datagramDnsResponse.setRecursionAvailable((n3 >> 7 & 1) == 1);
        datagramDnsResponse.setZ(n3 >> 4 & 7);
        return datagramDnsResponse;
    }

    private void decodeQuestions(DnsResponse dnsResponse, ByteBuf byteBuf, int n2) {
        for (int i2 = n2; i2 > 0; --i2) {
            dnsResponse.addRecord(DnsSection.QUESTION, this.recordDecoder.decodeQuestion(byteBuf));
        }
    }

    private void decodeRecords(DnsResponse dnsResponse, DnsSection dnsSection, ByteBuf byteBuf, int n2) {
        Object t2;
        for (int i2 = n2; i2 > 0 && (t2 = this.recordDecoder.decodeRecord(byteBuf)) != null; --i2) {
            dnsResponse.addRecord(dnsSection, (DnsRecord)t2);
        }
    }
}

