/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler$Sharable;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.dns.DnsQuery;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordEncoder;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.util.List;

@ChannelHandler$Sharable
public class DatagramDnsQueryEncoder
extends MessageToMessageEncoder<AddressedEnvelope<DnsQuery, InetSocketAddress>> {
    private final DnsRecordEncoder recordEncoder;

    public DatagramDnsQueryEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public DatagramDnsQueryEncoder(DnsRecordEncoder dnsRecordEncoder) {
        this.recordEncoder = ObjectUtil.checkNotNull(dnsRecordEncoder, "recordEncoder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, AddressedEnvelope<DnsQuery, InetSocketAddress> addressedEnvelope, List<Object> list) {
        InetSocketAddress inetSocketAddress = addressedEnvelope.recipient();
        DnsQuery dnsQuery = addressedEnvelope.content();
        ByteBuf byteBuf = this.allocateBuffer(channelHandlerContext, addressedEnvelope);
        boolean bl2 = false;
        try {
            DatagramDnsQueryEncoder.encodeHeader(dnsQuery, byteBuf);
            this.encodeQuestions(dnsQuery, byteBuf);
            this.encodeRecords(dnsQuery, DnsSection.ADDITIONAL, byteBuf);
            bl2 = true;
        }
        finally {
            if (!bl2) {
                byteBuf.release();
            }
        }
        list.add(new DatagramPacket(byteBuf, inetSocketAddress, null));
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, AddressedEnvelope<DnsQuery, InetSocketAddress> addressedEnvelope) {
        return channelHandlerContext.alloc().ioBuffer(1024);
    }

    private static void encodeHeader(DnsQuery dnsQuery, ByteBuf byteBuf) {
        byteBuf.writeShort(dnsQuery.id());
        int n2 = 0;
        n2 |= (dnsQuery.opCode().byteValue() & 0xFF) << 14;
        if (dnsQuery.isRecursionDesired()) {
            n2 |= 0x100;
        }
        byteBuf.writeShort(n2);
        byteBuf.writeShort(dnsQuery.count(DnsSection.QUESTION));
        byteBuf.writeShort(0);
        byteBuf.writeShort(0);
        byteBuf.writeShort(dnsQuery.count(DnsSection.ADDITIONAL));
    }

    private void encodeQuestions(DnsQuery dnsQuery, ByteBuf byteBuf) {
        int n2 = dnsQuery.count(DnsSection.QUESTION);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.recordEncoder.encodeQuestion((DnsQuestion)dnsQuery.recordAt(DnsSection.QUESTION, i2), byteBuf);
        }
    }

    private void encodeRecords(DnsQuery dnsQuery, DnsSection dnsSection, ByteBuf byteBuf) {
        int n2 = dnsQuery.count(dnsSection);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.recordEncoder.encodeRecord((DnsRecord)dnsQuery.recordAt(dnsSection, i2), byteBuf);
        }
    }
}

