/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler$Sharable;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.dns.DatagramDnsQuery;
import io.netty.handler.codec.dns.DnsOpCode;
import io.netty.handler.codec.dns.DnsQuery;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordDecoder;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.util.List;

@ChannelHandler$Sharable
public class DatagramDnsQueryDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private final DnsRecordDecoder recordDecoder;

    public DatagramDnsQueryDecoder() {
        this(DnsRecordDecoder.DEFAULT);
    }

    public DatagramDnsQueryDecoder(DnsRecordDecoder dnsRecordDecoder) {
        this.recordDecoder = ObjectUtil.checkNotNull(dnsRecordDecoder, "recordDecoder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, DatagramPacket datagramPacket, List<Object> list) {
        ByteBuf byteBuf = (ByteBuf)datagramPacket.content();
        DnsQuery dnsQuery = DatagramDnsQueryDecoder.newQuery(datagramPacket, byteBuf);
        boolean bl2 = false;
        try {
            int n2 = byteBuf.readUnsignedShort();
            int n3 = byteBuf.readUnsignedShort();
            int n4 = byteBuf.readUnsignedShort();
            int n5 = byteBuf.readUnsignedShort();
            this.decodeQuestions(dnsQuery, byteBuf, n2);
            this.decodeRecords(dnsQuery, DnsSection.ANSWER, byteBuf, n3);
            this.decodeRecords(dnsQuery, DnsSection.AUTHORITY, byteBuf, n4);
            this.decodeRecords(dnsQuery, DnsSection.ADDITIONAL, byteBuf, n5);
            list.add(dnsQuery);
            bl2 = true;
        }
        finally {
            if (!bl2) {
                dnsQuery.release();
            }
        }
    }

    private static DnsQuery newQuery(DatagramPacket datagramPacket, ByteBuf byteBuf) {
        int n2 = byteBuf.readUnsignedShort();
        int n3 = byteBuf.readUnsignedShort();
        if (n3 >> 15 == 1) {
            throw new CorruptedFrameException("not a query");
        }
        DatagramDnsQuery datagramDnsQuery = new DatagramDnsQuery((InetSocketAddress)datagramPacket.sender(), (InetSocketAddress)datagramPacket.recipient(), n2, DnsOpCode.valueOf((byte)(n3 >> 11 & 0xF)));
        datagramDnsQuery.setRecursionDesired((n3 >> 8 & 1) == 1);
        datagramDnsQuery.setZ(n3 >> 4 & 7);
        return datagramDnsQuery;
    }

    private void decodeQuestions(DnsQuery dnsQuery, ByteBuf byteBuf, int n2) {
        for (int i2 = n2; i2 > 0; --i2) {
            dnsQuery.addRecord(DnsSection.QUESTION, this.recordDecoder.decodeQuestion(byteBuf));
        }
    }

    private void decodeRecords(DnsQuery dnsQuery, DnsSection dnsSection, ByteBuf byteBuf, int n2) {
        Object t2;
        for (int i2 = n2; i2 > 0 && (t2 = this.recordDecoder.decodeRecord(byteBuf)) != null; --i2) {
            dnsQuery.addRecord(dnsSection, (DnsRecord)t2);
        }
    }
}

