/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.channel.AddressedEnvelope;
import io.netty.handler.codec.dns.DefaultDnsQuery;
import io.netty.handler.codec.dns.DnsOpCode;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsSection;
import java.net.InetSocketAddress;

public class DatagramDnsQuery
extends DefaultDnsQuery
implements AddressedEnvelope<DatagramDnsQuery, InetSocketAddress> {
    private final InetSocketAddress sender;
    private final InetSocketAddress recipient;

    public DatagramDnsQuery(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, int n2) {
        this(inetSocketAddress, inetSocketAddress2, n2, DnsOpCode.QUERY);
    }

    public DatagramDnsQuery(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, int n2, DnsOpCode dnsOpCode) {
        super(n2, dnsOpCode);
        if (inetSocketAddress2 == null && inetSocketAddress == null) {
            throw new NullPointerException("recipient and sender");
        }
        this.sender = inetSocketAddress;
        this.recipient = inetSocketAddress2;
    }

    @Override
    public DatagramDnsQuery content() {
        return this;
    }

    @Override
    public InetSocketAddress sender() {
        return this.sender;
    }

    @Override
    public InetSocketAddress recipient() {
        return this.recipient;
    }

    @Override
    public DatagramDnsQuery setId(int n2) {
        return (DatagramDnsQuery)super.setId(n2);
    }

    @Override
    public DatagramDnsQuery setOpCode(DnsOpCode dnsOpCode) {
        return (DatagramDnsQuery)super.setOpCode(dnsOpCode);
    }

    @Override
    public DatagramDnsQuery setRecursionDesired(boolean bl2) {
        return (DatagramDnsQuery)super.setRecursionDesired(bl2);
    }

    @Override
    public DatagramDnsQuery setZ(int n2) {
        return (DatagramDnsQuery)super.setZ(n2);
    }

    @Override
    public DatagramDnsQuery setRecord(DnsSection dnsSection, DnsRecord dnsRecord) {
        return (DatagramDnsQuery)super.setRecord(dnsSection, dnsRecord);
    }

    @Override
    public DatagramDnsQuery addRecord(DnsSection dnsSection, DnsRecord dnsRecord) {
        return (DatagramDnsQuery)super.addRecord(dnsSection, dnsRecord);
    }

    @Override
    public DatagramDnsQuery addRecord(DnsSection dnsSection, int n2, DnsRecord dnsRecord) {
        return (DatagramDnsQuery)super.addRecord(dnsSection, n2, dnsRecord);
    }

    @Override
    public DatagramDnsQuery clear(DnsSection dnsSection) {
        return (DatagramDnsQuery)super.clear(dnsSection);
    }

    @Override
    public DatagramDnsQuery clear() {
        return (DatagramDnsQuery)super.clear();
    }

    @Override
    public DatagramDnsQuery touch() {
        return (DatagramDnsQuery)super.touch();
    }

    @Override
    public DatagramDnsQuery touch(Object object) {
        return (DatagramDnsQuery)super.touch(object);
    }

    @Override
    public DatagramDnsQuery retain() {
        return (DatagramDnsQuery)super.retain();
    }

    @Override
    public DatagramDnsQuery retain(int n2) {
        return (DatagramDnsQuery)super.retain(n2);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof AddressedEnvelope)) {
            return false;
        }
        AddressedEnvelope addressedEnvelope = (AddressedEnvelope)object;
        if (this.sender() == null ? addressedEnvelope.sender() != null : !this.sender().equals(addressedEnvelope.sender())) {
            return false;
        }
        return !(this.recipient() == null ? addressedEnvelope.recipient() != null : !this.recipient().equals(addressedEnvelope.recipient()));
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        if (this.sender() != null) {
            n2 = n2 * 31 + this.sender().hashCode();
        }
        if (this.recipient() != null) {
            n2 = n2 * 31 + this.recipient().hashCode();
        }
        return n2;
    }
}

