/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.handler.codec.dns.DnsMessage;
import io.netty.handler.codec.dns.DnsOpCode;
import io.netty.handler.codec.dns.DnsQuery;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDnsMessage
extends AbstractReferenceCounted
implements DnsMessage {
    private static final ResourceLeakDetector<DnsMessage> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(DnsMessage.class);
    private static final int SECTION_QUESTION = DnsSection.QUESTION.ordinal();
    private static final int SECTION_COUNT = 4;
    private final ResourceLeakTracker<DnsMessage> leak = leakDetector.track(this);
    private short id;
    private DnsOpCode opCode;
    private boolean recursionDesired;
    private byte z;
    private Object questions;
    private Object answers;
    private Object authorities;
    private Object additionals;

    protected AbstractDnsMessage(int n2) {
        this(n2, DnsOpCode.QUERY);
    }

    protected AbstractDnsMessage(int n2, DnsOpCode dnsOpCode) {
        this.setId(n2);
        this.setOpCode(dnsOpCode);
    }

    @Override
    public int id() {
        return this.id & 0xFFFF;
    }

    @Override
    public DnsMessage setId(int n2) {
        this.id = (short)n2;
        return this;
    }

    @Override
    public DnsOpCode opCode() {
        return this.opCode;
    }

    @Override
    public DnsMessage setOpCode(DnsOpCode dnsOpCode) {
        this.opCode = ObjectUtil.checkNotNull(dnsOpCode, "opCode");
        return this;
    }

    @Override
    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    @Override
    public DnsMessage setRecursionDesired(boolean bl2) {
        this.recursionDesired = bl2;
        return this;
    }

    @Override
    public int z() {
        return this.z;
    }

    @Override
    public DnsMessage setZ(int n2) {
        this.z = (byte)(n2 & 7);
        return this;
    }

    @Override
    public int count(DnsSection dnsSection) {
        return this.count(AbstractDnsMessage.sectionOrdinal(dnsSection));
    }

    private int count(int n2) {
        Object object = this.sectionAt(n2);
        if (object == null) {
            return 0;
        }
        if (object instanceof DnsRecord) {
            return 1;
        }
        List list = (List)object;
        return list.size();
    }

    @Override
    public int count() {
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            n2 += this.count(i2);
        }
        return n2;
    }

    @Override
    public <T extends DnsRecord> T recordAt(DnsSection dnsSection) {
        return this.recordAt(AbstractDnsMessage.sectionOrdinal(dnsSection));
    }

    private <T extends DnsRecord> T recordAt(int n2) {
        Object object = this.sectionAt(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof DnsRecord) {
            return AbstractDnsMessage.castRecord(object);
        }
        List list = (List)object;
        if (list.isEmpty()) {
            return null;
        }
        return AbstractDnsMessage.castRecord(list.get(0));
    }

    @Override
    public <T extends DnsRecord> T recordAt(DnsSection dnsSection, int n2) {
        return this.recordAt(AbstractDnsMessage.sectionOrdinal(dnsSection), n2);
    }

    private <T extends DnsRecord> T recordAt(int n2, int n3) {
        Object object = this.sectionAt(n2);
        if (object == null) {
            throw new IndexOutOfBoundsException("index: " + n3 + " (expected: none)");
        }
        if (object instanceof DnsRecord) {
            if (n3 == 0) {
                return AbstractDnsMessage.castRecord(object);
            }
            throw new IndexOutOfBoundsException("index: " + n3 + "' (expected: 0)");
        }
        List list = (List)object;
        return AbstractDnsMessage.castRecord(list.get(n3));
    }

    @Override
    public DnsMessage setRecord(DnsSection dnsSection, DnsRecord dnsRecord) {
        this.setRecord(AbstractDnsMessage.sectionOrdinal(dnsSection), dnsRecord);
        return this;
    }

    private void setRecord(int n2, DnsRecord dnsRecord) {
        this.clear(n2);
        this.setSection(n2, AbstractDnsMessage.checkQuestion(n2, dnsRecord));
    }

    @Override
    public <T extends DnsRecord> T setRecord(DnsSection dnsSection, int n2, DnsRecord dnsRecord) {
        return this.setRecord(AbstractDnsMessage.sectionOrdinal(dnsSection), n2, dnsRecord);
    }

    private <T extends DnsRecord> T setRecord(int n2, int n3, DnsRecord dnsRecord) {
        AbstractDnsMessage.checkQuestion(n2, dnsRecord);
        Object object = this.sectionAt(n2);
        if (object == null) {
            throw new IndexOutOfBoundsException("index: " + n3 + " (expected: none)");
        }
        if (object instanceof DnsRecord) {
            if (n3 == 0) {
                this.setSection(n2, dnsRecord);
                return AbstractDnsMessage.castRecord(object);
            }
            throw new IndexOutOfBoundsException("index: " + n3 + " (expected: 0)");
        }
        List list = (List)object;
        return AbstractDnsMessage.castRecord(list.set(n3, dnsRecord));
    }

    @Override
    public DnsMessage addRecord(DnsSection dnsSection, DnsRecord dnsRecord) {
        this.addRecord(AbstractDnsMessage.sectionOrdinal(dnsSection), dnsRecord);
        return this;
    }

    private void addRecord(int n2, DnsRecord dnsRecord) {
        AbstractDnsMessage.checkQuestion(n2, dnsRecord);
        Object object = this.sectionAt(n2);
        if (object == null) {
            this.setSection(n2, dnsRecord);
            return;
        }
        if (object instanceof DnsRecord) {
            ArrayList<DnsRecord> arrayList = AbstractDnsMessage.newRecordList();
            arrayList.add((DnsRecord)AbstractDnsMessage.castRecord(object));
            arrayList.add(dnsRecord);
            this.setSection(n2, arrayList);
            return;
        }
        List list = (List)object;
        list.add(dnsRecord);
    }

    @Override
    public DnsMessage addRecord(DnsSection dnsSection, int n2, DnsRecord dnsRecord) {
        this.addRecord(AbstractDnsMessage.sectionOrdinal(dnsSection), n2, dnsRecord);
        return this;
    }

    private void addRecord(int n2, int n3, DnsRecord dnsRecord) {
        AbstractDnsMessage.checkQuestion(n2, dnsRecord);
        Object object = this.sectionAt(n2);
        if (object == null) {
            if (n3 != 0) {
                throw new IndexOutOfBoundsException("index: " + n3 + " (expected: 0)");
            }
            this.setSection(n2, dnsRecord);
            return;
        }
        if (object instanceof DnsRecord) {
            ArrayList<DnsRecord> arrayList;
            if (n3 == 0) {
                arrayList = AbstractDnsMessage.newRecordList();
                arrayList.add(dnsRecord);
                arrayList.add((DnsRecord)AbstractDnsMessage.castRecord(object));
            } else if (n3 == 1) {
                arrayList = AbstractDnsMessage.newRecordList();
                arrayList.add((DnsRecord)AbstractDnsMessage.castRecord(object));
                arrayList.add(dnsRecord);
            } else {
                throw new IndexOutOfBoundsException("index: " + n3 + " (expected: 0 or 1)");
            }
            this.setSection(n2, arrayList);
            return;
        }
        List list = (List)object;
        list.add(n3, dnsRecord);
    }

    @Override
    public <T extends DnsRecord> T removeRecord(DnsSection dnsSection, int n2) {
        return this.removeRecord(AbstractDnsMessage.sectionOrdinal(dnsSection), n2);
    }

    private <T extends DnsRecord> T removeRecord(int n2, int n3) {
        Object object = this.sectionAt(n2);
        if (object == null) {
            throw new IndexOutOfBoundsException("index: " + n3 + " (expected: none)");
        }
        if (object instanceof DnsRecord) {
            if (n3 != 0) {
                throw new IndexOutOfBoundsException("index: " + n3 + " (expected: 0)");
            }
            T t2 = AbstractDnsMessage.castRecord(object);
            this.setSection(n2, null);
            return t2;
        }
        List list = (List)object;
        return AbstractDnsMessage.castRecord(list.remove(n3));
    }

    @Override
    public DnsMessage clear(DnsSection dnsSection) {
        this.clear(AbstractDnsMessage.sectionOrdinal(dnsSection));
        return this;
    }

    @Override
    public DnsMessage clear() {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.clear(i2);
        }
        return this;
    }

    private void clear(int n2) {
        List list;
        Object object = this.sectionAt(n2);
        this.setSection(n2, null);
        if (object instanceof ReferenceCounted) {
            ((ReferenceCounted)object).release();
        } else if (object instanceof List && !(list = (List)object).isEmpty()) {
            for (Object e2 : list) {
                ReferenceCountUtil.release(e2);
            }
        }
    }

    @Override
    public DnsMessage touch() {
        return (DnsMessage)super.touch();
    }

    @Override
    public DnsMessage touch(Object object) {
        if (this.leak != null) {
            this.leak.record(object);
        }
        return this;
    }

    @Override
    public DnsMessage retain() {
        return (DnsMessage)super.retain();
    }

    @Override
    public DnsMessage retain(int n2) {
        return (DnsMessage)super.retain(n2);
    }

    @Override
    protected void deallocate() {
        this.clear();
        ResourceLeakTracker<DnsMessage> resourceLeakTracker = this.leak;
        if (resourceLeakTracker != null) {
            boolean bl2 = resourceLeakTracker.close(this);
            assert (bl2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DnsMessage)) {
            return false;
        }
        DnsMessage dnsMessage = (DnsMessage)object;
        if (this.id() != dnsMessage.id()) {
            return false;
        }
        return !(this instanceof DnsQuery ? !(dnsMessage instanceof DnsQuery) : dnsMessage instanceof DnsQuery);
    }

    public int hashCode() {
        return this.id() * 31 + (this instanceof DnsQuery ? 0 : 1);
    }

    private Object sectionAt(int n2) {
        switch (n2) {
            case 0: {
                return this.questions;
            }
            case 1: {
                return this.answers;
            }
            case 2: {
                return this.authorities;
            }
            case 3: {
                return this.additionals;
            }
        }
        throw new Error();
    }

    private void setSection(int n2, Object object) {
        switch (n2) {
            case 0: {
                this.questions = object;
                return;
            }
            case 1: {
                this.answers = object;
                return;
            }
            case 2: {
                this.authorities = object;
                return;
            }
            case 3: {
                this.additionals = object;
                return;
            }
        }
        throw new Error();
    }

    private static int sectionOrdinal(DnsSection dnsSection) {
        return ObjectUtil.checkNotNull(dnsSection, "section").ordinal();
    }

    private static DnsRecord checkQuestion(int n2, DnsRecord dnsRecord) {
        if (n2 == SECTION_QUESTION && !(ObjectUtil.checkNotNull(dnsRecord, "record") instanceof DnsQuestion)) {
            throw new IllegalArgumentException("record: " + dnsRecord + " (expected: " + StringUtil.simpleClassName(DnsQuestion.class) + ')');
        }
        return dnsRecord;
    }

    private static <T extends DnsRecord> T castRecord(Object object) {
        return (T)((DnsRecord)object);
    }

    private static ArrayList<DnsRecord> newRecordList() {
        return new ArrayList<DnsRecord>(2);
    }
}

