/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.Crc32c;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.Snappy$State;

public final class Snappy {
    private static final int MAX_HT_SIZE = 16384;
    private static final int MIN_COMPRESSIBLE_BYTES = 15;
    private static final int PREAMBLE_NOT_FULL = -1;
    private static final int NOT_ENOUGH_INPUT = -1;
    private static final int LITERAL = 0;
    private static final int COPY_1_BYTE_OFFSET = 1;
    private static final int COPY_2_BYTE_OFFSET = 2;
    private static final int COPY_4_BYTE_OFFSET = 3;
    private Snappy$State state = Snappy$State.READY;
    private byte tag;
    private int written;

    public void reset() {
        this.state = Snappy$State.READY;
        this.tag = 0;
        this.written = 0;
    }

    public void encode(ByteBuf byteBuf, ByteBuf byteBuf2, int n2) {
        int n3;
        int n4 = 0;
        while (true) {
            if (((n3 = n2 >>> n4 * 7) & 0xFFFFFF80) == 0) break;
            byteBuf2.writeByte(n3 & 0x7F | 0x80);
            ++n4;
        }
        byteBuf2.writeByte(n3);
        n3 = n4 = byteBuf.readerIndex();
        short[] sArray = Snappy.getHashTable(n2);
        int n5 = Integer.numberOfLeadingZeros(sArray.length) + 1;
        int n6 = n4;
        if (n2 - n4 >= 15) {
            int n7 = Snappy.hash(byteBuf, ++n4, n5);
            block1: while (true) {
                int n8;
                int n9;
                int n10;
                int n11 = 32;
                int n12 = n4;
                do {
                    n4 = n12;
                    n9 = n7;
                    if ((n12 = n4 + (n8 = n11++ >> 5)) > n2 - 4) break block1;
                    n7 = Snappy.hash(byteBuf, n12, n5);
                    n10 = n3 + sArray[n9];
                    sArray[n9] = (short)(n4 - n3);
                } while (byteBuf.getInt(n4) != byteBuf.getInt(n10));
                Snappy.encodeLiteral(byteBuf, byteBuf2, n4 - n6);
                do {
                    n8 = n4;
                    int n13 = 4 + Snappy.findMatchingLength(byteBuf, n10 + 4, n4 + 4, n2);
                    int n14 = n8 - n10;
                    Snappy.encodeCopy(byteBuf2, n14, n13);
                    byteBuf.readerIndex(byteBuf.readerIndex() + n13);
                    n9 = (n4 += n13) - 1;
                    n6 = n4;
                    if (n4 >= n2 - 4) break block1;
                    int n15 = Snappy.hash(byteBuf, n9, n5);
                    sArray[n15] = (short)(n4 - n3 - 1);
                    int n16 = Snappy.hash(byteBuf, n9 + 1, n5);
                    n10 = n3 + sArray[n16];
                    sArray[n16] = (short)(n4 - n3);
                } while (byteBuf.getInt(n9 + 1) == byteBuf.getInt(n10));
                n7 = Snappy.hash(byteBuf, n9 + 2, n5);
                ++n4;
            }
        }
        if (n6 < n2) {
            Snappy.encodeLiteral(byteBuf, byteBuf2, n2 - n6);
        }
    }

    private static int hash(ByteBuf byteBuf, int n2, int n3) {
        return byteBuf.getInt(n2) * 506832829 >>> n3;
    }

    private static short[] getHashTable(int n2) {
        int n3;
        for (n3 = 256; n3 < 16384 && n3 < n2; n3 <<= 1) {
        }
        return new short[n3];
    }

    private static int findMatchingLength(ByteBuf byteBuf, int n2, int n3, int n4) {
        int n5 = 0;
        while (n3 <= n4 - 4 && byteBuf.getInt(n3) == byteBuf.getInt(n2 + n5)) {
            n3 += 4;
            n5 += 4;
        }
        while (n3 < n4 && byteBuf.getByte(n2 + n5) == byteBuf.getByte(n3)) {
            ++n3;
            ++n5;
        }
        return n5;
    }

    private static int bitsToEncode(int n2) {
        int n3 = Integer.highestOneBit(n2);
        int n4 = 0;
        while ((n3 >>= 1) != 0) {
            ++n4;
        }
        return n4;
    }

    static void encodeLiteral(ByteBuf byteBuf, ByteBuf byteBuf2, int n2) {
        if (n2 < 61) {
            byteBuf2.writeByte(n2 - 1 << 2);
        } else {
            int n3 = Snappy.bitsToEncode(n2 - 1);
            int n4 = 1 + n3 / 8;
            byteBuf2.writeByte(59 + n4 << 2);
            for (int i2 = 0; i2 < n4; ++i2) {
                byteBuf2.writeByte(n2 - 1 >> i2 * 8 & 0xFF);
            }
        }
        byteBuf2.writeBytes(byteBuf, n2);
    }

    private static void encodeCopyWithOffset(ByteBuf byteBuf, int n2, int n3) {
        if (n3 < 12 && n2 < 2048) {
            byteBuf.writeByte(1 | n3 - 4 << 2 | n2 >> 8 << 5);
            byteBuf.writeByte(n2 & 0xFF);
        } else {
            byteBuf.writeByte(2 | n3 - 1 << 2);
            byteBuf.writeByte(n2 & 0xFF);
            byteBuf.writeByte(n2 >> 8 & 0xFF);
        }
    }

    private static void encodeCopy(ByteBuf byteBuf, int n2, int n3) {
        while (n3 >= 68) {
            Snappy.encodeCopyWithOffset(byteBuf, n2, 64);
            n3 -= 64;
        }
        if (n3 > 64) {
            Snappy.encodeCopyWithOffset(byteBuf, n2, 60);
            n3 -= 60;
        }
        Snappy.encodeCopyWithOffset(byteBuf, n2, n3);
    }

    public void decode(ByteBuf byteBuf, ByteBuf byteBuf2) {
        while (byteBuf.isReadable()) {
            block0 : switch (this.state) {
                case READY: {
                    this.state = Snappy$State.READING_PREAMBLE;
                }
                case READING_PREAMBLE: {
                    int n2 = Snappy.readPreamble(byteBuf);
                    if (n2 == -1) {
                        return;
                    }
                    if (n2 == 0) {
                        this.state = Snappy$State.READY;
                        return;
                    }
                    byteBuf2.ensureWritable(n2);
                    this.state = Snappy$State.READING_TAG;
                }
                case READING_TAG: {
                    if (!byteBuf.isReadable()) {
                        return;
                    }
                    this.tag = byteBuf.readByte();
                    switch (this.tag & 3) {
                        case 0: {
                            this.state = Snappy$State.READING_LITERAL;
                            break block0;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            this.state = Snappy$State.READING_COPY;
                        }
                    }
                    break;
                }
                case READING_LITERAL: {
                    int n3 = Snappy.decodeLiteral(this.tag, byteBuf, byteBuf2);
                    if (n3 != -1) {
                        this.state = Snappy$State.READING_TAG;
                        this.written += n3;
                        break;
                    }
                    return;
                }
                case READING_COPY: {
                    switch (this.tag & 3) {
                        case 1: {
                            int n4 = Snappy.decodeCopyWith1ByteOffset(this.tag, byteBuf, byteBuf2, this.written);
                            if (n4 != -1) {
                                this.state = Snappy$State.READING_TAG;
                                this.written += n4;
                                break block0;
                            }
                            return;
                        }
                        case 2: {
                            int n4 = Snappy.decodeCopyWith2ByteOffset(this.tag, byteBuf, byteBuf2, this.written);
                            if (n4 != -1) {
                                this.state = Snappy$State.READING_TAG;
                                this.written += n4;
                                break block0;
                            }
                            return;
                        }
                        case 3: {
                            int n4 = Snappy.decodeCopyWith4ByteOffset(this.tag, byteBuf, byteBuf2, this.written);
                            if (n4 != -1) {
                                this.state = Snappy$State.READING_TAG;
                                this.written += n4;
                                break block0;
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    private static int readPreamble(ByteBuf byteBuf) {
        int n2 = 0;
        int n3 = 0;
        while (byteBuf.isReadable()) {
            short s2 = byteBuf.readUnsignedByte();
            n2 |= (s2 & 0x7F) << n3++ * 7;
            if ((s2 & 0x80) == 0) {
                return n2;
            }
            if (n3 < 4) continue;
            throw new DecompressionException("Preamble is greater than 4 bytes");
        }
        return 0;
    }

    static int decodeLiteral(byte by2, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2;
        byteBuf.markReaderIndex();
        switch (by2 >> 2 & 0x3F) {
            case 60: {
                if (!byteBuf.isReadable()) {
                    return -1;
                }
                n2 = byteBuf.readUnsignedByte();
                break;
            }
            case 61: {
                if (byteBuf.readableBytes() < 2) {
                    return -1;
                }
                n2 = byteBuf.readUnsignedShortLE();
                break;
            }
            case 62: {
                if (byteBuf.readableBytes() < 3) {
                    return -1;
                }
                n2 = byteBuf.readUnsignedMediumLE();
                break;
            }
            case 63: {
                if (byteBuf.readableBytes() < 4) {
                    return -1;
                }
                n2 = byteBuf.readIntLE();
                break;
            }
            default: {
                n2 = by2 >> 2 & 0x3F;
            }
        }
        if (byteBuf.readableBytes() < ++n2) {
            byteBuf.resetReaderIndex();
            return -1;
        }
        byteBuf2.writeBytes(byteBuf, n2);
        return n2;
    }

    private static int decodeCopyWith1ByteOffset(byte by2, ByteBuf byteBuf, ByteBuf byteBuf2, int n2) {
        if (!byteBuf.isReadable()) {
            return -1;
        }
        int n3 = byteBuf2.writerIndex();
        int n4 = 4 + ((by2 & 0x1C) >> 2);
        int n5 = (by2 & 0xE0) << 8 >> 5 | byteBuf.readUnsignedByte();
        Snappy.validateOffset(n5, n2);
        byteBuf2.markReaderIndex();
        if (n5 < n4) {
            for (int i2 = n4 / n5; i2 > 0; --i2) {
                byteBuf2.readerIndex(n3 - n5);
                byteBuf2.readBytes(byteBuf2, n5);
            }
            if (n4 % n5 != 0) {
                byteBuf2.readerIndex(n3 - n5);
                byteBuf2.readBytes(byteBuf2, n4 % n5);
            }
        } else {
            byteBuf2.readerIndex(n3 - n5);
            byteBuf2.readBytes(byteBuf2, n4);
        }
        byteBuf2.resetReaderIndex();
        return n4;
    }

    private static int decodeCopyWith2ByteOffset(byte by2, ByteBuf byteBuf, ByteBuf byteBuf2, int n2) {
        if (byteBuf.readableBytes() < 2) {
            return -1;
        }
        int n3 = byteBuf2.writerIndex();
        int n4 = 1 + (by2 >> 2 & 0x3F);
        int n5 = byteBuf.readUnsignedShortLE();
        Snappy.validateOffset(n5, n2);
        byteBuf2.markReaderIndex();
        if (n5 < n4) {
            for (int i2 = n4 / n5; i2 > 0; --i2) {
                byteBuf2.readerIndex(n3 - n5);
                byteBuf2.readBytes(byteBuf2, n5);
            }
            if (n4 % n5 != 0) {
                byteBuf2.readerIndex(n3 - n5);
                byteBuf2.readBytes(byteBuf2, n4 % n5);
            }
        } else {
            byteBuf2.readerIndex(n3 - n5);
            byteBuf2.readBytes(byteBuf2, n4);
        }
        byteBuf2.resetReaderIndex();
        return n4;
    }

    private static int decodeCopyWith4ByteOffset(byte by2, ByteBuf byteBuf, ByteBuf byteBuf2, int n2) {
        if (byteBuf.readableBytes() < 4) {
            return -1;
        }
        int n3 = byteBuf2.writerIndex();
        int n4 = 1 + (by2 >> 2 & 0x3F);
        int n5 = byteBuf.readIntLE();
        Snappy.validateOffset(n5, n2);
        byteBuf2.markReaderIndex();
        if (n5 < n4) {
            for (int i2 = n4 / n5; i2 > 0; --i2) {
                byteBuf2.readerIndex(n3 - n5);
                byteBuf2.readBytes(byteBuf2, n5);
            }
            if (n4 % n5 != 0) {
                byteBuf2.readerIndex(n3 - n5);
                byteBuf2.readBytes(byteBuf2, n4 % n5);
            }
        } else {
            byteBuf2.readerIndex(n3 - n5);
            byteBuf2.readBytes(byteBuf2, n4);
        }
        byteBuf2.resetReaderIndex();
        return n4;
    }

    private static void validateOffset(int n2, int n3) {
        if (n2 == 0) {
            throw new DecompressionException("Offset is less than minimum permissible value");
        }
        if (n2 < 0) {
            throw new DecompressionException("Offset is greater than maximum value supported by this implementation");
        }
        if (n2 > n3) {
            throw new DecompressionException("Offset exceeds size of chunk");
        }
    }

    static int calculateChecksum(ByteBuf byteBuf) {
        return Snappy.calculateChecksum(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int calculateChecksum(ByteBuf byteBuf, int n2, int n3) {
        Crc32c crc32c = new Crc32c();
        try {
            crc32c.update(byteBuf, n2, n3);
            int n4 = Snappy.maskChecksum((int)crc32c.getValue());
            return n4;
        }
        finally {
            crc32c.reset();
        }
    }

    static void validateChecksum(int n2, ByteBuf byteBuf) {
        Snappy.validateChecksum(n2, byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    static void validateChecksum(int n2, ByteBuf byteBuf, int n3, int n4) {
        int n5 = Snappy.calculateChecksum(byteBuf, n3, n4);
        if (n5 != n2) {
            throw new DecompressionException("mismatching checksum: " + Integer.toHexString(n5) + " (expected: " + Integer.toHexString(n2) + ')');
        }
    }

    static int maskChecksum(int n2) {
        return (n2 >> 15 | n2 << 17) + -1568478504;
    }
}

