/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.InputStream;
import java.io.OutputStream;
import lzma.sdk.lzma.Encoder;

public class LzmaFrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(LzmaFrameEncoder.class);
    private static final int MEDIUM_DICTIONARY_SIZE = 65536;
    private static final int MIN_FAST_BYTES = 5;
    private static final int MEDIUM_FAST_BYTES = 32;
    private static final int MAX_FAST_BYTES = 273;
    private static final int DEFAULT_MATCH_FINDER = 1;
    private static final int DEFAULT_LC = 3;
    private static final int DEFAULT_LP = 0;
    private static final int DEFAULT_PB = 2;
    private final Encoder encoder;
    private final byte properties;
    private final int littleEndianDictionarySize;
    private static boolean warningLogged;

    public LzmaFrameEncoder() {
        this(65536);
    }

    public LzmaFrameEncoder(int n2, int n3, int n4) {
        this(n2, n3, n4, 65536);
    }

    public LzmaFrameEncoder(int n2) {
        this(3, 0, 2, n2);
    }

    public LzmaFrameEncoder(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, false, 32);
    }

    public LzmaFrameEncoder(int n2, int n3, int n4, int n5, boolean bl2, int n6) {
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("lc: " + n2 + " (expected: 0-8)");
        }
        if (n3 < 0 || n3 > 4) {
            throw new IllegalArgumentException("lp: " + n3 + " (expected: 0-4)");
        }
        if (n4 < 0 || n4 > 4) {
            throw new IllegalArgumentException("pb: " + n4 + " (expected: 0-4)");
        }
        if (n2 + n3 > 4 && !warningLogged) {
            logger.warn("The latest versions of LZMA libraries (for example, XZ Utils) has an additional requirement: lc + lp <= 4. Data which don't follow this requirement cannot be decompressed with this libraries.");
            warningLogged = true;
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("dictionarySize: " + n5 + " (expected: 0+)");
        }
        if (n6 < 5 || n6 > 273) {
            throw new IllegalArgumentException(String.format("numFastBytes: %d (expected: %d-%d)", n6, 5, 273));
        }
        this.encoder = new Encoder();
        this.encoder.setDictionarySize(n5);
        this.encoder.setEndMarkerMode(bl2);
        this.encoder.setMatchFinder(1);
        this.encoder.setNumFastBytes(n6);
        this.encoder.setLcLpPb(n2, n3, n4);
        this.properties = (byte)((n4 * 5 + n3) * 9 + n2);
        this.littleEndianDictionarySize = Integer.reverseBytes(n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2 = byteBuf.readableBytes();
        ByteBufInputStream byteBufInputStream = null;
        OutputStream outputStream = null;
        try {
            byteBufInputStream = new ByteBufInputStream(byteBuf);
            outputStream = new ByteBufOutputStream(byteBuf2);
            ((ByteBufOutputStream)outputStream).writeByte(this.properties);
            ((ByteBufOutputStream)outputStream).writeInt(this.littleEndianDictionarySize);
            ((ByteBufOutputStream)outputStream).writeLong(Long.reverseBytes(n2));
            this.encoder.code((InputStream)byteBufInputStream, outputStream, -1L, -1L, null);
        }
        finally {
            if (byteBufInputStream != null) {
                ((InputStream)byteBufInputStream).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl2) {
        int n2 = byteBuf.readableBytes();
        int n3 = LzmaFrameEncoder.maxOutputBufferLength(n2);
        return channelHandlerContext.alloc().ioBuffer(n3);
    }

    private static int maxOutputBufferLength(int n2) {
        double d2 = n2 < 200 ? 1.5 : (n2 < 500 ? 1.2 : (n2 < 1000 ? 1.1 : (n2 < 10000 ? 1.05 : 1.02)));
        return 13 + (int)((double)n2 * d2);
    }
}

