/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkEncoder;
import com.ning.compress.lzf.LZFEncoder;
import com.ning.compress.lzf.util.ChunkEncoderFactory;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;

public class LzfEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final int MIN_BLOCK_TO_COMPRESS = 16;
    private final ChunkEncoder encoder;
    private final BufferRecycler recycler;

    public LzfEncoder() {
        this(false, 65535);
    }

    public LzfEncoder(boolean bl2) {
        this(bl2, 65535);
    }

    public LzfEncoder(int n2) {
        this(false, n2);
    }

    public LzfEncoder(boolean bl2, int n2) {
        super(false);
        if (n2 < 16 || n2 > 65535) {
            throw new IllegalArgumentException("totalLength: " + n2 + " (expected: " + 16 + '-' + 65535 + ')');
        }
        this.encoder = bl2 ? ChunkEncoderFactory.safeNonAllocatingInstance((int)n2) : ChunkEncoderFactory.optimalNonAllocatingInstance((int)n2);
        this.recycler = BufferRecycler.instance();
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2;
        byte[] byArray;
        int n3 = byteBuf.readableBytes();
        int n4 = byteBuf.readerIndex();
        if (byteBuf.hasArray()) {
            byArray = byteBuf.array();
            n2 = byteBuf.arrayOffset() + n4;
        } else {
            byArray = this.recycler.allocInputBuffer(n3);
            byteBuf.getBytes(n4, byArray, 0, n3);
            n2 = 0;
        }
        int n5 = LZFEncoder.estimateMaxWorkspaceSize((int)n3);
        byteBuf2.ensureWritable(n5);
        byte[] byArray2 = byteBuf2.array();
        int n6 = byteBuf2.arrayOffset() + byteBuf2.writerIndex();
        int n7 = LZFEncoder.appendEncoded((ChunkEncoder)this.encoder, (byte[])byArray, (int)n2, (int)n3, (byte[])byArray2, (int)n6) - n6;
        byteBuf2.writerIndex(byteBuf2.writerIndex() + n7);
        byteBuf.skipBytes(n3);
        if (!byteBuf.hasArray()) {
            this.recycler.releaseInputBuffer(byArray);
        }
    }
}

