/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.CompressionException;
import io.netty.handler.codec.compression.Lz4FrameEncoder$1;
import io.netty.handler.codec.compression.Lz4FrameEncoder$2;
import io.netty.handler.codec.compression.Lz4FrameEncoder$3;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.ThrowableUtil;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.xxhash.XXHashFactory;

public class Lz4FrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final EncoderException ENCODE_FINSHED_EXCEPTION = ThrowableUtil.unknownStackTrace(new EncoderException(new IllegalStateException("encode finished and not enough space to write remaining data")), Lz4FrameEncoder.class, "encode");
    static final int DEFAULT_MAX_ENCODE_SIZE = Integer.MAX_VALUE;
    private final int blockSize;
    private final LZ4Compressor compressor;
    private final ByteBufChecksum checksum;
    private final int compressionLevel;
    private ByteBuf buffer;
    private final int maxEncodeSize;
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;

    public Lz4FrameEncoder() {
        this(false);
    }

    public Lz4FrameEncoder(boolean bl2) {
        this(LZ4Factory.fastestInstance(), bl2, 65536, XXHashFactory.fastestInstance().newStreamingHash32(-1756908916).asChecksum());
    }

    public Lz4FrameEncoder(LZ4Factory lZ4Factory, boolean bl2, int n2, Checksum checksum) {
        this(lZ4Factory, bl2, n2, checksum, Integer.MAX_VALUE);
    }

    public Lz4FrameEncoder(LZ4Factory lZ4Factory, boolean bl2, int n2, Checksum checksum, int n3) {
        if (lZ4Factory == null) {
            throw new NullPointerException("factory");
        }
        if (checksum == null) {
            throw new NullPointerException("checksum");
        }
        this.compressor = bl2 ? lZ4Factory.highCompressor() : lZ4Factory.fastCompressor();
        this.checksum = ByteBufChecksum.wrapChecksum(checksum);
        this.compressionLevel = Lz4FrameEncoder.compressionLevel(n2);
        this.blockSize = n2;
        this.maxEncodeSize = ObjectUtil.checkPositive(n3, "maxEncodeSize");
        this.finished = false;
    }

    private static int compressionLevel(int n2) {
        if (n2 < 64 || n2 > 0x2000000) {
            throw new IllegalArgumentException(String.format("blockSize: %d (expected: %d-%d)", n2, 64, 0x2000000));
        }
        int n3 = 32 - Integer.numberOfLeadingZeros(n2 - 1);
        n3 = Math.max(0, n3 - 10);
        return n3;
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl2) {
        return this.allocateBuffer(channelHandlerContext, byteBuf, bl2, true);
    }

    private ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl2, boolean bl3) {
        int n2 = 0;
        int n3 = byteBuf.readableBytes() + this.buffer.readableBytes();
        if (n3 < 0) {
            throw new EncoderException("too much data to allocate a buffer for compression");
        }
        while (n3 > 0) {
            int n4 = Math.min(this.blockSize, n3);
            n3 -= n4;
            n2 += this.compressor.maxCompressedLength(n4) + 21;
        }
        if (n2 > this.maxEncodeSize || 0 > n2) {
            throw new EncoderException(String.format("requested encode buffer size (%d bytes) exceeds the maximum allowable size (%d bytes)", n2, this.maxEncodeSize));
        }
        if (bl3 && n2 < this.blockSize) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (bl2) {
            return channelHandlerContext.alloc().ioBuffer(n2, n2);
        }
        return channelHandlerContext.alloc().heapBuffer(n2, n2);
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2;
        if (this.finished) {
            if (!byteBuf2.isWritable(byteBuf.readableBytes())) {
                throw ENCODE_FINSHED_EXCEPTION;
            }
            byteBuf2.writeBytes(byteBuf);
            return;
        }
        ByteBuf byteBuf3 = this.buffer;
        while ((n2 = byteBuf.readableBytes()) > 0) {
            int n3 = Math.min(n2, byteBuf3.writableBytes());
            byteBuf.readBytes(byteBuf3, n3);
            if (byteBuf3.isWritable()) continue;
            this.flushBufferedData(byteBuf2);
        }
    }

    private void flushBufferedData(ByteBuf byteBuf) {
        int n2;
        int n3;
        int n4 = this.buffer.readableBytes();
        if (n4 == 0) {
            return;
        }
        this.checksum.reset();
        this.checksum.update(this.buffer, this.buffer.readerIndex(), n4);
        int n5 = (int)this.checksum.getValue();
        int n6 = this.compressor.maxCompressedLength(n4) + 21;
        byteBuf.ensureWritable(n6);
        int n7 = byteBuf.writerIndex();
        try {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(n7 + 21, byteBuf.writableBytes() - 21);
            int n8 = byteBuffer.position();
            this.compressor.compress(this.buffer.internalNioBuffer(this.buffer.readerIndex(), n4), byteBuffer);
            n3 = byteBuffer.position() - n8;
        }
        catch (LZ4Exception lZ4Exception) {
            throw new CompressionException(lZ4Exception);
        }
        if (n3 >= n4) {
            n2 = 16;
            n3 = n4;
            byteBuf.setBytes(n7 + 21, this.buffer, 0, n4);
        } else {
            n2 = 32;
        }
        byteBuf.setLong(n7, 5501767354678207339L);
        byteBuf.setByte(n7 + 8, (byte)(n2 | this.compressionLevel));
        byteBuf.setIntLE(n7 + 9, n3);
        byteBuf.setIntLE(n7 + 13, n4);
        byteBuf.setIntLE(n7 + 17, n5);
        byteBuf.writerIndex(n7 + 21 + n3);
        this.buffer.clear();
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        if (this.buffer != null && this.buffer.isReadable()) {
            ByteBuf byteBuf = this.allocateBuffer(channelHandlerContext, Unpooled.EMPTY_BUFFER, this.isPreferDirect(), false);
            this.flushBufferedData(byteBuf);
            channelHandlerContext.write(byteBuf);
        }
        channelHandlerContext.flush();
    }

    private ChannelFuture finishEncode(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.finished) {
            channelPromise.setSuccess();
            return channelPromise;
        }
        this.finished = true;
        ByteBuf byteBuf = channelHandlerContext.alloc().heapBuffer(this.compressor.maxCompressedLength(this.buffer.readableBytes()) + 21);
        this.flushBufferedData(byteBuf);
        int n2 = byteBuf.writerIndex();
        byteBuf.setLong(n2, 5501767354678207339L);
        byteBuf.setByte(n2 + 8, (byte)(0x10 | this.compressionLevel));
        byteBuf.setInt(n2 + 9, 0);
        byteBuf.setInt(n2 + 13, 0);
        byteBuf.setInt(n2 + 17, 0);
        byteBuf.writerIndex(n2 + 21);
        return channelHandlerContext.writeAndFlush(byteBuf, channelPromise);
    }

    public boolean isClosed() {
        return this.finished;
    }

    public ChannelFuture close() {
        return this.close(this.ctx().newPromise());
    }

    public ChannelFuture close(ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext = this.ctx();
        EventExecutor eventExecutor = channelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            return this.finishEncode(channelHandlerContext, channelPromise);
        }
        eventExecutor.execute(new Lz4FrameEncoder$1(this, channelPromise));
        return channelPromise;
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        channelFuture.addListener(new Lz4FrameEncoder$2(this, channelHandlerContext, channelPromise));
        if (!channelFuture.isDone()) {
            channelHandlerContext.executor().schedule(new Lz4FrameEncoder$3(this, channelHandlerContext, channelPromise), 10L, TimeUnit.SECONDS);
        }
    }

    private ChannelHandlerContext ctx() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return channelHandlerContext;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        this.buffer = Unpooled.wrappedBuffer(new byte[this.blockSize]);
        this.buffer.clear();
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        super.handlerRemoved(channelHandlerContext);
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    final ByteBuf getBackingBuffer() {
        return this.buffer;
    }

    static /* synthetic */ ChannelHandlerContext access$000(Lz4FrameEncoder lz4FrameEncoder) {
        return lz4FrameEncoder.ctx();
    }

    static /* synthetic */ ChannelFuture access$100(Lz4FrameEncoder lz4FrameEncoder, ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        return lz4FrameEncoder.finishEncode(channelHandlerContext, channelPromise);
    }
}

