/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.CompressionUtil;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.Lz4FrameDecoder$State;
import io.netty.util.ReferenceCounted;
import java.util.List;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.xxhash.XXHashFactory;

public class Lz4FrameDecoder
extends ByteToMessageDecoder {
    private Lz4FrameDecoder$State currentState = Lz4FrameDecoder$State.INIT_BLOCK;
    private LZ4FastDecompressor decompressor;
    private ByteBufChecksum checksum;
    private int blockType;
    private int compressedLength;
    private int decompressedLength;
    private int currentChecksum;

    public Lz4FrameDecoder() {
        this(false);
    }

    public Lz4FrameDecoder(boolean bl2) {
        this(LZ4Factory.fastestInstance(), bl2);
    }

    public Lz4FrameDecoder(LZ4Factory lZ4Factory, boolean bl2) {
        this(lZ4Factory, bl2 ? XXHashFactory.fastestInstance().newStreamingHash32(-1756908916).asChecksum() : null);
    }

    public Lz4FrameDecoder(LZ4Factory lZ4Factory, Checksum checksum) {
        if (lZ4Factory == null) {
            throw new NullPointerException("factory");
        }
        this.decompressor = lZ4Factory.fastDecompressor();
        this.checksum = checksum == null ? null : ByteBufChecksum.wrapChecksum(checksum);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch (this.currentState) {
                case INIT_BLOCK: {
                    if (byteBuf.readableBytes() < 21) break;
                    long l2 = byteBuf.readLong();
                    if (l2 != 5501767354678207339L) {
                        throw new DecompressionException("unexpected block identifier");
                    }
                    byte by2 = byteBuf.readByte();
                    int n2 = (by2 & 0xF) + 10;
                    int n3 = by2 & 0xF0;
                    int n4 = Integer.reverseBytes(byteBuf.readInt());
                    if (n4 < 0 || n4 > 0x2000000) {
                        throw new DecompressionException(String.format("invalid compressedLength: %d (expected: 0-%d)", n4, 0x2000000));
                    }
                    int n5 = Integer.reverseBytes(byteBuf.readInt());
                    int n6 = 1 << n2;
                    if (n5 < 0 || n5 > n6) {
                        throw new DecompressionException(String.format("invalid decompressedLength: %d (expected: 0-%d)", n5, n6));
                    }
                    if (n5 == 0 && n4 != 0 || n5 != 0 && n4 == 0 || n3 == 16 && n5 != n4) {
                        throw new DecompressionException(String.format("stream corrupted: compressedLength(%d) and decompressedLength(%d) mismatch", n4, n5));
                    }
                    int n7 = Integer.reverseBytes(byteBuf.readInt());
                    if (n5 == 0 && n4 == 0) {
                        if (n7 != 0) {
                            throw new DecompressionException("stream corrupted: checksum error");
                        }
                        this.currentState = Lz4FrameDecoder$State.FINISHED;
                        this.decompressor = null;
                        this.checksum = null;
                        break;
                    }
                    this.blockType = n3;
                    this.compressedLength = n4;
                    this.decompressedLength = n5;
                    this.currentChecksum = n7;
                    this.currentState = Lz4FrameDecoder$State.DECOMPRESS_DATA;
                }
                case DECOMPRESS_DATA: {
                    int n3 = this.blockType;
                    int n4 = this.compressedLength;
                    int n5 = this.decompressedLength;
                    int n7 = this.currentChecksum;
                    if (byteBuf.readableBytes() < n4) break;
                    ByteBufChecksum byteBufChecksum = this.checksum;
                    ReferenceCounted referenceCounted = null;
                    try {
                        switch (n3) {
                            case 16: {
                                referenceCounted = byteBuf.retainedSlice(byteBuf.readerIndex(), n5);
                                break;
                            }
                            case 32: {
                                referenceCounted = channelHandlerContext.alloc().buffer(n5, n5);
                                this.decompressor.decompress(CompressionUtil.safeNioBuffer(byteBuf), ((ByteBuf)referenceCounted).internalNioBuffer(((ByteBuf)referenceCounted).writerIndex(), n5));
                                ((ByteBuf)referenceCounted).writerIndex(((ByteBuf)referenceCounted).writerIndex() + n5);
                                break;
                            }
                            default: {
                                throw new DecompressionException(String.format("unexpected blockType: %d (expected: %d or %d)", n3, 16, 32));
                            }
                        }
                        byteBuf.skipBytes(n4);
                        if (byteBufChecksum != null) {
                            CompressionUtil.checkChecksum(byteBufChecksum, (ByteBuf)referenceCounted, n7);
                        }
                        list.add(referenceCounted);
                        referenceCounted = null;
                        this.currentState = Lz4FrameDecoder$State.INIT_BLOCK;
                        break;
                    }
                    catch (LZ4Exception lZ4Exception) {
                        throw new DecompressionException(lZ4Exception);
                    }
                    finally {
                        if (referenceCounted != null) {
                            referenceCounted.release();
                        }
                    }
                }
                case FINISHED: 
                case CORRUPTED: {
                    byteBuf.skipBytes(byteBuf.readableBytes());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Exception exception) {
            this.currentState = Lz4FrameDecoder$State.CORRUPTED;
            throw exception;
        }
    }

    public boolean isClosed() {
        return this.currentState == Lz4FrameDecoder$State.FINISHED;
    }
}

