/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.JZlib;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.JZlibEncoder$1;
import io.netty.handler.codec.compression.JZlibEncoder$2;
import io.netty.handler.codec.compression.JZlibEncoder$3;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibUtil;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.EmptyArrays;
import java.util.concurrent.TimeUnit;

public class JZlibEncoder
extends ZlibEncoder {
    private final int wrapperOverhead;
    private final Deflater z = new Deflater();
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;

    public JZlibEncoder() {
        this(6);
    }

    public JZlibEncoder(int n2) {
        this(ZlibWrapper.ZLIB, n2);
    }

    public JZlibEncoder(ZlibWrapper zlibWrapper) {
        this(zlibWrapper, 6);
    }

    public JZlibEncoder(ZlibWrapper zlibWrapper, int n2) {
        this(zlibWrapper, n2, 15, 8);
    }

    public JZlibEncoder(ZlibWrapper zlibWrapper, int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n2 + " (expected: 0-9)");
        }
        if (n3 < 9 || n3 > 15) {
            throw new IllegalArgumentException("windowBits: " + n3 + " (expected: 9-15)");
        }
        if (n4 < 1 || n4 > 9) {
            throw new IllegalArgumentException("memLevel: " + n4 + " (expected: 1-9)");
        }
        if (zlibWrapper == null) {
            throw new NullPointerException("wrapper");
        }
        if (zlibWrapper == ZlibWrapper.ZLIB_OR_NONE) {
            throw new IllegalArgumentException("wrapper '" + (Object)((Object)ZlibWrapper.ZLIB_OR_NONE) + "' is not allowed for compression.");
        }
        int n5 = this.z.init(n2, n3, n4, ZlibUtil.convertWrapperType(zlibWrapper));
        if (n5 != 0) {
            ZlibUtil.fail(this.z, "initialization failure", n5);
        }
        this.wrapperOverhead = ZlibUtil.wrapperOverhead(zlibWrapper);
    }

    public JZlibEncoder(byte[] byArray) {
        this(6, byArray);
    }

    public JZlibEncoder(int n2, byte[] byArray) {
        this(n2, 15, 8, byArray);
    }

    public JZlibEncoder(int n2, int n3, int n4, byte[] byArray) {
        if (n2 < 0 || n2 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n2 + " (expected: 0-9)");
        }
        if (n3 < 9 || n3 > 15) {
            throw new IllegalArgumentException("windowBits: " + n3 + " (expected: 9-15)");
        }
        if (n4 < 1 || n4 > 9) {
            throw new IllegalArgumentException("memLevel: " + n4 + " (expected: 1-9)");
        }
        if (byArray == null) {
            throw new NullPointerException("dictionary");
        }
        int n5 = this.z.deflateInit(n2, n3, n4, JZlib.W_ZLIB);
        if (n5 != 0) {
            ZlibUtil.fail(this.z, "initialization failure", n5);
        } else {
            n5 = this.z.deflateSetDictionary(byArray, byArray.length);
            if (n5 != 0) {
                ZlibUtil.fail(this.z, "failed to set the dictionary", n5);
            }
        }
        this.wrapperOverhead = ZlibUtil.wrapperOverhead(ZlibWrapper.ZLIB);
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.ctx().channel().newPromise());
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext = this.ctx();
        EventExecutor eventExecutor = channelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            return this.finishEncode(channelHandlerContext, channelPromise);
        }
        ChannelPromise channelPromise2 = channelHandlerContext.newPromise();
        eventExecutor.execute(new JZlibEncoder$1(this, channelPromise2, channelPromise));
        return channelPromise2;
    }

    private ChannelHandlerContext ctx() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return channelHandlerContext;
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (this.finished) {
            byteBuf2.writeBytes(byteBuf);
            return;
        }
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            return;
        }
        try {
            int n3;
            int n4;
            boolean bl2 = byteBuf.hasArray();
            this.z.avail_in = n2;
            if (bl2) {
                this.z.next_in = byteBuf.array();
                this.z.next_in_index = byteBuf.arrayOffset() + byteBuf.readerIndex();
            } else {
                byte[] byArray = new byte[n2];
                byteBuf.getBytes(byteBuf.readerIndex(), byArray);
                this.z.next_in = byArray;
                this.z.next_in_index = 0;
            }
            int n5 = this.z.next_in_index;
            int n6 = (int)Math.ceil((double)n2 * 1.001) + 12 + this.wrapperOverhead;
            byteBuf2.ensureWritable(n6);
            this.z.avail_out = n6;
            this.z.next_out = byteBuf2.array();
            int n7 = this.z.next_out_index = byteBuf2.arrayOffset() + byteBuf2.writerIndex();
            try {
                n4 = this.z.deflate(2);
            }
            finally {
                byteBuf.skipBytes(this.z.next_in_index - n5);
            }
            if (n4 != 0) {
                ZlibUtil.fail(this.z, "compression failure", n4);
            }
            if ((n3 = this.z.next_out_index - n7) > 0) {
                byteBuf2.writerIndex(byteBuf2.writerIndex() + n3);
            }
        }
        finally {
            this.z.next_in = null;
            this.z.next_out = null;
        }
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        channelFuture.addListener(new JZlibEncoder$2(this, channelHandlerContext, channelPromise));
        if (!channelFuture.isDone()) {
            channelHandlerContext.executor().schedule(new JZlibEncoder$3(this, channelHandlerContext, channelPromise), 10L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture finishEncode(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        ByteBuf byteBuf;
        if (this.finished) {
            channelPromise.setSuccess();
            return channelPromise;
        }
        this.finished = true;
        try {
            this.z.next_in = EmptyArrays.EMPTY_BYTES;
            this.z.next_in_index = 0;
            this.z.avail_in = 0;
            byte[] byArray = new byte[32];
            this.z.next_out = byArray;
            this.z.next_out_index = 0;
            this.z.avail_out = byArray.length;
            int n2 = this.z.deflate(4);
            if (n2 != 0 && n2 != 1) {
                channelPromise.setFailure(ZlibUtil.deflaterException(this.z, "compression failure", n2));
                ChannelPromise channelPromise2 = channelPromise;
                return channelPromise2;
            }
            byteBuf = this.z.next_out_index != 0 ? Unpooled.wrappedBuffer(byArray, 0, this.z.next_out_index) : Unpooled.EMPTY_BUFFER;
        }
        finally {
            this.z.deflateEnd();
            this.z.next_in = null;
            this.z.next_out = null;
        }
        return channelHandlerContext.writeAndFlush(byteBuf, channelPromise);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    static /* synthetic */ ChannelHandlerContext access$000(JZlibEncoder jZlibEncoder) {
        return jZlibEncoder.ctx();
    }

    static /* synthetic */ ChannelFuture access$100(JZlibEncoder jZlibEncoder, ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        return jZlibEncoder.finishEncode(channelHandlerContext, channelPromise);
    }
}

