/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.FastLz;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class FastLzFrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final int level;
    private final Checksum checksum;

    public FastLzFrameEncoder() {
        this(0, null);
    }

    public FastLzFrameEncoder(int n2) {
        this(n2, null);
    }

    public FastLzFrameEncoder(boolean bl2) {
        this(0, bl2 ? new Adler32() : null);
    }

    public FastLzFrameEncoder(int n2, Checksum checksum) {
        super(false);
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException(String.format("level: %d (expected: %d or %d or %d)", n2, 0, 1, 2));
        }
        this.level = n2;
        this.checksum = checksum;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        Checksum checksum = this.checksum;
        while (byteBuf.isReadable()) {
            int n2;
            int n3;
            byte[] byArray;
            int n4;
            int n5 = byteBuf.readerIndex();
            int n6 = Math.min(byteBuf.readableBytes(), 65535);
            int n7 = byteBuf2.writerIndex();
            byteBuf2.setMedium(n7, 4607066);
            int n8 = n7 + 4 + (checksum != null ? 4 : 0);
            if (n6 < 32) {
                n4 = 0;
                byteBuf2.ensureWritable(n8 + 2 + n6);
                byArray = byteBuf2.array();
                n3 = byteBuf2.arrayOffset() + n8 + 2;
                if (checksum != null) {
                    int n9;
                    byte[] byArray2;
                    if (byteBuf.hasArray()) {
                        byArray2 = byteBuf.array();
                        n9 = byteBuf.arrayOffset() + n5;
                    } else {
                        byArray2 = new byte[n6];
                        byteBuf.getBytes(n5, byArray2);
                        n9 = 0;
                    }
                    checksum.reset();
                    checksum.update(byArray2, n9, n6);
                    byteBuf2.setInt(n7 + 4, (int)checksum.getValue());
                    System.arraycopy(byArray2, n9, byArray, n3, n6);
                } else {
                    byteBuf.getBytes(n5, byArray, n3, n6);
                }
                n2 = n6;
            } else {
                if (byteBuf.hasArray()) {
                    byArray = byteBuf.array();
                    n3 = byteBuf.arrayOffset() + n5;
                } else {
                    byArray = new byte[n6];
                    byteBuf.getBytes(n5, byArray);
                    n3 = 0;
                }
                if (checksum != null) {
                    checksum.reset();
                    checksum.update(byArray, n3, n6);
                    byteBuf2.setInt(n7 + 4, (int)checksum.getValue());
                }
                int n10 = FastLz.calculateOutputBufferLength(n6);
                byteBuf2.ensureWritable(n8 + 4 + n10);
                byte[] byArray3 = byteBuf2.array();
                int n11 = byteBuf2.arrayOffset() + n8 + 4;
                int n12 = FastLz.compress(byArray, n3, n6, byArray3, n11, this.level);
                if (n12 < n6) {
                    n4 = 1;
                    n2 = n12;
                    byteBuf2.setShort(n8, n2);
                    n8 += 2;
                } else {
                    n4 = 0;
                    System.arraycopy(byArray, n3, byArray3, n11 - 2, n6);
                    n2 = n6;
                }
            }
            byteBuf2.setShort(n8, n6);
            byteBuf2.setByte(n7 + 3, n4 | (checksum != null ? 16 : 0));
            byteBuf2.writerIndex(n8 + 2 + n2);
            byteBuf.skipBytes(n6);
        }
        return;
    }
}

