/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.FastLz;
import io.netty.handler.codec.compression.FastLzFrameDecoder$State;
import io.netty.util.internal.EmptyArrays;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class FastLzFrameDecoder
extends ByteToMessageDecoder {
    private FastLzFrameDecoder$State currentState = FastLzFrameDecoder$State.INIT_BLOCK;
    private final Checksum checksum;
    private int chunkLength;
    private int originalLength;
    private boolean isCompressed;
    private boolean hasChecksum;
    private int currentChecksum;

    public FastLzFrameDecoder() {
        this(false);
    }

    public FastLzFrameDecoder(boolean bl2) {
        this(bl2 ? new Adler32() : null);
    }

    public FastLzFrameDecoder(Checksum checksum) {
        this.checksum = checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch (this.currentState) {
                case INIT_BLOCK: {
                    if (byteBuf.readableBytes() < 4) break;
                    int n2 = byteBuf.readUnsignedMedium();
                    if (n2 != 4607066) {
                        throw new DecompressionException("unexpected block identifier");
                    }
                    byte by2 = byteBuf.readByte();
                    this.isCompressed = (by2 & 1) == 1;
                    this.hasChecksum = (by2 & 0x10) == 16;
                    this.currentState = FastLzFrameDecoder$State.INIT_BLOCK_PARAMS;
                }
                case INIT_BLOCK_PARAMS: {
                    if (byteBuf.readableBytes() < 2 + (this.isCompressed ? 2 : 0) + (this.hasChecksum ? 4 : 0)) break;
                    this.currentChecksum = this.hasChecksum ? byteBuf.readInt() : 0;
                    this.chunkLength = byteBuf.readUnsignedShort();
                    this.originalLength = this.isCompressed ? byteBuf.readUnsignedShort() : this.chunkLength;
                    this.currentState = FastLzFrameDecoder$State.DECOMPRESS_DATA;
                }
                case DECOMPRESS_DATA: {
                    int n3;
                    byte[] byArray;
                    ByteBuf byteBuf2;
                    int n4 = this.chunkLength;
                    if (byteBuf.readableBytes() < n4) break;
                    int n5 = byteBuf.readerIndex();
                    int n6 = this.originalLength;
                    if (n6 != 0) {
                        byteBuf2 = channelHandlerContext.alloc().heapBuffer(n6, n6);
                        byArray = byteBuf2.array();
                        n3 = byteBuf2.arrayOffset() + byteBuf2.writerIndex();
                    } else {
                        byteBuf2 = null;
                        byArray = EmptyArrays.EMPTY_BYTES;
                        n3 = 0;
                    }
                    boolean bl2 = false;
                    try {
                        int n7;
                        Object object;
                        if (this.isCompressed) {
                            if (byteBuf.hasArray()) {
                                object = byteBuf.array();
                                n7 = byteBuf.arrayOffset() + n5;
                            } else {
                                object = new byte[n4];
                                byteBuf.getBytes(n5, (byte[])object);
                                n7 = 0;
                            }
                            int n8 = FastLz.decompress((byte[])object, n7, n4, byArray, n3, n6);
                            if (n6 != n8) {
                                throw new DecompressionException(String.format("stream corrupted: originalLength(%d) and actual length(%d) mismatch", n6, n8));
                            }
                        } else {
                            byteBuf.getBytes(n5, byArray, n3, n4);
                        }
                        object = this.checksum;
                        if (this.hasChecksum && object != null) {
                            object.reset();
                            object.update(byArray, n3, n6);
                            n7 = (int)object.getValue();
                            if (n7 != this.currentChecksum) {
                                throw new DecompressionException(String.format("stream corrupted: mismatching checksum: %d (expected: %d)", n7, this.currentChecksum));
                            }
                        }
                        if (byteBuf2 != null) {
                            byteBuf2.writerIndex(byteBuf2.writerIndex() + n6);
                            list.add(byteBuf2);
                        }
                        byteBuf.skipBytes(n4);
                        this.currentState = FastLzFrameDecoder$State.INIT_BLOCK;
                        bl2 = true;
                        break;
                    }
                    finally {
                        if (!bl2 && byteBuf2 != null) {
                            byteBuf2.release();
                        }
                    }
                }
                case CORRUPTED: {
                    byteBuf.skipBytes(byteBuf.readableBytes());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Exception exception) {
            this.currentState = FastLzFrameDecoder$State.CORRUPTED;
            throw exception;
        }
    }
}

