/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.handler.codec.compression.DecompressionException;

final class FastLz {
    private static final int MAX_DISTANCE = 8191;
    private static final int MAX_FARDISTANCE = 73725;
    private static final int HASH_LOG = 13;
    private static final int HASH_SIZE = 8192;
    private static final int HASH_MASK = 8191;
    private static final int MAX_COPY = 32;
    private static final int MAX_LEN = 264;
    private static final int MIN_RECOMENDED_LENGTH_FOR_LEVEL_2 = 65536;
    static final int MAGIC_NUMBER = 4607066;
    static final byte BLOCK_TYPE_NON_COMPRESSED = 0;
    static final byte BLOCK_TYPE_COMPRESSED = 1;
    static final byte BLOCK_WITHOUT_CHECKSUM = 0;
    static final byte BLOCK_WITH_CHECKSUM = 16;
    static final int OPTIONS_OFFSET = 3;
    static final int CHECKSUM_OFFSET = 4;
    static final int MAX_CHUNK_LENGTH = 65535;
    static final int MIN_LENGTH_TO_COMPRESSION = 32;
    static final int LEVEL_AUTO = 0;
    static final int LEVEL_1 = 1;
    static final int LEVEL_2 = 2;

    static int calculateOutputBufferLength(int n2) {
        int n3 = (int)((double)n2 * 1.06);
        return Math.max(n3, 66);
    }

    static int compress(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        int n6;
        int n7 = n5 == 0 ? (n3 < 65536 ? 1 : 2) : n5;
        int n8 = 0;
        int n9 = n8 + n3 - 2;
        int n10 = n8 + n3 - 12;
        int n11 = 0;
        int[] nArray = new int[8192];
        if (n3 < 4) {
            if (n3 != 0) {
                byArray2[n4 + n11++] = (byte)(n3 - 1);
                ++n9;
                while (n8 <= n9) {
                    byArray2[n4 + n11++] = byArray[n2 + n8++];
                }
                return n3 + 1;
            }
            return 0;
        }
        for (n6 = 0; n6 < 8192; ++n6) {
            nArray[n6] = n8;
        }
        int n12 = 2;
        byArray2[n4 + n11++] = 31;
        byArray2[n4 + n11++] = byArray[n2 + n8++];
        byArray2[n4 + n11++] = byArray[n2 + n8++];
        while (n8 < n10) {
            int n13;
            int n14;
            long l2;
            int n15;
            block37: {
                int n16;
                block39: {
                    block38: {
                        n15 = 0;
                        l2 = 0L;
                        n14 = 3;
                        n16 = n8;
                        boolean bl2 = false;
                        if (n7 == 2 && byArray[n2 + n8] == byArray[n2 + n8 - 1] && FastLz.readU16(byArray, n2 + n8 - 1) == FastLz.readU16(byArray, n2 + n8 + 1)) {
                            l2 = 1L;
                            n8 += 3;
                            n15 = n16 + 2;
                            bl2 = true;
                        }
                        if (bl2) break block37;
                        n6 = n13 = FastLz.hashFunction(byArray, n2 + n8);
                        n15 = nArray[n13];
                        l2 = n16 - n15;
                        nArray[n6] = n16;
                        if (l2 == 0L || (n7 != 1 ? l2 >= 73725L : l2 >= 8191L)) break block38;
                        if (byArray[n2 + n15++] == byArray[n2 + n8++] && byArray[n2 + n15++] == byArray[n2 + n8++] && byArray[n2 + n15++] == byArray[n2 + n8++]) break block39;
                    }
                    byArray2[n4 + n11++] = byArray[n2 + n16++];
                    n8 = n16;
                    if (++n12 != 32) continue;
                    n12 = 0;
                    byArray2[n4 + n11++] = 31;
                    continue;
                }
                if (n7 == 2 && l2 >= 8191L) {
                    if (byArray[n2 + n8++] != byArray[n2 + n15++] || byArray[n2 + n8++] != byArray[n2 + n15++]) {
                        byArray2[n4 + n11++] = byArray[n2 + n16++];
                        n8 = n16;
                        if (++n12 != 32) continue;
                        n12 = 0;
                        byArray2[n4 + n11++] = 31;
                        continue;
                    }
                    n14 += 2;
                }
            }
            if (--l2 == 0L) {
                byte by2 = byArray[n2 + n8 - 1];
                for (n8 = n16 + n14; n8 < n9 && byArray[n2 + n15++] == by2; ++n8) {
                }
            } else if (byArray[n2 + n15++] == byArray[n2 + n8++] && byArray[n2 + n15++] == byArray[n2 + n8++] && byArray[n2 + n15++] == byArray[n2 + n8++] && byArray[n2 + n15++] == byArray[n2 + n8++] && byArray[n2 + n15++] == byArray[n2 + n8++] && byArray[n2 + n15++] == byArray[n2 + n8++] && byArray[n2 + n15++] == byArray[n2 + n8++] && byArray[n2 + n15++] == byArray[n2 + n8++]) {
                while (n8 < n9 && byArray[n2 + n15++] == byArray[n2 + n8++]) {
                }
            }
            if (n12 != 0) {
                byArray2[n4 + n11 - n12 - 1] = (byte)(n12 - 1);
            } else {
                --n11;
            }
            n12 = 0;
            if (n7 == 2) {
                if (l2 < 8191L) {
                    if (n14 < 7) {
                        byArray2[n4 + n11++] = (byte)((long)(n14 << 5) + (l2 >>> 8));
                        byArray2[n4 + n11++] = (byte)(l2 & 0xFFL);
                    } else {
                        byArray2[n4 + n11++] = (byte)(224L + (l2 >>> 8));
                        n14 -= 7;
                        while (n14 >= 255) {
                            byArray2[n4 + n11++] = -1;
                            n14 -= 255;
                        }
                        byArray2[n4 + n11++] = (byte)n14;
                        byArray2[n4 + n11++] = (byte)(l2 & 0xFFL);
                    }
                } else if (n14 < 7) {
                    byArray2[n4 + n11++] = (byte)((n14 << 5) + 31);
                    byArray2[n4 + n11++] = -1;
                    byArray2[n4 + n11++] = (byte)((l2 -= 8191L) >>> 8);
                    byArray2[n4 + n11++] = (byte)(l2 & 0xFFL);
                } else {
                    l2 -= 8191L;
                    byArray2[n4 + n11++] = -1;
                    n14 -= 7;
                    while (n14 >= 255) {
                        byArray2[n4 + n11++] = -1;
                        n14 -= 255;
                    }
                    byArray2[n4 + n11++] = (byte)n14;
                    byArray2[n4 + n11++] = -1;
                    byArray2[n4 + n11++] = (byte)(l2 >>> 8);
                    byArray2[n4 + n11++] = (byte)(l2 & 0xFFL);
                }
            } else {
                if (n14 > 262) {
                    for (n14 = (n8 -= 3) - n16; n14 > 262; n14 -= 262) {
                        byArray2[n4 + n11++] = (byte)(224L + (l2 >>> 8));
                        byArray2[n4 + n11++] = -3;
                        byArray2[n4 + n11++] = (byte)(l2 & 0xFFL);
                    }
                }
                if (n14 < 7) {
                    byArray2[n4 + n11++] = (byte)((long)(n14 << 5) + (l2 >>> 8));
                    byArray2[n4 + n11++] = (byte)(l2 & 0xFFL);
                } else {
                    byArray2[n4 + n11++] = (byte)(224L + (l2 >>> 8));
                    byArray2[n4 + n11++] = (byte)(n14 - 7);
                    byArray2[n4 + n11++] = (byte)(l2 & 0xFFL);
                }
            }
            n13 = FastLz.hashFunction(byArray, n2 + n8);
            nArray[n13] = n8++;
            n13 = FastLz.hashFunction(byArray, n2 + n8);
            nArray[n13] = n8++;
            byArray2[n4 + n11++] = 31;
        }
        ++n9;
        while (n8 <= n9) {
            byArray2[n4 + n11++] = byArray[n2 + n8++];
            if (++n12 != 32) continue;
            n12 = 0;
            byArray2[n4 + n11++] = 31;
        }
        if (n12 != 0) {
            byArray2[n4 + n11 - n12 - 1] = (byte)(n12 - 1);
        } else {
            --n11;
        }
        if (n7 == 2) {
            int n17 = n4;
            byArray2[n17] = (byte)(byArray2[n17] | 0x20);
        }
        return n11;
    }

    static int decompress(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        int n6 = (byArray[n2] >> 5) + 1;
        if (n6 != 1 && n6 != 2) {
            throw new DecompressionException(String.format("invalid level: %d (expected: %d or %d)", n6, 1, 2));
        }
        int n7 = 0;
        int n8 = 0;
        long l2 = byArray[n2 + n7++] & 0x1F;
        boolean bl2 = true;
        do {
            int n9 = n8;
            long l3 = l2 >> 5;
            long l4 = (l2 & 0x1FL) << 8;
            if (l2 >= 32L) {
                int n10;
                n9 = (int)((long)n9 - l4);
                if (--l3 == 6L) {
                    if (n6 == 1) {
                        l3 += (long)(byArray[n2 + n7++] & 0xFF);
                    } else {
                        do {
                            n10 = byArray[n2 + n7++] & 0xFF;
                            l3 += (long)n10;
                        } while (n10 == 255);
                    }
                }
                if (n6 == 1) {
                    n9 -= byArray[n2 + n7++] & 0xFF;
                } else {
                    n10 = byArray[n2 + n7++] & 0xFF;
                    n9 -= n10;
                    if (n10 == 255 && l4 == 7936L) {
                        l4 = (byArray[n2 + n7++] & 0xFF) << 8;
                        n9 = (int)((long)n8 - (l4 += (long)(byArray[n2 + n7++] & 0xFF)) - 8191L);
                    }
                }
                if ((long)n8 + l3 + 3L > (long)n5) {
                    return 0;
                }
                if (n9 - 1 < 0) {
                    return 0;
                }
                if (n7 < n3) {
                    l2 = byArray[n2 + n7++] & 0xFF;
                } else {
                    bl2 = false;
                }
                if (n9 == n8) {
                    byte by2 = byArray2[n4 + n9 - 1];
                    byArray2[n4 + n8++] = by2;
                    byArray2[n4 + n8++] = by2;
                    byArray2[n4 + n8++] = by2;
                    while (l3 != 0L) {
                        byArray2[n4 + n8++] = by2;
                        --l3;
                    }
                } else {
                    int n11 = n8++;
                    int n12 = --n9;
                    byArray2[n4 + n11] = byArray2[n4 + n12];
                    int n13 = n8++;
                    int n14 = ++n9;
                    byArray2[n4 + n13] = byArray2[n4 + n14];
                    int n15 = n8++;
                    int n16 = ++n9;
                    ++n9;
                    byArray2[n4 + n15] = byArray2[n4 + n16];
                    while (l3 != 0L) {
                        byArray2[n4 + n8++] = byArray2[n4 + n9++];
                        --l3;
                    }
                }
            } else {
                if ((long)n8 + ++l2 > (long)n5) {
                    return 0;
                }
                if ((long)n7 + l2 > (long)n3) {
                    return 0;
                }
                byArray2[n4 + n8++] = byArray[n2 + n7++];
                --l2;
                while (l2 != 0L) {
                    byArray2[n4 + n8++] = byArray[n2 + n7++];
                    --l2;
                }
                boolean bl3 = bl2 = n7 < n3;
                if (!bl2) continue;
                l2 = byArray[n2 + n7++] & 0xFF;
            }
        } while (bl2);
        return n8;
    }

    private static int hashFunction(byte[] byArray, int n2) {
        int n3 = FastLz.readU16(byArray, n2);
        n3 ^= FastLz.readU16(byArray, n2 + 1) ^ n3 >> 3;
        return n3 &= 0x1FFF;
    }

    private static int readU16(byte[] byArray, int n2) {
        if (n2 + 1 >= byArray.length) {
            return byArray[n2] & 0xFF;
        }
        return (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2] & 0xFF;
    }

    private FastLz() {
    }
}

