/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.handler.codec.compression.Bzip2MoveToFrontTable;

final class Bzip2MTFAndRLE2StageEncoder {
    private final int[] bwtBlock;
    private final int bwtLength;
    private final boolean[] bwtValuesPresent;
    private final char[] mtfBlock;
    private int mtfLength;
    private final int[] mtfSymbolFrequencies = new int[258];
    private int alphabetSize;

    Bzip2MTFAndRLE2StageEncoder(int[] nArray, int n2, boolean[] blArray) {
        this.bwtBlock = nArray;
        this.bwtLength = n2;
        this.bwtValuesPresent = blArray;
        this.mtfBlock = new char[n2 + 1];
    }

    void encode() {
        int n2;
        int n3 = this.bwtLength;
        boolean[] blArray = this.bwtValuesPresent;
        int[] nArray = this.bwtBlock;
        char[] cArray = this.mtfBlock;
        int[] nArray2 = this.mtfSymbolFrequencies;
        byte[] byArray = new byte[256];
        Bzip2MoveToFrontTable bzip2MoveToFrontTable = new Bzip2MoveToFrontTable();
        int n4 = 0;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            if (!blArray[n2]) continue;
            byArray[n2] = (byte)n4++;
        }
        n2 = n4 + 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n9 = bzip2MoveToFrontTable.valueToFront(byArray[nArray[i2] & 0xFF]);
            if (n9 == 0) {
                ++n6;
                continue;
            }
            if (n6 > 0) {
                --n6;
                while (true) {
                    if ((n6 & 1) == 0) {
                        cArray[n5++] = '\u0000';
                        ++n7;
                    } else {
                        cArray[n5++] = '\u0001';
                        ++n8;
                    }
                    if (n6 <= 1) break;
                    n6 = n6 - 2 >>> 1;
                }
                n6 = 0;
            }
            cArray[n5++] = (char)(n9 + 1);
            int n10 = n9 + 1;
            nArray2[n10] = nArray2[n10] + 1;
        }
        if (n6 > 0) {
            --n6;
            while (true) {
                if ((n6 & 1) == 0) {
                    cArray[n5++] = '\u0000';
                    ++n7;
                } else {
                    cArray[n5++] = '\u0001';
                    ++n8;
                }
                if (n6 <= 1) break;
                n6 = n6 - 2 >>> 1;
            }
        }
        cArray[n5] = (char)n2;
        int n11 = n2;
        nArray2[n11] = nArray2[n11] + 1;
        nArray2[0] = nArray2[0] + n7;
        nArray2[1] = nArray2[1] + n8;
        this.mtfLength = n5 + 1;
        this.alphabetSize = n2 + 1;
    }

    char[] mtfBlock() {
        return this.mtfBlock;
    }

    int mtfLength() {
        return this.mtfLength;
    }

    int mtfAlphabetSize() {
        return this.alphabetSize;
    }

    int[] mtfSymbolFrequencies() {
        return this.mtfSymbolFrequencies;
    }
}

