/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.Bzip2BitWriter;
import io.netty.handler.codec.compression.Bzip2HuffmanAllocator;
import io.netty.handler.codec.compression.Bzip2MoveToFrontTable;
import java.util.Arrays;

final class Bzip2HuffmanStageEncoder {
    private static final int HUFFMAN_HIGH_SYMBOL_COST = 15;
    private final Bzip2BitWriter writer;
    private final char[] mtfBlock;
    private final int mtfLength;
    private final int mtfAlphabetSize;
    private final int[] mtfSymbolFrequencies;
    private final int[][] huffmanCodeLengths;
    private final int[][] huffmanMergedCodeSymbols;
    private final byte[] selectors;

    Bzip2HuffmanStageEncoder(Bzip2BitWriter bzip2BitWriter, char[] cArray, int n2, int n3, int[] nArray) {
        this.writer = bzip2BitWriter;
        this.mtfBlock = cArray;
        this.mtfLength = n2;
        this.mtfAlphabetSize = n3;
        this.mtfSymbolFrequencies = nArray;
        int n4 = Bzip2HuffmanStageEncoder.selectTableCount(n2);
        this.huffmanCodeLengths = new int[n4][n3];
        this.huffmanMergedCodeSymbols = new int[n4][n3];
        this.selectors = new byte[(n2 + 50 - 1) / 50];
    }

    private static int selectTableCount(int n2) {
        if (n2 >= 2400) {
            return 6;
        }
        if (n2 >= 1200) {
            return 5;
        }
        if (n2 >= 600) {
            return 4;
        }
        if (n2 >= 200) {
            return 3;
        }
        return 2;
    }

    private static void generateHuffmanCodeLengths(int n2, int[] nArray, int[] nArray2) {
        int n3;
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            nArray3[n3] = nArray[n3] << 9 | n3;
        }
        Arrays.sort(nArray3);
        for (n3 = 0; n3 < n2; ++n3) {
            nArray4[n3] = nArray3[n3] >>> 9;
        }
        Bzip2HuffmanAllocator.allocateHuffmanCodeLengths(nArray4, 20);
        for (n3 = 0; n3 < n2; ++n3) {
            nArray2[nArray3[n3] & 0x1FF] = nArray4[n3];
        }
    }

    private void generateHuffmanOptimisationSeeds() {
        int[][] nArray = this.huffmanCodeLengths;
        int[] nArray2 = this.mtfSymbolFrequencies;
        int n2 = this.mtfAlphabetSize;
        int n3 = nArray.length;
        int n4 = this.mtfLength;
        int n5 = -1;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6;
            int n7 = n4 / (n3 - i2);
            int n8 = n5 + 1;
            for (n6 = 0; n6 < n7 && n5 < n2 - 1; n6 += nArray2[++n5]) {
            }
            if (n5 > n8 && i2 != 0 && i2 != n3 - 1 && (n3 - i2 & 1) == 0) {
                n6 -= nArray2[n5--];
            }
            int[] nArray3 = nArray[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                if (i3 >= n8 && i3 <= n5) continue;
                nArray3[i3] = 15;
            }
            n4 -= n6;
        }
    }

    private void optimiseSelectorsAndHuffmanTables(boolean bl2) {
        char[] cArray = this.mtfBlock;
        byte[] byArray = this.selectors;
        int[][] nArray = this.huffmanCodeLengths;
        int n2 = this.mtfLength;
        int n3 = this.mtfAlphabetSize;
        int n4 = nArray.length;
        int[][] nArray2 = new int[n4][n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11 = Math.min(n6 + 50, n2) - 1;
            short[] sArray = new short[n4];
            for (n10 = n6; n10 <= n11; ++n10) {
                n9 = cArray[n10];
                for (n8 = 0; n8 < n4; ++n8) {
                    int n12 = n8;
                    sArray[n12] = (short)(sArray[n12] + nArray[n8][n9]);
                }
            }
            n10 = 0;
            n9 = sArray[0];
            for (n8 = 1; n8 < n4; n8 = (int)((byte)(n8 + 1))) {
                n7 = sArray[n8];
                if (n7 >= n9) continue;
                n9 = n7;
                n10 = n8;
            }
            int[] nArray3 = nArray2[n10];
            for (n7 = n6; n7 <= n11; ++n7) {
                char c2 = cArray[n7];
                nArray3[c2] = nArray3[c2] + 1;
            }
            if (bl2) {
                byArray[n5++] = n10;
            }
            n6 = n11 + 1;
        }
        for (n6 = 0; n6 < n4; ++n6) {
            Bzip2HuffmanStageEncoder.generateHuffmanCodeLengths(n3, nArray2[n6], nArray[n6]);
        }
    }

    private void assignHuffmanCodeSymbols() {
        int[][] nArray = this.huffmanMergedCodeSymbols;
        int[][] nArray2 = this.huffmanCodeLengths;
        int n2 = this.mtfAlphabetSize;
        int n3 = nArray2.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            int n5;
            int[] nArray3 = nArray2[i2];
            int n6 = 32;
            int n7 = 0;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = nArray3[n5];
                if (n4 > n7) {
                    n7 = n4;
                }
                if (n4 >= n6) continue;
                n6 = n4;
            }
            n5 = 0;
            for (n4 = n6; n4 <= n7; ++n4) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    if ((nArray2[i2][i3] & 0xFF) != n4) continue;
                    nArray[i2][i3] = n4 << 24 | n5;
                    ++n5;
                }
                n5 <<= 1;
            }
        }
    }

    private void writeSelectorsAndHuffmanTables(ByteBuf byteBuf) {
        Bzip2BitWriter bzip2BitWriter = this.writer;
        byte[] byArray = this.selectors;
        int n2 = byArray.length;
        int[][] nArray = this.huffmanCodeLengths;
        int n3 = nArray.length;
        int n4 = this.mtfAlphabetSize;
        bzip2BitWriter.writeBits(byteBuf, 3, n3);
        bzip2BitWriter.writeBits(byteBuf, 15, n2);
        Bzip2MoveToFrontTable bzip2MoveToFrontTable = new Bzip2MoveToFrontTable();
        for (byte by3 : byArray) {
            bzip2BitWriter.writeUnary(byteBuf, bzip2MoveToFrontTable.valueToFront(by3));
        }
        for (int[] nArray2 : nArray) {
            int n5 = nArray2[0];
            bzip2BitWriter.writeBits(byteBuf, 5, n5);
            for (int i2 = 0; i2 < n4; ++i2) {
                int n6 = nArray2[i2];
                int n7 = n5 < n6 ? 2 : 3;
                int n8 = Math.abs(n6 - n5);
                while (n8-- > 0) {
                    bzip2BitWriter.writeBits(byteBuf, 2, n7);
                }
                bzip2BitWriter.writeBoolean(byteBuf, false);
                n5 = n6;
            }
        }
    }

    private void writeBlockData(ByteBuf byteBuf) {
        Bzip2BitWriter bzip2BitWriter = this.writer;
        int[][] nArray = this.huffmanMergedCodeSymbols;
        byte[] byArray = this.selectors;
        char[] cArray = this.mtfBlock;
        int n2 = this.mtfLength;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = Math.min(n4 + 50, n2) - 1;
            int[] nArray2 = nArray[byArray[n3++]];
            while (n4 <= n5) {
                int n6 = nArray2[cArray[n4++]];
                bzip2BitWriter.writeBits(byteBuf, n6 >>> 24, n6);
            }
        }
    }

    void encode(ByteBuf byteBuf) {
        this.generateHuffmanOptimisationSeeds();
        for (int i2 = 3; i2 >= 0; --i2) {
            this.optimiseSelectorsAndHuffmanTables(i2 == 0);
        }
        this.assignHuffmanCodeSymbols();
        this.writeSelectorsAndHuffmanTables(byteBuf);
        this.writeBlockData(byteBuf);
    }
}

