/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.handler.codec.compression.Bzip2BitReader;
import io.netty.handler.codec.compression.Bzip2MoveToFrontTable;
import io.netty.handler.codec.compression.DecompressionException;

final class Bzip2HuffmanStageDecoder {
    private final Bzip2BitReader reader;
    byte[] selectors;
    private final int[] minimumLengths;
    private final int[][] codeBases;
    private final int[][] codeLimits;
    private final int[][] codeSymbols;
    private int currentTable;
    private int groupIndex = -1;
    private int groupPosition = -1;
    final int totalTables;
    final int alphabetSize;
    final Bzip2MoveToFrontTable tableMTF = new Bzip2MoveToFrontTable();
    int currentSelector;
    final byte[][] tableCodeLengths;
    int currentGroup;
    int currentLength = -1;
    int currentAlpha;
    boolean modifyLength;

    Bzip2HuffmanStageDecoder(Bzip2BitReader bzip2BitReader, int n2, int n3) {
        this.reader = bzip2BitReader;
        this.totalTables = n2;
        this.alphabetSize = n3;
        this.minimumLengths = new int[n2];
        this.codeBases = new int[n2][25];
        this.codeLimits = new int[n2][24];
        this.codeSymbols = new int[n2][258];
        this.tableCodeLengths = new byte[n2][258];
    }

    void createHuffmanDecodingTables() {
        int n2 = this.alphabetSize;
        for (int i2 = 0; i2 < this.tableCodeLengths.length; ++i2) {
            int n3;
            int n4;
            int n5;
            int[] nArray = this.codeBases[i2];
            int[] nArray2 = this.codeLimits[i2];
            int[] nArray3 = this.codeSymbols[i2];
            byte[] byArray = this.tableCodeLengths[i2];
            int n6 = 23;
            int n7 = 0;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = byArray[n5];
                n7 = Math.max(n4, n7);
                n6 = Math.min(n4, n6);
            }
            this.minimumLengths[i2] = n6;
            for (n5 = 0; n5 < n2; ++n5) {
                int n8 = byArray[n5] + 1;
                nArray[n8] = nArray[n8] + 1;
            }
            n4 = nArray[0];
            for (n5 = 1; n5 < 25; ++n5) {
                nArray[n5] = n4 += nArray[n5];
            }
            n4 = 0;
            for (n5 = n6; n5 <= n7; ++n5) {
                n3 = n4;
                nArray[n5] = n3 - nArray[n5];
                nArray2[n5] = (n4 += nArray[n5 + 1] - nArray[n5]) - 1;
                n4 <<= 1;
            }
            n4 = 0;
            for (n5 = n6; n5 <= n7; ++n5) {
                for (n3 = 0; n3 < n2; ++n3) {
                    if (byArray[n3] != n5) continue;
                    nArray3[n4++] = n3;
                }
            }
        }
        this.currentTable = this.selectors[0];
    }

    int nextSymbol() {
        int n2;
        if (++this.groupPosition % 50 == 0) {
            ++this.groupIndex;
            if (this.groupIndex == this.selectors.length) {
                throw new DecompressionException("error decoding block");
            }
            this.currentTable = this.selectors[this.groupIndex] & 0xFF;
        }
        Bzip2BitReader bzip2BitReader = this.reader;
        int n3 = this.currentTable;
        int[] nArray = this.codeLimits[n3];
        int[] nArray2 = this.codeBases[n3];
        int[] nArray3 = this.codeSymbols[n3];
        int n4 = bzip2BitReader.readBits(n2);
        for (n2 = this.minimumLengths[n3]; n2 <= 23; ++n2) {
            if (n4 <= nArray[n2]) {
                return nArray3[n4 - nArray2[n2]];
            }
            n4 = n4 << 1 | bzip2BitReader.readBits(1);
        }
        throw new DecompressionException("a valid code was not recognised");
    }
}

