/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

final class Bzip2HuffmanAllocator {
    private static int first(int[] nArray, int n2, int n3) {
        int n4 = nArray.length;
        int n5 = n2;
        int n6 = nArray.length - 2;
        while (n2 >= n3 && nArray[n2] % n4 > n5) {
            n6 = n2;
            n2 -= n5 - n2 + 1;
        }
        n2 = Math.max(n3 - 1, n2);
        while (n6 > n2 + 1) {
            int n7 = n2 + n6 >>> 1;
            if (nArray[n7] % n4 > n5) {
                n6 = n7;
                continue;
            }
            n2 = n7;
        }
        return n6;
    }

    private static void setExtendedParentPointers(int[] nArray) {
        int n2 = nArray.length;
        nArray[0] = nArray[0] + nArray[1];
        int n3 = 0;
        int n4 = 2;
        for (int i2 = 1; i2 < n2 - 1; ++i2) {
            int n5;
            if (n4 >= n2 || nArray[n3] < nArray[n4]) {
                n5 = nArray[n3];
                nArray[n3++] = i2;
            } else {
                n5 = nArray[n4++];
            }
            if (n4 >= n2 || n3 < i2 && nArray[n3] < nArray[n4]) {
                n5 += nArray[n3];
                nArray[n3++] = i2 + n2;
            } else {
                n5 += nArray[n4++];
            }
            nArray[i2] = n5;
        }
    }

    private static int findNodesToRelocate(int[] nArray, int n2) {
        int n3 = nArray.length - 2;
        for (int i2 = 1; i2 < n2 - 1 && n3 > 1; ++i2) {
            n3 = Bzip2HuffmanAllocator.first(nArray, n3 - 1, 0);
        }
        return n3;
    }

    private static void allocateNodeLengths(int[] nArray) {
        int n2 = nArray.length - 2;
        int n3 = nArray.length - 1;
        int n4 = 1;
        int n5 = 2;
        while (n5 > 0) {
            int n6 = n2;
            n2 = Bzip2HuffmanAllocator.first(nArray, n6 - 1, 0);
            for (int i2 = n5 - (n6 - n2); i2 > 0; --i2) {
                nArray[n3--] = n4;
            }
            n5 = n6 - n2 << 1;
            ++n4;
        }
    }

    private static void allocateNodeLengthsWithRelocation(int[] nArray, int n2, int n3) {
        int n4 = nArray.length - 2;
        int n5 = nArray.length - 1;
        int n6 = n3 == 1 ? 2 : 1;
        int n7 = n3 == 1 ? n2 - 2 : n2;
        int n8 = n6 << 1;
        while (n8 > 0) {
            int n9 = n4;
            n4 = n4 <= n2 ? n4 : Bzip2HuffmanAllocator.first(nArray, n9 - 1, n2);
            int n10 = 0;
            if (n6 >= n3) {
                n10 = Math.min(n7, 1 << n6 - n3);
            } else if (n6 == n3 - 1) {
                n10 = 1;
                if (nArray[n4] == n9) {
                    ++n4;
                }
            }
            for (int i2 = n8 - (n9 - n4 + n10); i2 > 0; --i2) {
                nArray[n5--] = n6;
            }
            n7 -= n10;
            n8 = n9 - n4 + n10 << 1;
            ++n6;
        }
    }

    static void allocateHuffmanCodeLengths(int[] nArray, int n2) {
        switch (nArray.length) {
            case 2: {
                nArray[1] = 1;
            }
            case 1: {
                nArray[0] = 1;
                return;
            }
        }
        Bzip2HuffmanAllocator.setExtendedParentPointers(nArray);
        int n3 = Bzip2HuffmanAllocator.findNodesToRelocate(nArray, n2);
        if (nArray[0] % nArray.length >= n3) {
            Bzip2HuffmanAllocator.allocateNodeLengths(nArray);
        } else {
            int n4 = n2 - (32 - Integer.numberOfLeadingZeros(n3 - 1));
            Bzip2HuffmanAllocator.allocateNodeLengthsWithRelocation(nArray, n3, n4);
        }
    }

    private Bzip2HuffmanAllocator() {
    }
}

