/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.handler.codec.compression.Bzip2DivSufSort$PartitionResult;
import io.netty.handler.codec.compression.Bzip2DivSufSort$StackEntry;
import io.netty.handler.codec.compression.Bzip2DivSufSort$TRBudget;

final class Bzip2DivSufSort {
    private static final int STACK_SIZE = 64;
    private static final int BUCKET_A_SIZE = 256;
    private static final int BUCKET_B_SIZE = 65536;
    private static final int SS_BLOCKSIZE = 1024;
    private static final int INSERTIONSORT_THRESHOLD = 8;
    private static final int[] LOG_2_TABLE = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private final int[] SA;
    private final byte[] T;
    private final int n;

    Bzip2DivSufSort(byte[] byArray, int[] nArray, int n2) {
        this.T = byArray;
        this.SA = nArray;
        this.n = n2;
    }

    private static void swapElements(int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = nArray[n2];
        nArray[n2] = nArray2[n3];
        nArray2[n3] = n4;
    }

    private int ssCompare(int n2, int n3, int n4) {
        int n5;
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n6 = nArray[n2 + 1] + 2;
        int n7 = nArray[n3 + 1] + 2;
        int n8 = n4 + nArray[n2];
        for (n5 = n4 + nArray[n3]; n8 < n6 && n5 < n7 && byArray[n8] == byArray[n5]; ++n8, ++n5) {
        }
        return n8 < n6 ? (n5 < n7 ? (byArray[n8] & 0xFF) - (byArray[n5] & 0xFF) : 1) : (n5 < n7 ? -1 : 0);
    }

    private int ssCompareLast(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n8 = n5 + nArray[n3];
        int n9 = n6;
        int n10 = nArray[n4 + 1] + 2;
        for (n7 = n5 + nArray[n4]; n8 < n9 && n7 < n10 && byArray[n8] == byArray[n7]; ++n8, ++n7) {
        }
        if (n8 < n9) {
            return n7 < n10 ? (byArray[n8] & 0xFF) - (byArray[n7] & 0xFF) : 1;
        }
        if (n7 == n10) {
            return 1;
        }
        n8 %= n6;
        n9 = nArray[n2] + 2;
        while (n8 < n9 && n7 < n10 && byArray[n8] == byArray[n7]) {
            ++n8;
            ++n7;
        }
        return n8 < n9 ? (n7 < n10 ? (byArray[n8] & 0xFF) - (byArray[n7] & 0xFF) : 1) : (n7 < n10 ? -1 : 0);
    }

    private void ssInsertionSort(int n2, int n3, int n4, int n5) {
        int[] nArray = this.SA;
        for (int i2 = n4 - 2; n3 <= i2; --i2) {
            int n6;
            int n7 = nArray[i2];
            int n8 = i2 + 1;
            while (0 < (n6 = this.ssCompare(n2 + n7, n2 + nArray[n8], n5))) {
                do {
                    nArray[n8 - 1] = nArray[n8];
                } while (++n8 < n4 && nArray[n8] < 0);
                if (n4 > n8) continue;
            }
            if (n6 == 0) {
                nArray[n8] = ~nArray[n8];
            }
            nArray[n8 - 1] = n7;
        }
    }

    private void ssFixdown(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n8 = nArray[n4 + n5];
        int n9 = byArray[n2 + nArray[n3 + n8]] & 0xFF;
        while ((n7 = 2 * n5 + 1) < n6) {
            int n10;
            int n11;
            int n12;
            if ((n12 = byArray[n2 + nArray[n3 + nArray[n4 + (n11 = n7++)]]] & 0xFF) < (n10 = byArray[n2 + nArray[n3 + nArray[n4 + n7]]] & 0xFF)) {
                n11 = n7;
                n12 = n10;
            }
            if (n12 <= n9) break;
            nArray[n4 + n5] = nArray[n4 + n11];
            n5 = n11;
        }
        nArray[n4 + n5] = n8;
    }

    private void ssHeapSort(int n2, int n3, int n4, int n5) {
        int n6;
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n7 = n5;
        if (n5 % 2 == 0 && (byArray[n2 + nArray[n3 + nArray[n4 + --n7 / 2]]] & 0xFF) < (byArray[n2 + nArray[n3 + nArray[n4 + n7]]] & 0xFF)) {
            Bzip2DivSufSort.swapElements(nArray, n4 + n7, nArray, n4 + n7 / 2);
        }
        for (n6 = n7 / 2 - 1; 0 <= n6; --n6) {
            this.ssFixdown(n2, n3, n4, n6, n7);
        }
        if (n5 % 2 == 0) {
            Bzip2DivSufSort.swapElements(nArray, n4, nArray, n4 + n7);
            this.ssFixdown(n2, n3, n4, 0, n7);
        }
        for (n6 = n7 - 1; 0 < n6; --n6) {
            int n8 = nArray[n4];
            nArray[n4] = nArray[n4 + n6];
            this.ssFixdown(n2, n3, n4, 0, n6);
            nArray[n4 + n6] = n8;
        }
    }

    private int ssMedian3(int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n7 = byArray[n2 + nArray[n3 + nArray[n4]]] & 0xFF;
        int n8 = byArray[n2 + nArray[n3 + nArray[n5]]] & 0xFF;
        int n9 = byArray[n2 + nArray[n3 + nArray[n6]]] & 0xFF;
        if (n7 > n8) {
            int n10 = n4;
            n4 = n5;
            n5 = n10;
            int n11 = n7;
            n7 = n8;
            n8 = n11;
        }
        if (n8 > n9) {
            if (n7 > n9) {
                return n4;
            }
            return n6;
        }
        return n5;
    }

    private int ssMedian5(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n11 = byArray[n2 + nArray[n3 + nArray[n4]]] & 0xFF;
        int n12 = byArray[n2 + nArray[n3 + nArray[n5]]] & 0xFF;
        int n13 = byArray[n2 + nArray[n3 + nArray[n6]]] & 0xFF;
        int n14 = byArray[n2 + nArray[n3 + nArray[n7]]] & 0xFF;
        int n15 = byArray[n2 + nArray[n3 + nArray[n8]]] & 0xFF;
        if (n12 > n13) {
            n10 = n5;
            n5 = n6;
            n6 = n10;
            n9 = n12;
            n12 = n13;
            n13 = n9;
        }
        if (n14 > n15) {
            n10 = n7;
            n7 = n8;
            n8 = n10;
            n9 = n14;
            n14 = n15;
            n15 = n9;
        }
        if (n12 > n14) {
            n7 = n10 = n5;
            n14 = n9 = n12;
            n10 = n6;
            n6 = n8;
            n8 = n10;
            n9 = n13;
            n13 = n15;
            n15 = n9;
        }
        if (n11 > n13) {
            n10 = n4;
            n4 = n6;
            n6 = n10;
            n9 = n11;
            n11 = n13;
            n13 = n9;
        }
        if (n11 > n14) {
            n7 = n10 = n4;
            n14 = n9 = n11;
            n6 = n8;
            n13 = n15;
        }
        if (n13 > n14) {
            return n7;
        }
        return n6;
    }

    private int ssPivot(int n2, int n3, int n4, int n5) {
        int n6 = n5 - n4;
        int n7 = n4 + n6 / 2;
        if (n6 <= 512) {
            if (n6 <= 32) {
                return this.ssMedian3(n2, n3, n4, n7, n5 - 1);
            }
            return this.ssMedian5(n2, n3, n4, n4 + (n6 >>= 2), n7, n5 - 1 - n6, n5 - 1);
        }
        return this.ssMedian3(n2, n3, this.ssMedian3(n2, n3, n4, n4 + (n6 >>= 3), n4 + (n6 << 1)), this.ssMedian3(n2, n3, n7 - n6, n7, n7 + n6), this.ssMedian3(n2, n3, n5 - 1 - (n6 << 1), n5 - 1 - n6, n5 - 1));
    }

    private static int ssLog(int n2) {
        return (n2 & 0xFF00) != 0 ? 8 + LOG_2_TABLE[n2 >> 8 & 0xFF] : LOG_2_TABLE[n2 & 0xFF];
    }

    private int ssSubstringPartition(int n2, int n3, int n4, int n5) {
        int[] nArray = this.SA;
        int n6 = n3 - 1;
        int n7 = n4;
        while (true) {
            if (++n6 < n7 && nArray[n2 + nArray[n6]] + n5 >= nArray[n2 + nArray[n6] + 1] + 1) {
                nArray[n6] = ~nArray[n6];
                continue;
            }
            --n7;
            while (n6 < n7 && nArray[n2 + nArray[n7]] + n5 < nArray[n2 + nArray[n7] + 1] + 1) {
                --n7;
            }
            if (n7 <= n6) break;
            int n8 = ~nArray[n7];
            nArray[n7] = nArray[n6];
            nArray[n6] = n8;
        }
        if (n3 < n6) {
            nArray[n3] = ~nArray[n3];
        }
        return n6;
    }

    private void ssMultiKeyIntroSort(int n2, int n3, int n4, int n5) {
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        Bzip2DivSufSort$StackEntry[] bzip2DivSufSort$StackEntryArray = new Bzip2DivSufSort$StackEntry[64];
        int n6 = 0;
        int n7 = 0;
        int n8 = Bzip2DivSufSort.ssLog(n4 - n3);
        while (true) {
            int n9;
            int n10;
            int n11;
            int n12;
            if (n4 - n3 <= 8) {
                if (1 < n4 - n3) {
                    this.ssInsertionSort(n2, n3, n4, n5);
                }
                if (n7 == 0) {
                    return;
                }
                Bzip2DivSufSort$StackEntry bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n7];
                n3 = bzip2DivSufSort$StackEntry.a;
                n4 = bzip2DivSufSort$StackEntry.b;
                n5 = bzip2DivSufSort$StackEntry.c;
                n8 = bzip2DivSufSort$StackEntry.d;
                continue;
            }
            int n13 = n5;
            if (n8-- == 0) {
                this.ssHeapSort(n13, n2, n3, n4 - n3);
            }
            if (n8 < 0) {
                n12 = byArray[n13 + nArray[n2 + nArray[n3]]] & 0xFF;
                for (n11 = n3 + 1; n11 < n4; ++n11) {
                    n6 = byArray[n13 + nArray[n2 + nArray[n11]]] & 0xFF;
                    if (n6 == n12) continue;
                    if (1 < n11 - n3) break;
                    n12 = n6;
                    n3 = n11;
                }
                if ((byArray[n13 + nArray[n2 + nArray[n3]] - 1] & 0xFF) < n12) {
                    n3 = this.ssSubstringPartition(n2, n3, n11, n5);
                }
                if (n11 - n3 <= n4 - n11) {
                    if (1 < n11 - n3) {
                        bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n11, n4, n5, -1);
                        n4 = n11;
                        ++n5;
                        n8 = Bzip2DivSufSort.ssLog(n11 - n3);
                        continue;
                    }
                    n3 = n11;
                    n8 = -1;
                    continue;
                }
                if (1 < n4 - n11) {
                    bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n3, n11, n5 + 1, Bzip2DivSufSort.ssLog(n11 - n3));
                    n3 = n11;
                    n8 = -1;
                    continue;
                }
                n4 = n11;
                ++n5;
                n8 = Bzip2DivSufSort.ssLog(n11 - n3);
                continue;
            }
            n11 = this.ssPivot(n13, n2, n3, n4);
            n12 = byArray[n13 + nArray[n2 + nArray[n11]]] & 0xFF;
            Bzip2DivSufSort.swapElements(nArray, n3, nArray, n11);
            for (n10 = n3 + 1; n10 < n4 && (n6 = byArray[n13 + nArray[n2 + nArray[n10]]] & 0xFF) == n12; ++n10) {
            }
            n11 = n10;
            if (n11 < n4 && n6 < n12) {
                while (++n10 < n4 && (n6 = byArray[n13 + nArray[n2 + nArray[n10]]] & 0xFF) <= n12) {
                    if (n6 != n12) continue;
                    Bzip2DivSufSort.swapElements(nArray, n10, nArray, n11);
                    ++n11;
                }
            }
            for (n9 = n4 - 1; n10 < n9 && (n6 = byArray[n13 + nArray[n2 + nArray[n9]]] & 0xFF) == n12; --n9) {
            }
            int n14 = n9;
            if (n10 < n14 && n6 > n12) {
                while (n10 < --n9 && (n6 = byArray[n13 + nArray[n2 + nArray[n9]]] & 0xFF) >= n12) {
                    if (n6 != n12) continue;
                    Bzip2DivSufSort.swapElements(nArray, n9, nArray, n14);
                    --n14;
                }
            }
            while (n10 < n9) {
                Bzip2DivSufSort.swapElements(nArray, n10, nArray, n9);
                while (++n10 < n9 && (n6 = byArray[n13 + nArray[n2 + nArray[n10]]] & 0xFF) <= n12) {
                    if (n6 != n12) continue;
                    Bzip2DivSufSort.swapElements(nArray, n10, nArray, n11);
                    ++n11;
                }
                while (n10 < --n9 && (n6 = byArray[n13 + nArray[n2 + nArray[n9]]] & 0xFF) >= n12) {
                    if (n6 != n12) continue;
                    Bzip2DivSufSort.swapElements(nArray, n9, nArray, n14);
                    --n14;
                }
            }
            if (n11 <= n14) {
                n9 = n10 - 1;
                int n15 = n11 - n3;
                int n16 = n10 - n11;
                if (n15 > n16) {
                    n15 = n16;
                }
                int n17 = n3;
                int n18 = n10 - n15;
                while (0 < n15) {
                    Bzip2DivSufSort.swapElements(nArray, n17, nArray, n18);
                    --n15;
                    ++n17;
                    ++n18;
                }
                n15 = n14 - n9;
                n16 = n4 - n14 - 1;
                if (n15 > n16) {
                    n15 = n16;
                }
                n17 = n10;
                n18 = n4 - n15;
                while (0 < n15) {
                    Bzip2DivSufSort.swapElements(nArray, n17, nArray, n18);
                    --n15;
                    ++n17;
                    ++n18;
                }
                n11 = n3 + (n10 - n11);
                n9 = n4 - (n14 - n9);
                int n19 = n10 = n12 <= (byArray[n13 + nArray[n2 + nArray[n11]] - 1] & 0xFF) ? n11 : this.ssSubstringPartition(n2, n11, n9, n5);
                if (n11 - n3 <= n4 - n9) {
                    if (n4 - n9 <= n9 - n10) {
                        bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n10, n9, n5 + 1, Bzip2DivSufSort.ssLog(n9 - n10));
                        bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n9, n4, n5, n8);
                        n4 = n11;
                        continue;
                    }
                    if (n11 - n3 <= n9 - n10) {
                        bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n9, n4, n5, n8);
                        bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n10, n9, n5 + 1, Bzip2DivSufSort.ssLog(n9 - n10));
                        n4 = n11;
                        continue;
                    }
                    bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n9, n4, n5, n8);
                    bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n3, n11, n5, n8);
                    n3 = n10;
                    n4 = n9;
                    ++n5;
                    n8 = Bzip2DivSufSort.ssLog(n9 - n10);
                    continue;
                }
                if (n11 - n3 <= n9 - n10) {
                    bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n10, n9, n5 + 1, Bzip2DivSufSort.ssLog(n9 - n10));
                    bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n3, n11, n5, n8);
                    n3 = n9;
                    continue;
                }
                if (n4 - n9 <= n9 - n10) {
                    bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n3, n11, n5, n8);
                    bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n10, n9, n5 + 1, Bzip2DivSufSort.ssLog(n9 - n10));
                    n3 = n9;
                    continue;
                }
                bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n3, n11, n5, n8);
                bzip2DivSufSort$StackEntryArray[n7++] = new Bzip2DivSufSort$StackEntry(n9, n4, n5, n8);
                n3 = n10;
                n4 = n9;
                ++n5;
                n8 = Bzip2DivSufSort.ssLog(n9 - n10);
                continue;
            }
            ++n8;
            if ((byArray[n13 + nArray[n2 + nArray[n3]] - 1] & 0xFF) < n12) {
                n3 = this.ssSubstringPartition(n2, n3, n4, n5);
                n8 = Bzip2DivSufSort.ssLog(n4 - n3);
            }
            ++n5;
        }
    }

    private static void ssBlockSwap(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        int n5 = n4;
        int n6 = n2;
        int n7 = n3;
        while (0 < n5) {
            Bzip2DivSufSort.swapElements(nArray, n6, nArray2, n7);
            --n5;
            ++n6;
            ++n7;
        }
    }

    private void ssMergeForward(int n2, int[] nArray, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray2 = this.SA;
        int n8 = n3 + (n5 - n4) - 1;
        Bzip2DivSufSort.ssBlockSwap(nArray, n3, nArray2, n4, n5 - n4);
        int n9 = nArray2[n4];
        int n10 = n4;
        int n11 = n3;
        int n12 = n5;
        while (true) {
            int n13;
            if ((n13 = this.ssCompare(n2 + nArray[n11], n2 + nArray2[n12], n7)) < 0) {
                do {
                    nArray2[n10++] = nArray[n11];
                    if (n8 <= n11) {
                        nArray[n11] = n9;
                        return;
                    }
                    nArray[n11++] = nArray2[n10];
                } while (nArray[n11] < 0);
                continue;
            }
            if (n13 > 0) {
                do {
                    nArray2[n10++] = nArray2[n12];
                    nArray2[n12++] = nArray2[n10];
                    if (n6 > n12) continue;
                    while (n11 < n8) {
                        nArray2[n10++] = nArray[n11];
                        nArray[n11++] = nArray2[n10];
                    }
                    nArray2[n10] = nArray[n11];
                    nArray[n11] = n9;
                    return;
                } while (nArray2[n12] < 0);
                continue;
            }
            nArray2[n12] = ~nArray2[n12];
            do {
                nArray2[n10++] = nArray[n11];
                if (n8 <= n11) {
                    nArray[n11] = n9;
                    return;
                }
                nArray[n11++] = nArray2[n10];
            } while (nArray[n11] < 0);
            do {
                nArray2[n10++] = nArray2[n12];
                nArray2[n12++] = nArray2[n10];
                if (n6 > n12) continue;
                while (n11 < n8) {
                    nArray2[n10++] = nArray[n11];
                    nArray[n11++] = nArray2[n10];
                }
                nArray2[n10] = nArray[n11];
                nArray[n11] = n9;
                return;
            } while (nArray2[n12] < 0);
        }
    }

    private void ssMergeBackward(int n2, int[] nArray, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int[] nArray2 = this.SA;
        int n10 = n3 + (n6 - n5);
        Bzip2DivSufSort.ssBlockSwap(nArray, n3, nArray2, n5, n6 - n5);
        int n11 = 0;
        if (nArray[n10 - 1] < 0) {
            n11 |= 1;
            n9 = n2 + ~nArray[n10 - 1];
        } else {
            n9 = n2 + nArray[n10 - 1];
        }
        if (nArray2[n5 - 1] < 0) {
            n11 |= 2;
            n8 = n2 + ~nArray2[n5 - 1];
        } else {
            n8 = n2 + nArray2[n5 - 1];
        }
        int n12 = nArray2[n6 - 1];
        int n13 = n6 - 1;
        int n14 = n10 - 1;
        int n15 = n5 - 1;
        while (true) {
            int n16;
            if ((n16 = this.ssCompare(n9, n8, n7)) > 0) {
                if ((n11 & 1) != 0) {
                    do {
                        nArray2[n13--] = nArray[n14];
                        nArray[n14--] = nArray2[n13];
                    } while (nArray[n14] < 0);
                    n11 ^= 1;
                }
                nArray2[n13--] = nArray[n14];
                if (n14 <= n3) {
                    nArray[n14] = n12;
                    return;
                }
                nArray[n14--] = nArray2[n13];
                if (nArray[n14] < 0) {
                    n11 |= 1;
                    n9 = n2 + ~nArray[n14];
                    continue;
                }
                n9 = n2 + nArray[n14];
                continue;
            }
            if (n16 < 0) {
                if ((n11 & 2) != 0) {
                    do {
                        nArray2[n13--] = nArray2[n15];
                        nArray2[n15--] = nArray2[n13];
                    } while (nArray2[n15] < 0);
                    n11 ^= 2;
                }
                nArray2[n13--] = nArray2[n15];
                nArray2[n15--] = nArray2[n13];
                if (n15 < n4) {
                    while (n3 < n14) {
                        nArray2[n13--] = nArray[n14];
                        nArray[n14--] = nArray2[n13];
                    }
                    nArray2[n13] = nArray[n14];
                    nArray[n14] = n12;
                    return;
                }
                if (nArray2[n15] < 0) {
                    n11 |= 2;
                    n8 = n2 + ~nArray2[n15];
                    continue;
                }
                n8 = n2 + nArray2[n15];
                continue;
            }
            if ((n11 & 1) != 0) {
                do {
                    nArray2[n13--] = nArray[n14];
                    nArray[n14--] = nArray2[n13];
                } while (nArray[n14] < 0);
                n11 ^= 1;
            }
            nArray2[n13--] = ~nArray[n14];
            if (n14 <= n3) {
                nArray[n14] = n12;
                return;
            }
            nArray[n14--] = nArray2[n13];
            if ((n11 & 2) != 0) {
                do {
                    nArray2[n13--] = nArray2[n15];
                    nArray2[n15--] = nArray2[n13];
                } while (nArray2[n15] < 0);
                n11 ^= 2;
            }
            nArray2[n13--] = nArray2[n15];
            nArray2[n15--] = nArray2[n13];
            if (n15 < n4) {
                while (n3 < n14) {
                    nArray2[n13--] = nArray[n14];
                    nArray[n14--] = nArray2[n13];
                }
                nArray2[n13] = nArray[n14];
                nArray[n14] = n12;
                return;
            }
            if (nArray[n14] < 0) {
                n11 |= 1;
                n9 = n2 + ~nArray[n14];
            } else {
                n9 = n2 + nArray[n14];
            }
            if (nArray2[n15] < 0) {
                n11 |= 2;
                n8 = n2 + ~nArray2[n15];
                continue;
            }
            n8 = n2 + nArray2[n15];
        }
    }

    private static int getIDX(int n2) {
        return 0 <= n2 ? n2 : ~n2;
    }

    private void ssMergeCheckEqual(int n2, int n3, int n4) {
        int[] nArray = this.SA;
        if (0 <= nArray[n4] && this.ssCompare(n2 + Bzip2DivSufSort.getIDX(nArray[n4 - 1]), n2 + nArray[n4], n3) == 0) {
            nArray[n4] = ~nArray[n4];
        }
    }

    private void ssMerge(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7, int n8) {
        int[] nArray2 = this.SA;
        Bzip2DivSufSort$StackEntry[] bzip2DivSufSort$StackEntryArray = new Bzip2DivSufSort$StackEntry[64];
        int n9 = 0;
        int n10 = 0;
        while (true) {
            Bzip2DivSufSort$StackEntry bzip2DivSufSort$StackEntry;
            if (n5 - n4 <= n7) {
                if (n3 < n4 && n4 < n5) {
                    this.ssMergeBackward(n2, nArray, n6, n3, n4, n5, n8);
                }
                if (n9 & true) {
                    this.ssMergeCheckEqual(n2, n8, n3);
                }
                if ((n9 & 2) != 0) {
                    this.ssMergeCheckEqual(n2, n8, n5);
                }
                if (n10 == 0) {
                    return;
                }
                bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n10];
                n3 = bzip2DivSufSort$StackEntry.a;
                n4 = bzip2DivSufSort$StackEntry.b;
                n5 = bzip2DivSufSort$StackEntry.c;
                n9 = bzip2DivSufSort$StackEntry.d;
                continue;
            }
            if (n4 - n3 <= n7) {
                if (n3 < n4) {
                    this.ssMergeForward(n2, nArray, n6, n3, n4, n5, n8);
                }
                if ((n9 & 1) != 0) {
                    this.ssMergeCheckEqual(n2, n8, n3);
                }
                if ((n9 & 2) != 0) {
                    this.ssMergeCheckEqual(n2, n8, n5);
                }
                if (n10 == 0) {
                    return;
                }
                bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n10];
                n3 = bzip2DivSufSort$StackEntry.a;
                n4 = bzip2DivSufSort$StackEntry.b;
                n5 = bzip2DivSufSort$StackEntry.c;
                n9 = bzip2DivSufSort$StackEntry.d;
                continue;
            }
            int n11 = 0;
            int n12 = Math.min(n4 - n3, n5 - n4);
            int n13 = n12 >> 1;
            while (0 < n12) {
                if (this.ssCompare(n2 + Bzip2DivSufSort.getIDX(nArray2[n4 + n11 + n13]), n2 + Bzip2DivSufSort.getIDX(nArray2[n4 - n11 - n13 - 1]), n8) < 0) {
                    n11 += n13 + 1;
                    n13 -= n12 & 1 ^ 1;
                }
                n12 = n13;
                n13 >>= 1;
            }
            if (0 < n11) {
                int n14;
                Bzip2DivSufSort.ssBlockSwap(nArray2, n4 - n11, nArray2, n4, n11);
                int n15 = n14 = n4;
                int n16 = 0;
                if (n4 + n11 < n5) {
                    if (nArray2[n4 + n11] < 0) {
                        while (nArray2[n15 - 1] < 0) {
                            --n15;
                        }
                        nArray2[n4 + n11] = ~nArray2[n4 + n11];
                    }
                    n14 = n4;
                    while (nArray2[n14] < 0) {
                        ++n14;
                    }
                    n16 = 1;
                }
                if (n15 - n3 <= n5 - n14) {
                    bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n14, n4 + n11, n5, n9 & 2 | n16 & 1);
                    n4 -= n11;
                    n5 = n15;
                    n9 &= 1;
                    continue;
                }
                if (n15 == n4 && n4 == n14) {
                    n16 <<= 1;
                }
                bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n4 - n11, n15, n9 & 1 | n16 & 2);
                n3 = n14;
                n4 += n11;
                n9 = n9 & 2 | n16 & 1;
                continue;
            }
            if ((n9 & 1) != 0) {
                this.ssMergeCheckEqual(n2, n8, n3);
            }
            this.ssMergeCheckEqual(n2, n8, n4);
            if ((n9 & 2) != 0) {
                this.ssMergeCheckEqual(n2, n8, n5);
            }
            if (n10 == 0) {
                return;
            }
            bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n10];
            n3 = bzip2DivSufSort$StackEntry.a;
            n4 = bzip2DivSufSort$StackEntry.b;
            n5 = bzip2DivSufSort$StackEntry.c;
            n9 = bzip2DivSufSort$StackEntry.d;
        }
    }

    private void subStringSort(int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7, boolean bl2, int n8) {
        int n9;
        int[] nArray2 = this.SA;
        if (bl2) {
            ++n3;
        }
        int n10 = n3;
        int n11 = 0;
        while (n10 + 1024 < n4) {
            this.ssMultiKeyIntroSort(n2, n10, n10 + 1024, n7);
            int[] nArray3 = nArray2;
            int n12 = n10 + 1024;
            int n13 = n4 - (n10 + 1024);
            if (n13 <= n6) {
                n13 = n6;
                nArray3 = nArray;
                n12 = n5;
            }
            int n14 = n10;
            n9 = 1024;
            int n15 = n11;
            while ((n15 & 1) != 0) {
                this.ssMerge(n2, n14 - n9, n14, n14 + n9, nArray3, n12, n13, n7);
                n14 -= n9;
                n9 <<= 1;
                n15 >>>= 1;
            }
            n10 += 1024;
            ++n11;
        }
        this.ssMultiKeyIntroSort(n2, n10, n4, n7);
        n9 = 1024;
        while (n11 != 0) {
            if (n11 & true) {
                this.ssMerge(n2, n10 - n9, n10, n4, nArray, n5, n6, n7);
                n10 -= n9;
            }
            n9 <<= 1;
            n11 >>= 1;
        }
        if (bl2) {
            n11 = nArray2[n3 - 1];
            int n16 = 1;
            for (n10 = n3; n10 < n4 && (nArray2[n10] < 0 || 0 < (n16 = this.ssCompareLast(n2, n2 + n11, n2 + nArray2[n10], n7, n8))); ++n10) {
                nArray2[n10 - 1] = nArray2[n10];
            }
            if (n16 == 0) {
                nArray2[n10] = ~nArray2[n10];
            }
            nArray2[n10 - 1] = n11;
        }
    }

    private int trGetC(int n2, int n3, int n4, int n5) {
        return n3 + n5 < n4 ? this.SA[n3 + n5] : this.SA[n2 + (n3 - n2 + n5) % (n4 - n2)];
    }

    private void trFixdown(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int[] nArray = this.SA;
        int n9 = nArray[n5 + n6];
        int n10 = this.trGetC(n2, n3, n4, n9);
        while ((n8 = 2 * n6 + 1) < n7) {
            int n11;
            int n12;
            int n13;
            if ((n13 = this.trGetC(n2, n3, n4, nArray[n5 + (n12 = n8++)])) < (n11 = this.trGetC(n2, n3, n4, nArray[n5 + n8]))) {
                n12 = n8;
                n13 = n11;
            }
            if (n13 <= n10) break;
            nArray[n5 + n6] = nArray[n5 + n12];
            n6 = n12;
        }
        nArray[n5 + n6] = n9;
    }

    private void trHeapSort(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int[] nArray = this.SA;
        int n8 = n6;
        if (n6 % 2 == 0 && this.trGetC(n2, n3, n4, nArray[n5 + --n8 / 2]) < this.trGetC(n2, n3, n4, nArray[n5 + n8])) {
            Bzip2DivSufSort.swapElements(nArray, n5 + n8, nArray, n5 + n8 / 2);
        }
        for (n7 = n8 / 2 - 1; 0 <= n7; --n7) {
            this.trFixdown(n2, n3, n4, n5, n7, n8);
        }
        if (n6 % 2 == 0) {
            Bzip2DivSufSort.swapElements(nArray, n5, nArray, n5 + n8);
            this.trFixdown(n2, n3, n4, n5, 0, n8);
        }
        for (n7 = n8 - 1; 0 < n7; --n7) {
            int n9 = nArray[n5];
            nArray[n5] = nArray[n5 + n7];
            this.trFixdown(n2, n3, n4, n5, 0, n7);
            nArray[n5 + n7] = n9;
        }
    }

    private void trInsertionSort(int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = this.SA;
        for (int i2 = n5 + 1; i2 < n6; ++i2) {
            int n7;
            int n8 = nArray[i2];
            int n9 = i2 - 1;
            while (0 > (n7 = this.trGetC(n2, n3, n4, n8) - this.trGetC(n2, n3, n4, nArray[n9]))) {
                do {
                    nArray[n9 + 1] = nArray[n9];
                } while (n5 <= --n9 && nArray[n9] < 0);
                if (n9 >= n5) continue;
            }
            if (n7 == 0) {
                nArray[n9] = ~nArray[n9];
            }
            nArray[n9 + 1] = n8;
        }
    }

    private static int trLog(int n2) {
        return (n2 & 0xFFFF0000) != 0 ? ((n2 & 0xFF000000) != 0 ? 24 + LOG_2_TABLE[n2 >> 24 & 0xFF] : LOG_2_TABLE[n2 >> 16 & 0x10F]) : ((n2 & 0xFF00) != 0 ? 8 + LOG_2_TABLE[n2 >> 8 & 0xFF] : LOG_2_TABLE[n2 & 0xFF]);
    }

    private int trMedian3(int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray = this.SA;
        int n8 = this.trGetC(n2, n3, n4, nArray[n5]);
        int n9 = this.trGetC(n2, n3, n4, nArray[n6]);
        int n10 = this.trGetC(n2, n3, n4, nArray[n7]);
        if (n8 > n9) {
            int n11 = n5;
            n5 = n6;
            n6 = n11;
            int n12 = n8;
            n8 = n9;
            n9 = n12;
        }
        if (n9 > n10) {
            if (n8 > n10) {
                return n5;
            }
            return n7;
        }
        return n6;
    }

    private int trMedian5(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        int n11;
        int[] nArray = this.SA;
        int n12 = this.trGetC(n2, n3, n4, nArray[n5]);
        int n13 = this.trGetC(n2, n3, n4, nArray[n6]);
        int n14 = this.trGetC(n2, n3, n4, nArray[n7]);
        int n15 = this.trGetC(n2, n3, n4, nArray[n8]);
        int n16 = this.trGetC(n2, n3, n4, nArray[n9]);
        if (n13 > n14) {
            n11 = n6;
            n6 = n7;
            n7 = n11;
            n10 = n13;
            n13 = n14;
            n14 = n10;
        }
        if (n15 > n16) {
            n11 = n8;
            n8 = n9;
            n9 = n11;
            n10 = n15;
            n15 = n16;
            n16 = n10;
        }
        if (n13 > n15) {
            n8 = n11 = n6;
            n15 = n10 = n13;
            n11 = n7;
            n7 = n9;
            n9 = n11;
            n10 = n14;
            n14 = n16;
            n16 = n10;
        }
        if (n12 > n14) {
            n11 = n5;
            n5 = n7;
            n7 = n11;
            n10 = n12;
            n12 = n14;
            n14 = n10;
        }
        if (n12 > n15) {
            n8 = n11 = n5;
            n15 = n10 = n12;
            n7 = n9;
            n14 = n16;
        }
        if (n14 > n15) {
            return n8;
        }
        return n7;
    }

    private int trPivot(int n2, int n3, int n4, int n5, int n6) {
        int n7 = n6 - n5;
        int n8 = n5 + n7 / 2;
        if (n7 <= 512) {
            if (n7 <= 32) {
                return this.trMedian3(n2, n3, n4, n5, n8, n6 - 1);
            }
            return this.trMedian5(n2, n3, n4, n5, n5 + (n7 >>= 2), n8, n6 - 1 - n7, n6 - 1);
        }
        return this.trMedian3(n2, n3, n4, this.trMedian3(n2, n3, n4, n5, n5 + (n7 >>= 3), n5 + (n7 << 1)), this.trMedian3(n2, n3, n4, n8 - n7, n8, n8 + n7), this.trMedian3(n2, n3, n4, n6 - 1 - (n7 << 1), n6 - 1 - n7, n6 - 1));
    }

    private void lsUpdateGroup(int n2, int n3, int n4) {
        int[] nArray = this.SA;
        for (int i2 = n3; i2 < n4; ++i2) {
            int n5;
            if (0 <= nArray[i2]) {
                n5 = i2;
                do {
                    nArray[n2 + nArray[i2]] = i2;
                } while (++i2 < n4 && 0 <= nArray[i2]);
                nArray[n5] = n5 - i2;
                if (n4 <= i2) break;
            }
            n5 = i2;
            do {
                nArray[i2] = ~nArray[i2];
            } while (nArray[++i2] < 0);
            int n6 = i2;
            do {
                nArray[n2 + nArray[n5]] = n6;
            } while (++n5 <= i2);
        }
    }

    private void lsIntroSort(int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = this.SA;
        Bzip2DivSufSort$StackEntry[] bzip2DivSufSort$StackEntryArray = new Bzip2DivSufSort$StackEntry[64];
        int n7 = 0;
        int n8 = 0;
        int n9 = Bzip2DivSufSort.trLog(n6 - n5);
        while (true) {
            int n10;
            int n11;
            int n12;
            Bzip2DivSufSort$StackEntry bzip2DivSufSort$StackEntry;
            if (n6 - n5 <= 8) {
                if (1 < n6 - n5) {
                    this.trInsertionSort(n2, n3, n4, n5, n6);
                    this.lsUpdateGroup(n2, n5, n6);
                } else if (n6 - n5 == 1) {
                    nArray[n5] = -1;
                }
                if (n8 == 0) {
                    return;
                }
                bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n8];
                n5 = bzip2DivSufSort$StackEntry.a;
                n6 = bzip2DivSufSort$StackEntry.b;
                n9 = bzip2DivSufSort$StackEntry.c;
                continue;
            }
            if (n9-- == 0) {
                this.trHeapSort(n2, n3, n4, n5, n6 - n5);
                n12 = n6 - 1;
                while (n5 < n12) {
                    n7 = this.trGetC(n2, n3, n4, nArray[n12]);
                    for (n11 = n12 - 1; n5 <= n11 && this.trGetC(n2, n3, n4, nArray[n11]) == n7; --n11) {
                        nArray[n11] = ~nArray[n11];
                    }
                    n12 = n11;
                }
                this.lsUpdateGroup(n2, n5, n6);
                if (n8 == 0) {
                    return;
                }
                bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n8];
                n5 = bzip2DivSufSort$StackEntry.a;
                n6 = bzip2DivSufSort$StackEntry.b;
                n9 = bzip2DivSufSort$StackEntry.c;
                continue;
            }
            n12 = this.trPivot(n2, n3, n4, n5, n6);
            Bzip2DivSufSort.swapElements(nArray, n5, nArray, n12);
            int n13 = this.trGetC(n2, n3, n4, nArray[n5]);
            for (n11 = n5 + 1; n11 < n6 && (n7 = this.trGetC(n2, n3, n4, nArray[n11])) == n13; ++n11) {
            }
            n12 = n11;
            if (n12 < n6 && n7 < n13) {
                while (++n11 < n6 && (n7 = this.trGetC(n2, n3, n4, nArray[n11])) <= n13) {
                    if (n7 != n13) continue;
                    Bzip2DivSufSort.swapElements(nArray, n11, nArray, n12);
                    ++n12;
                }
            }
            for (n10 = n6 - 1; n11 < n10 && (n7 = this.trGetC(n2, n3, n4, nArray[n10])) == n13; --n10) {
            }
            int n14 = n10;
            if (n11 < n14 && n7 > n13) {
                while (n11 < --n10 && (n7 = this.trGetC(n2, n3, n4, nArray[n10])) >= n13) {
                    if (n7 != n13) continue;
                    Bzip2DivSufSort.swapElements(nArray, n10, nArray, n14);
                    --n14;
                }
            }
            while (n11 < n10) {
                Bzip2DivSufSort.swapElements(nArray, n11, nArray, n10);
                while (++n11 < n10 && (n7 = this.trGetC(n2, n3, n4, nArray[n11])) <= n13) {
                    if (n7 != n13) continue;
                    Bzip2DivSufSort.swapElements(nArray, n11, nArray, n12);
                    ++n12;
                }
                while (n11 < --n10 && (n7 = this.trGetC(n2, n3, n4, nArray[n10])) >= n13) {
                    if (n7 != n13) continue;
                    Bzip2DivSufSort.swapElements(nArray, n10, nArray, n14);
                    --n14;
                }
            }
            if (n12 <= n14) {
                n10 = n11 - 1;
                int n15 = n12 - n5;
                int n16 = n11 - n12;
                if (n15 > n16) {
                    n15 = n16;
                }
                int n17 = n5;
                int n18 = n11 - n15;
                while (0 < n15) {
                    Bzip2DivSufSort.swapElements(nArray, n17, nArray, n18);
                    --n15;
                    ++n17;
                    ++n18;
                }
                n15 = n14 - n10;
                n16 = n6 - n14 - 1;
                if (n15 > n16) {
                    n15 = n16;
                }
                n17 = n11;
                n18 = n6 - n15;
                while (0 < n15) {
                    Bzip2DivSufSort.swapElements(nArray, n17, nArray, n18);
                    --n15;
                    ++n17;
                    ++n18;
                }
                n12 = n5 + (n11 - n12);
                n11 = n6 - (n14 - n10);
                n13 = n12 - 1;
                for (n10 = n5; n10 < n12; ++n10) {
                    nArray[n2 + nArray[n10]] = n13;
                }
                if (n11 < n6) {
                    n13 = n11 - 1;
                    for (n10 = n12; n10 < n11; ++n10) {
                        nArray[n2 + nArray[n10]] = n13;
                    }
                }
                if (n11 - n12 == 1) {
                    nArray[n12] = -1;
                }
                if (n12 - n5 <= n6 - n11) {
                    if (n5 < n12) {
                        bzip2DivSufSort$StackEntryArray[n8++] = new Bzip2DivSufSort$StackEntry(n11, n6, n9, 0);
                        n6 = n12;
                        continue;
                    }
                    n5 = n11;
                    continue;
                }
                if (n11 < n6) {
                    bzip2DivSufSort$StackEntryArray[n8++] = new Bzip2DivSufSort$StackEntry(n5, n12, n9, 0);
                    n5 = n11;
                    continue;
                }
                n6 = n12;
                continue;
            }
            if (n8 == 0) {
                return;
            }
            bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n8];
            n5 = bzip2DivSufSort$StackEntry.a;
            n6 = bzip2DivSufSort$StackEntry.b;
            n9 = bzip2DivSufSort$StackEntry.c;
        }
    }

    private void lsSort(int n2, int n3, int n4) {
        int[] nArray = this.SA;
        int n5 = n2 + n4;
        while (-n3 < nArray[0]) {
            int n6;
            int n7;
            int n8 = 0;
            int n9 = 0;
            do {
                if ((n7 = nArray[n8]) < 0) {
                    n8 -= n7;
                    n9 += n7;
                    continue;
                }
                if (n9 != 0) {
                    nArray[n8 + n9] = n9;
                    n9 = 0;
                }
                n6 = nArray[n2 + n7] + 1;
                this.lsIntroSort(n2, n5, n2 + n3, n8, n6);
                n8 = n6;
            } while (n8 < n3);
            if (n9 != 0) {
                nArray[n8 + n9] = n9;
            }
            if (n3 < n5 - n2) {
                n8 = 0;
                do {
                    if ((n7 = nArray[n8]) < 0) {
                        n8 -= n7;
                        continue;
                    }
                    n6 = nArray[n2 + n7] + 1;
                    for (int i2 = n8; i2 < n6; ++i2) {
                        nArray[n2 + nArray[i2]] = i2;
                    }
                    n8 = n6;
                } while (n8 < n3);
                break;
            }
            n5 += n5 - n2;
        }
    }

    private Bzip2DivSufSort$PartitionResult trPartition(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int[] nArray = this.SA;
        int n10 = 0;
        for (n9 = n5; n9 < n6 && (n10 = this.trGetC(n2, n3, n4, nArray[n9])) == n7; ++n9) {
        }
        int n11 = n9;
        if (n11 < n6 && n10 < n7) {
            while (++n9 < n6 && (n10 = this.trGetC(n2, n3, n4, nArray[n9])) <= n7) {
                if (n10 != n7) continue;
                Bzip2DivSufSort.swapElements(nArray, n9, nArray, n11);
                ++n11;
            }
        }
        for (n8 = n6 - 1; n9 < n8 && (n10 = this.trGetC(n2, n3, n4, nArray[n8])) == n7; --n8) {
        }
        int n12 = n8;
        if (n9 < n12 && n10 > n7) {
            while (n9 < --n8 && (n10 = this.trGetC(n2, n3, n4, nArray[n8])) >= n7) {
                if (n10 != n7) continue;
                Bzip2DivSufSort.swapElements(nArray, n8, nArray, n12);
                --n12;
            }
        }
        while (n9 < n8) {
            Bzip2DivSufSort.swapElements(nArray, n9, nArray, n8);
            while (++n9 < n8 && (n10 = this.trGetC(n2, n3, n4, nArray[n9])) <= n7) {
                if (n10 != n7) continue;
                Bzip2DivSufSort.swapElements(nArray, n9, nArray, n11);
                ++n11;
            }
            while (n9 < --n8 && (n10 = this.trGetC(n2, n3, n4, nArray[n8])) >= n7) {
                if (n10 != n7) continue;
                Bzip2DivSufSort.swapElements(nArray, n8, nArray, n12);
                --n12;
            }
        }
        if (n11 <= n12) {
            n8 = n9 - 1;
            int n13 = n11 - n5;
            int n14 = n9 - n11;
            if (n13 > n14) {
                n13 = n14;
            }
            int n15 = n5;
            int n16 = n9 - n13;
            while (0 < n13) {
                Bzip2DivSufSort.swapElements(nArray, n15, nArray, n16);
                --n13;
                ++n15;
                ++n16;
            }
            n13 = n12 - n8;
            n14 = n6 - n12 - 1;
            if (n13 > n14) {
                n13 = n14;
            }
            n15 = n9;
            n16 = n6 - n13;
            while (0 < n13) {
                Bzip2DivSufSort.swapElements(nArray, n15, nArray, n16);
                --n13;
                ++n15;
                ++n16;
            }
            n5 += n9 - n11;
            n6 -= n12 - n8;
        }
        return new Bzip2DivSufSort$PartitionResult(n5, n6);
    }

    private void trCopy(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int[] nArray = this.SA;
        int n11 = n6 - 1;
        int n12 = n5 - 1;
        for (n10 = n4; n10 <= n12; ++n10) {
            n9 = nArray[n10] - n8;
            if (n9 < 0) {
                n9 += n3 - n2;
            }
            if (nArray[n2 + n9] != n11) continue;
            nArray[++n12] = n9;
            nArray[n2 + n9] = n12;
        }
        n10 = n7 - 1;
        int n13 = n12 + 1;
        n12 = n6;
        while (n13 < n12) {
            n9 = nArray[n10] - n8;
            if (n9 < 0) {
                n9 += n3 - n2;
            }
            if (nArray[n2 + n9] == n11) {
                nArray[--n12] = n9;
                nArray[n2 + n9] = n12;
            }
            --n10;
        }
    }

    private void trIntroSort(int n2, int n3, int n4, int n5, int n6, Bzip2DivSufSort$TRBudget bzip2DivSufSort$TRBudget, int n7) {
        int n8;
        int[] nArray = this.SA;
        Bzip2DivSufSort$StackEntry[] bzip2DivSufSort$StackEntryArray = new Bzip2DivSufSort$StackEntry[64];
        int n9 = 0;
        int n10 = 0;
        int n11 = Bzip2DivSufSort.trLog(n6 - n5);
        while (true) {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            Object object;
            if (n11 < 0) {
                if (n11 == -1) {
                    Bzip2DivSufSort$StackEntry bzip2DivSufSort$StackEntry;
                    if (!bzip2DivSufSort$TRBudget.update(n7, n6 - n5)) break;
                    object = this.trPartition(n2, n3 - 1, n4, n5, n6, n6 - 1);
                    n16 = ((Bzip2DivSufSort$PartitionResult)object).first;
                    n15 = ((Bzip2DivSufSort$PartitionResult)object).last;
                    if (n5 < n16 || n15 < n6) {
                        if (n16 < n6) {
                            n14 = n16 - 1;
                            for (n13 = n5; n13 < n16; ++n13) {
                                nArray[n2 + nArray[n13]] = n14;
                            }
                        }
                        if (n15 < n6) {
                            n14 = n15 - 1;
                            for (n13 = n16; n13 < n15; ++n13) {
                                nArray[n2 + nArray[n13]] = n14;
                            }
                        }
                        bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(0, n16, n15, 0);
                        bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3 - 1, n5, n6, -2);
                        if (n16 - n5 <= n6 - n15) {
                            if (1 < n16 - n5) {
                                bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n15, n6, Bzip2DivSufSort.trLog(n6 - n15));
                                n6 = n16;
                                n11 = Bzip2DivSufSort.trLog(n16 - n5);
                                continue;
                            }
                            if (1 < n6 - n15) {
                                n5 = n15;
                                n11 = Bzip2DivSufSort.trLog(n6 - n15);
                                continue;
                            }
                            if (n10 == 0) {
                                return;
                            }
                            bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n10];
                            n3 = bzip2DivSufSort$StackEntry.a;
                            n5 = bzip2DivSufSort$StackEntry.b;
                            n6 = bzip2DivSufSort$StackEntry.c;
                            n11 = bzip2DivSufSort$StackEntry.d;
                            continue;
                        }
                        if (1 < n6 - n15) {
                            bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n5, n16, Bzip2DivSufSort.trLog(n16 - n5));
                            n5 = n15;
                            n11 = Bzip2DivSufSort.trLog(n6 - n15);
                            continue;
                        }
                        if (1 < n16 - n5) {
                            n6 = n16;
                            n11 = Bzip2DivSufSort.trLog(n16 - n5);
                            continue;
                        }
                        if (n10 == 0) {
                            return;
                        }
                        bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n10];
                        n3 = bzip2DivSufSort$StackEntry.a;
                        n5 = bzip2DivSufSort$StackEntry.b;
                        n6 = bzip2DivSufSort$StackEntry.c;
                        n11 = bzip2DivSufSort$StackEntry.d;
                        continue;
                    }
                    for (n13 = n5; n13 < n6; ++n13) {
                        nArray[n2 + nArray[n13]] = n13;
                    }
                    if (n10 == 0) {
                        return;
                    }
                    bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n10];
                    n3 = bzip2DivSufSort$StackEntry.a;
                    n5 = bzip2DivSufSort$StackEntry.b;
                    n6 = bzip2DivSufSort$StackEntry.c;
                    n11 = bzip2DivSufSort$StackEntry.d;
                    continue;
                }
                if (n11 == -2) {
                    n16 = bzip2DivSufSort$StackEntryArray[--n10].b;
                    n15 = bzip2DivSufSort$StackEntryArray[n10].c;
                    this.trCopy(n2, n4, n5, n16, n15, n6, n3 - n2);
                    if (n10 == 0) {
                        return;
                    }
                    object = bzip2DivSufSort$StackEntryArray[--n10];
                    n3 = ((Bzip2DivSufSort$StackEntry)object).a;
                    n5 = ((Bzip2DivSufSort$StackEntry)object).b;
                    n6 = ((Bzip2DivSufSort$StackEntry)object).c;
                    n11 = ((Bzip2DivSufSort$StackEntry)object).d;
                    continue;
                }
                if (0 <= nArray[n5]) {
                    n16 = n5;
                    do {
                        nArray[n2 + nArray[n16]] = n16;
                    } while (++n16 < n6 && 0 <= nArray[n16]);
                    n5 = n16;
                }
                if (n5 < n6) {
                    n16 = n5;
                    do {
                        nArray[n16] = ~nArray[n16];
                    } while (nArray[++n16] < 0);
                    int n17 = n12 = nArray[n2 + nArray[n16]] != nArray[n3 + nArray[n16]] ? Bzip2DivSufSort.trLog(n16 - n5 + 1) : -1;
                    if (++n16 < n6) {
                        n14 = n16 - 1;
                        for (n15 = n5; n15 < n16; ++n15) {
                            nArray[n2 + nArray[n15]] = n14;
                        }
                    }
                    if (n16 - n5 <= n6 - n16) {
                        bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n16, n6, -3);
                        ++n3;
                        n6 = n16;
                        n11 = n12;
                        continue;
                    }
                    if (1 < n6 - n16) {
                        bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3 + 1, n5, n16, n12);
                        n5 = n16;
                        n11 = -3;
                        continue;
                    }
                    ++n3;
                    n6 = n16;
                    n11 = n12;
                    continue;
                }
                if (n10 == 0) {
                    return;
                }
                object = bzip2DivSufSort$StackEntryArray[--n10];
                n3 = ((Bzip2DivSufSort$StackEntry)object).a;
                n5 = ((Bzip2DivSufSort$StackEntry)object).b;
                n6 = ((Bzip2DivSufSort$StackEntry)object).c;
                n11 = ((Bzip2DivSufSort$StackEntry)object).d;
                continue;
            }
            if (n6 - n5 <= 8) {
                if (!bzip2DivSufSort$TRBudget.update(n7, n6 - n5)) break;
                this.trInsertionSort(n2, n3, n4, n5, n6);
                n11 = -3;
                continue;
            }
            if (n11-- == 0) {
                if (!bzip2DivSufSort$TRBudget.update(n7, n6 - n5)) break;
                this.trHeapSort(n2, n3, n4, n5, n6 - n5);
                n16 = n6 - 1;
                while (n5 < n16) {
                    n9 = this.trGetC(n2, n3, n4, nArray[n16]);
                    for (n15 = n16 - 1; n5 <= n15 && this.trGetC(n2, n3, n4, nArray[n15]) == n9; --n15) {
                        nArray[n15] = ~nArray[n15];
                    }
                    n16 = n15;
                }
                n11 = -3;
                continue;
            }
            n16 = this.trPivot(n2, n3, n4, n5, n6);
            Bzip2DivSufSort.swapElements(nArray, n5, nArray, n16);
            n14 = this.trGetC(n2, n3, n4, nArray[n5]);
            for (n15 = n5 + 1; n15 < n6 && (n9 = this.trGetC(n2, n3, n4, nArray[n15])) == n14; ++n15) {
            }
            n16 = n15;
            if (n16 < n6 && n9 < n14) {
                while (++n15 < n6 && (n9 = this.trGetC(n2, n3, n4, nArray[n15])) <= n14) {
                    if (n9 != n14) continue;
                    Bzip2DivSufSort.swapElements(nArray, n15, nArray, n16);
                    ++n16;
                }
            }
            for (n13 = n6 - 1; n15 < n13 && (n9 = this.trGetC(n2, n3, n4, nArray[n13])) == n14; --n13) {
            }
            int n18 = n13;
            if (n15 < n18 && n9 > n14) {
                while (n15 < --n13 && (n9 = this.trGetC(n2, n3, n4, nArray[n13])) >= n14) {
                    if (n9 != n14) continue;
                    Bzip2DivSufSort.swapElements(nArray, n13, nArray, n18);
                    --n18;
                }
            }
            while (n15 < n13) {
                Bzip2DivSufSort.swapElements(nArray, n15, nArray, n13);
                while (++n15 < n13 && (n9 = this.trGetC(n2, n3, n4, nArray[n15])) <= n14) {
                    if (n9 != n14) continue;
                    Bzip2DivSufSort.swapElements(nArray, n15, nArray, n16);
                    ++n16;
                }
                while (n15 < --n13 && (n9 = this.trGetC(n2, n3, n4, nArray[n13])) >= n14) {
                    if (n9 != n14) continue;
                    Bzip2DivSufSort.swapElements(nArray, n13, nArray, n18);
                    --n18;
                }
            }
            if (n16 <= n18) {
                n13 = n15 - 1;
                n8 = n16 - n5;
                int n19 = n15 - n16;
                if (n8 > n19) {
                    n8 = n19;
                }
                int n20 = n5;
                int n21 = n15 - n8;
                while (0 < n8) {
                    Bzip2DivSufSort.swapElements(nArray, n20, nArray, n21);
                    --n8;
                    ++n20;
                    ++n21;
                }
                n8 = n18 - n13;
                n19 = n6 - n18 - 1;
                if (n8 > n19) {
                    n8 = n19;
                }
                n20 = n15;
                n21 = n6 - n8;
                while (0 < n8) {
                    Bzip2DivSufSort.swapElements(nArray, n20, nArray, n21);
                    --n8;
                    ++n20;
                    ++n21;
                }
                n16 = n5 + (n15 - n16);
                n15 = n6 - (n18 - n13);
                n12 = nArray[n2 + nArray[n16]] != n14 ? Bzip2DivSufSort.trLog(n15 - n16) : -1;
                n14 = n16 - 1;
                for (n13 = n5; n13 < n16; ++n13) {
                    nArray[n2 + nArray[n13]] = n14;
                }
                if (n15 < n6) {
                    n14 = n15 - 1;
                    for (n13 = n16; n13 < n15; ++n13) {
                        nArray[n2 + nArray[n13]] = n14;
                    }
                }
                if (n16 - n5 <= n6 - n15) {
                    if (n6 - n15 <= n15 - n16) {
                        if (1 < n16 - n5) {
                            bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3 + 1, n16, n15, n12);
                            bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n15, n6, n11);
                            n6 = n16;
                            continue;
                        }
                        if (1 < n6 - n15) {
                            bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3 + 1, n16, n15, n12);
                            n5 = n15;
                            continue;
                        }
                        if (1 < n15 - n16) {
                            ++n3;
                            n5 = n16;
                            n6 = n15;
                            n11 = n12;
                            continue;
                        }
                        if (n10 == 0) {
                            return;
                        }
                        object = bzip2DivSufSort$StackEntryArray[--n10];
                        n3 = ((Bzip2DivSufSort$StackEntry)object).a;
                        n5 = ((Bzip2DivSufSort$StackEntry)object).b;
                        n6 = ((Bzip2DivSufSort$StackEntry)object).c;
                        n11 = ((Bzip2DivSufSort$StackEntry)object).d;
                        continue;
                    }
                    if (n16 - n5 <= n15 - n16) {
                        if (1 < n16 - n5) {
                            bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n15, n6, n11);
                            bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3 + 1, n16, n15, n12);
                            n6 = n16;
                            continue;
                        }
                        if (1 < n15 - n16) {
                            bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n15, n6, n11);
                            ++n3;
                            n5 = n16;
                            n6 = n15;
                            n11 = n12;
                            continue;
                        }
                        n5 = n15;
                        continue;
                    }
                    if (1 < n15 - n16) {
                        bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n15, n6, n11);
                        bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n5, n16, n11);
                        ++n3;
                        n5 = n16;
                        n6 = n15;
                        n11 = n12;
                        continue;
                    }
                    bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n15, n6, n11);
                    n6 = n16;
                    continue;
                }
                if (n16 - n5 <= n15 - n16) {
                    if (1 < n6 - n15) {
                        bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3 + 1, n16, n15, n12);
                        bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n5, n16, n11);
                        n5 = n15;
                        continue;
                    }
                    if (1 < n16 - n5) {
                        bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3 + 1, n16, n15, n12);
                        n6 = n16;
                        continue;
                    }
                    if (1 < n15 - n16) {
                        ++n3;
                        n5 = n16;
                        n6 = n15;
                        n11 = n12;
                        continue;
                    }
                    bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n5, n6, n11);
                    continue;
                }
                if (n6 - n15 <= n15 - n16) {
                    if (1 < n6 - n15) {
                        bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n5, n16, n11);
                        bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3 + 1, n16, n15, n12);
                        n5 = n15;
                        continue;
                    }
                    if (1 < n15 - n16) {
                        bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n5, n16, n11);
                        ++n3;
                        n5 = n16;
                        n6 = n15;
                        n11 = n12;
                        continue;
                    }
                    n6 = n16;
                    continue;
                }
                if (1 < n15 - n16) {
                    bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n5, n16, n11);
                    bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n15, n6, n11);
                    ++n3;
                    n5 = n16;
                    n6 = n15;
                    n11 = n12;
                    continue;
                }
                bzip2DivSufSort$StackEntryArray[n10++] = new Bzip2DivSufSort$StackEntry(n3, n5, n16, n11);
                n5 = n15;
                continue;
            }
            if (!bzip2DivSufSort$TRBudget.update(n7, n6 - n5)) break;
            ++n11;
            ++n3;
        }
        for (n8 = 0; n8 < n10; ++n8) {
            if (bzip2DivSufSort$StackEntryArray[n8].d != -3) continue;
            this.lsUpdateGroup(n2, bzip2DivSufSort$StackEntryArray[n8].b, bzip2DivSufSort$StackEntryArray[n8].c);
        }
    }

    private void trSort(int n2, int n3, int n4) {
        int[] nArray = this.SA;
        int n5 = 0;
        if (-n3 < nArray[0]) {
            Bzip2DivSufSort$TRBudget bzip2DivSufSort$TRBudget = new Bzip2DivSufSort$TRBudget(n3, Bzip2DivSufSort.trLog(n3) * 2 / 3 + 1);
            do {
                int n6;
                if ((n6 = nArray[n5]) < 0) {
                    n5 -= n6;
                    continue;
                }
                int n7 = nArray[n2 + n6] + 1;
                if (1 < n7 - n5) {
                    this.trIntroSort(n2, n2 + n4, n2 + n3, n5, n7, bzip2DivSufSort$TRBudget, n3);
                    if (bzip2DivSufSort$TRBudget.chance == 0) {
                        if (0 < n5) {
                            nArray[0] = -n5;
                        }
                        this.lsSort(n2, n3, n4);
                        break;
                    }
                }
                n5 = n7;
            } while (n5 < n3);
        }
    }

    private static int BUCKET_B(int n2, int n3) {
        return n3 << 8 | n2;
    }

    private static int BUCKET_BSTAR(int n2, int n3) {
        return n2 << 8 | n3;
    }

    private int sortTypeBstar(int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        byte[] byArray = this.T;
        int[] nArray3 = this.SA;
        int n7 = this.n;
        int[] nArray4 = new int[256];
        boolean bl2 = true;
        for (n6 = 1; n6 < n7; ++n6) {
            if (byArray[n6 - 1] == byArray[n6]) continue;
            if ((byArray[n6 - 1] & 0xFF) <= (byArray[n6] & 0xFF)) break;
            bl2 = false;
            break;
        }
        n6 = n7 - 1;
        int n8 = n7;
        int n9 = byArray[n6] & 0xFF;
        int n10 = byArray[0] & 0xFF;
        if (n9 < n10 || byArray[n6] == byArray[0] && bl2) {
            if (!bl2) {
                int n11 = Bzip2DivSufSort.BUCKET_BSTAR(n9, n10);
                nArray2[n11] = nArray2[n11] + 1;
                nArray3[--n8] = n6;
            } else {
                int n12 = Bzip2DivSufSort.BUCKET_B(n9, n10);
                nArray2[n12] = nArray2[n12] + 1;
            }
            --n6;
            while (0 <= n6 && (n9 = byArray[n6] & 0xFF) <= (n5 = byArray[n6 + 1] & 0xFF)) {
                int n13 = Bzip2DivSufSort.BUCKET_B(n9, n5);
                nArray2[n13] = nArray2[n13] + 1;
                --n6;
            }
        }
        while (0 <= n6) {
            do {
                int n14 = byArray[n6] & 0xFF;
                nArray[n14] = nArray[n14] + 1;
            } while (0 <= --n6 && (byArray[n6] & 0xFF) >= (byArray[n6 + 1] & 0xFF));
            if (0 > n6) continue;
            int n15 = Bzip2DivSufSort.BUCKET_BSTAR(byArray[n6] & 0xFF, byArray[n6 + 1] & 0xFF);
            nArray2[n15] = nArray2[n15] + 1;
            nArray3[--n8] = n6--;
            while (0 <= n6 && (n9 = byArray[n6] & 0xFF) <= (n5 = byArray[n6 + 1] & 0xFF)) {
                int n16 = Bzip2DivSufSort.BUCKET_B(n9, n5);
                nArray2[n16] = nArray2[n16] + 1;
                --n6;
            }
        }
        if ((n8 = n7 - n8) == 0) {
            for (n6 = 0; n6 < n7; ++n6) {
                nArray3[n6] = n6;
            }
            return 0;
        }
        n6 = -1;
        int n17 = 0;
        for (n4 = 0; n4 < 256; ++n4) {
            n3 = n6 + nArray[n4];
            nArray[n4] = n6 + n17;
            n6 = n3 + nArray2[Bzip2DivSufSort.BUCKET_B(n4, n4)];
            for (n2 = n4 + 1; n2 < 256; ++n2) {
                nArray2[n4 << 8 | n2] = n17 += nArray2[Bzip2DivSufSort.BUCKET_BSTAR(n4, n2)];
                n6 += nArray2[Bzip2DivSufSort.BUCKET_B(n4, n2)];
            }
        }
        int n18 = n7 - n8;
        int n19 = n8;
        n6 = n8 - 2;
        while (0 <= n6) {
            n3 = nArray3[n18 + n6];
            n4 = byArray[n3] & 0xFF;
            n2 = byArray[n3 + 1] & 0xFF;
            int n20 = Bzip2DivSufSort.BUCKET_BSTAR(n4, n2);
            int n21 = nArray2[n20] - 1;
            nArray2[n20] = n21;
            nArray3[n21] = n6--;
        }
        n3 = nArray3[n18 + n8 - 1];
        n4 = byArray[n3] & 0xFF;
        n2 = byArray[n3 + 1] & 0xFF;
        int n22 = Bzip2DivSufSort.BUCKET_BSTAR(n4, n2);
        int n23 = nArray2[n22] - 1;
        nArray2[n22] = n23;
        nArray3[n23] = n8 - 1;
        int[] nArray5 = nArray3;
        int n24 = n8;
        int n25 = n7 - 2 * n8;
        if (n25 <= 256) {
            nArray5 = nArray4;
            n24 = 0;
            n25 = 256;
        }
        n4 = 255;
        n17 = n8;
        while (0 < n17) {
            for (n2 = 255; n4 < n2; --n2) {
                n6 = nArray2[Bzip2DivSufSort.BUCKET_BSTAR(n4, n2)];
                if (1 < n17 - n6) {
                    this.subStringSort(n18, n6, n17, nArray5, n24, n25, 2, nArray3[n6] == n8 - 1, n7);
                }
                n17 = n6;
            }
            --n4;
        }
        for (n6 = n8 - 1; 0 <= n6; --n6) {
            if (0 <= nArray3[n6]) {
                n17 = n6;
                do {
                    nArray3[n19 + nArray3[n6]] = n6;
                } while (0 <= --n6 && 0 <= nArray3[n6]);
                nArray3[n6 + 1] = n6 - n17;
                if (n6 <= 0) break;
            }
            n17 = n6;
            do {
                nArray3[n6] = ~nArray3[n6];
                nArray3[n19 + nArray3[n6]] = n17;
            } while (nArray3[--n6] < 0);
            nArray3[n19 + nArray3[n6]] = n17;
        }
        this.trSort(n19, n8, 1);
        n6 = n7 - 1;
        n17 = n8;
        if ((byArray[n6] & 0xFF) < (byArray[0] & 0xFF) || byArray[n6] == byArray[0] && bl2) {
            if (!bl2) {
                nArray3[nArray3[n19 + --n17]] = n6;
            }
            --n6;
            while (0 <= n6 && (byArray[n6] & 0xFF) <= (byArray[n6 + 1] & 0xFF)) {
                --n6;
            }
        }
        while (0 <= n6) {
            --n6;
            while (0 <= n6 && (byArray[n6] & 0xFF) >= (byArray[n6 + 1] & 0xFF)) {
                --n6;
            }
            if (0 > n6) continue;
            nArray3[nArray3[n19 + --n17]] = n6--;
            while (0 <= n6 && (byArray[n6] & 0xFF) <= (byArray[n6 + 1] & 0xFF)) {
                --n6;
            }
        }
        n6 = n7 - 1;
        int n26 = n8 - 1;
        for (n4 = 255; 0 <= n4; --n4) {
            for (n2 = 255; n4 < n2; --n2) {
                n3 = n6 - nArray2[Bzip2DivSufSort.BUCKET_B(n4, n2)];
                nArray2[Bzip2DivSufSort.BUCKET_B((int)n4, (int)n2)] = n6 + 1;
                n6 = n3;
                n17 = nArray2[Bzip2DivSufSort.BUCKET_BSTAR(n4, n2)];
                while (n17 <= n26) {
                    nArray3[n6] = nArray3[n26];
                    --n6;
                    --n26;
                }
            }
            n3 = n6 - nArray2[Bzip2DivSufSort.BUCKET_B(n4, n4)];
            nArray2[Bzip2DivSufSort.BUCKET_B((int)n4, (int)n4)] = n6 + 1;
            if (n4 < 255) {
                nArray2[Bzip2DivSufSort.BUCKET_BSTAR((int)n4, (int)(n4 + 1))] = n3 + 1;
            }
            n6 = nArray[n4];
        }
        return n8;
    }

    private int constructBWT(int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        int n4;
        int n5;
        byte[] byArray = this.T;
        int[] nArray3 = this.SA;
        int n6 = this.n;
        int n7 = 0;
        int n8 = 0;
        int n9 = -1;
        for (int i2 = 254; 0 <= i2; --i2) {
            n5 = nArray2[Bzip2DivSufSort.BUCKET_BSTAR(i2, i2 + 1)];
            n7 = 0;
            n8 = -1;
            for (int i3 = nArray[i2 + 1]; n5 <= i3; --i3) {
                n3 = n4 = nArray3[i3];
                if (0 <= n4) {
                    if (--n4 < 0) {
                        n4 = n6 - 1;
                    }
                    if ((n2 = byArray[n4] & 0xFF) > i2) continue;
                    nArray3[i3] = ~n3;
                    if (0 < n4 && (byArray[n4 - 1] & 0xFF) > n2) {
                        n4 ^= 0xFFFFFFFF;
                    }
                    if (n8 == n2) {
                        nArray3[--n7] = n4;
                        continue;
                    }
                    if (0 <= n8) {
                        nArray2[Bzip2DivSufSort.BUCKET_B((int)n8, (int)i2)] = n7;
                    }
                    n8 = n2;
                    n7 = nArray2[Bzip2DivSufSort.BUCKET_B(n8, i2)] - 1;
                    nArray3[n7] = n4;
                    continue;
                }
                nArray3[i3] = ~n4;
            }
        }
        for (n5 = 0; n5 < n6; ++n5) {
            n3 = n4 = nArray3[n5];
            if (0 <= n4) {
                if (--n4 < 0) {
                    n4 = n6 - 1;
                }
                if ((n2 = byArray[n4] & 0xFF) >= (byArray[n4 + 1] & 0xFF)) {
                    if (0 < n4 && (byArray[n4 - 1] & 0xFF) < n2) {
                        n4 ^= 0xFFFFFFFF;
                    }
                    if (n2 == n8) {
                        nArray3[++n7] = n4;
                    } else {
                        if (n8 != -1) {
                            nArray[n8] = n7;
                        }
                        n8 = n2;
                        n7 = nArray[n8] + 1;
                        nArray3[n7] = n4;
                    }
                }
            } else {
                n3 ^= 0xFFFFFFFF;
            }
            if (n3 == 0) {
                nArray3[n5] = byArray[n6 - 1];
                n9 = n5;
                continue;
            }
            nArray3[n5] = byArray[n3 - 1];
        }
        return n9;
    }

    public int bwt() {
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n2 = this.n;
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[65536];
        if (n2 == 0) {
            return 0;
        }
        if (n2 == 1) {
            nArray[0] = byArray[0];
            return 0;
        }
        int n3 = this.sortTypeBstar(nArray2, nArray3);
        if (0 < n3) {
            return this.constructBWT(nArray2, nArray3);
        }
        return 0;
    }
}

