/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.Bzip2BitReader;
import io.netty.handler.codec.compression.Bzip2BlockDecompressor;
import io.netty.handler.codec.compression.Bzip2Decoder$State;
import io.netty.handler.codec.compression.Bzip2HuffmanStageDecoder;
import io.netty.handler.codec.compression.Bzip2MoveToFrontTable;
import io.netty.handler.codec.compression.DecompressionException;
import java.util.List;

public class Bzip2Decoder
extends ByteToMessageDecoder {
    private Bzip2Decoder$State currentState = Bzip2Decoder$State.INIT;
    private final Bzip2BitReader reader = new Bzip2BitReader();
    private Bzip2BlockDecompressor blockDecompressor;
    private Bzip2HuffmanStageDecoder huffmanStageDecoder;
    private int blockSize;
    private int blockCRC;
    private int streamCRC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (!byteBuf.isReadable()) {
            return;
        }
        Bzip2BitReader bzip2BitReader = this.reader;
        bzip2BitReader.setByteBuf(byteBuf);
        block15: while (true) {
            switch (this.currentState) {
                case INIT: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    int n2 = byteBuf.readUnsignedMedium();
                    if (n2 != 4348520) {
                        throw new DecompressionException("Unexpected stream identifier contents. Mismatched bzip2 protocol version?");
                    }
                    int n3 = byteBuf.readByte() - 48;
                    if (n3 < 1 || n3 > 9) {
                        throw new DecompressionException("block size is invalid");
                    }
                    this.blockSize = n3 * 100000;
                    this.streamCRC = 0;
                    this.currentState = Bzip2Decoder$State.INIT_BLOCK;
                }
                case INIT_BLOCK: {
                    int n4;
                    if (!bzip2BitReader.hasReadableBytes(10)) {
                        return;
                    }
                    int n5 = bzip2BitReader.readBits(24);
                    int n6 = bzip2BitReader.readBits(24);
                    if (n5 == 1536581 && n6 == 3690640) {
                        n4 = bzip2BitReader.readInt();
                        if (n4 != this.streamCRC) {
                            throw new DecompressionException("stream CRC error");
                        }
                        this.currentState = Bzip2Decoder$State.EOF;
                        continue block15;
                    }
                    if (n5 != 3227993 || n6 != 2511705) {
                        throw new DecompressionException("bad block header");
                    }
                    this.blockCRC = bzip2BitReader.readInt();
                    this.currentState = Bzip2Decoder$State.INIT_BLOCK_PARAMS;
                }
                case INIT_BLOCK_PARAMS: {
                    if (!bzip2BitReader.hasReadableBits(25)) {
                        return;
                    }
                    int n4 = bzip2BitReader.readBoolean();
                    int n7 = bzip2BitReader.readBits(24);
                    this.blockDecompressor = new Bzip2BlockDecompressor(this.blockSize, this.blockCRC, n4 != 0, n7, bzip2BitReader);
                    this.currentState = Bzip2Decoder$State.RECEIVE_HUFFMAN_USED_MAP;
                }
                case RECEIVE_HUFFMAN_USED_MAP: {
                    if (!bzip2BitReader.hasReadableBits(16)) {
                        return;
                    }
                    this.blockDecompressor.huffmanInUse16 = bzip2BitReader.readBits(16);
                    this.currentState = Bzip2Decoder$State.RECEIVE_HUFFMAN_USED_BITMAPS;
                }
                case RECEIVE_HUFFMAN_USED_BITMAPS: {
                    int n8;
                    int n9;
                    int n10;
                    Bzip2BlockDecompressor bzip2BlockDecompressor = this.blockDecompressor;
                    int n11 = bzip2BlockDecompressor.huffmanInUse16;
                    int n12 = Integer.bitCount(n11);
                    byte[] byArray = bzip2BlockDecompressor.huffmanSymbolMap;
                    if (!bzip2BitReader.hasReadableBits(n12 * 16 + 3)) {
                        return;
                    }
                    int n13 = 0;
                    if (n12 > 0) {
                        for (n10 = 0; n10 < 16; ++n10) {
                            if ((n11 & 32768 >>> n10) == 0) continue;
                            n9 = 0;
                            n8 = n10 << 4;
                            while (n9 < 16) {
                                if (bzip2BitReader.readBoolean()) {
                                    byArray[n13++] = (byte)n8;
                                }
                                ++n9;
                                ++n8;
                            }
                        }
                    }
                    bzip2BlockDecompressor.huffmanEndOfBlockSymbol = n13 + 1;
                    n10 = bzip2BitReader.readBits(3);
                    if (n10 < 2 || n10 > 6) {
                        throw new DecompressionException("incorrect huffman groups number");
                    }
                    n9 = n13 + 2;
                    if (n9 > 258) {
                        throw new DecompressionException("incorrect alphabet size");
                    }
                    this.huffmanStageDecoder = new Bzip2HuffmanStageDecoder(bzip2BitReader, n10, n9);
                    this.currentState = Bzip2Decoder$State.RECEIVE_SELECTORS_NUMBER;
                }
                case RECEIVE_SELECTORS_NUMBER: {
                    if (!bzip2BitReader.hasReadableBits(15)) {
                        return;
                    }
                    int n8 = bzip2BitReader.readBits(15);
                    if (n8 < 1 || n8 > 18002) {
                        throw new DecompressionException("incorrect selectors number");
                    }
                    this.huffmanStageDecoder.selectors = new byte[n8];
                    this.currentState = Bzip2Decoder$State.RECEIVE_SELECTORS;
                }
                case RECEIVE_SELECTORS: {
                    Bzip2HuffmanStageDecoder bzip2HuffmanStageDecoder = this.huffmanStageDecoder;
                    byte[] byArray = bzip2HuffmanStageDecoder.selectors;
                    int n8 = byArray.length;
                    Bzip2MoveToFrontTable bzip2MoveToFrontTable = bzip2HuffmanStageDecoder.tableMTF;
                    for (int i2 = bzip2HuffmanStageDecoder.currentSelector; i2 < n8; ++i2) {
                        if (!bzip2BitReader.hasReadableBits(6)) {
                            bzip2HuffmanStageDecoder.currentSelector = i2;
                            return;
                        }
                        int n14 = 0;
                        while (bzip2BitReader.readBoolean()) {
                            ++n14;
                        }
                        byArray[i2] = bzip2MoveToFrontTable.indexToFront(n14);
                    }
                    this.currentState = Bzip2Decoder$State.RECEIVE_HUFFMAN_LENGTH;
                }
                case RECEIVE_HUFFMAN_LENGTH: {
                    int n15;
                    Bzip2HuffmanStageDecoder bzip2HuffmanStageDecoder = this.huffmanStageDecoder;
                    int n10 = bzip2HuffmanStageDecoder.totalTables;
                    byte[][] byArray = bzip2HuffmanStageDecoder.tableCodeLengths;
                    int n9 = bzip2HuffmanStageDecoder.alphabetSize;
                    int n16 = bzip2HuffmanStageDecoder.currentLength;
                    int n17 = 0;
                    boolean bl2 = bzip2HuffmanStageDecoder.modifyLength;
                    boolean bl3 = false;
                    block20: for (n15 = bzip2HuffmanStageDecoder.currentGroup; n15 < n10; ++n15) {
                        if (!bzip2BitReader.hasReadableBits(5)) {
                            bl3 = true;
                            break;
                        }
                        if (n16 < 0) {
                            n16 = bzip2BitReader.readBits(5);
                        }
                        for (n17 = bzip2HuffmanStageDecoder.currentAlpha; n17 < n9; ++n17) {
                            if (!bzip2BitReader.isReadable()) {
                                bl3 = true;
                                break block20;
                            }
                            while (bl2 || bzip2BitReader.readBoolean()) {
                                if (!bzip2BitReader.isReadable()) {
                                    bl2 = true;
                                    bl3 = true;
                                    break block20;
                                }
                                n16 += bzip2BitReader.readBoolean() ? -1 : 1;
                                bl2 = false;
                                if (bzip2BitReader.isReadable()) continue;
                                bl3 = true;
                                break block20;
                            }
                            byArray[n15][n17] = (byte)n16;
                        }
                        n16 = -1;
                        bzip2HuffmanStageDecoder.currentAlpha = 0;
                        n17 = 0;
                        bl2 = false;
                    }
                    if (bl3) {
                        bzip2HuffmanStageDecoder.currentGroup = n15;
                        bzip2HuffmanStageDecoder.currentLength = n16;
                        bzip2HuffmanStageDecoder.currentAlpha = n17;
                        bzip2HuffmanStageDecoder.modifyLength = bl2;
                        return;
                    }
                    bzip2HuffmanStageDecoder.createHuffmanDecodingTables();
                    this.currentState = Bzip2Decoder$State.DECODE_HUFFMAN_DATA;
                }
                case DECODE_HUFFMAN_DATA: {
                    Bzip2BlockDecompressor bzip2BlockDecompressor = this.blockDecompressor;
                    int n18 = byteBuf.readerIndex();
                    boolean bl4 = bzip2BlockDecompressor.decodeHuffmanData(this.huffmanStageDecoder);
                    if (!bl4) {
                        return;
                    }
                    if (byteBuf.readerIndex() == n18 && byteBuf.isReadable()) {
                        bzip2BitReader.refill();
                    }
                    int n19 = bzip2BlockDecompressor.blockLength();
                    ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(n19);
                    boolean bl5 = false;
                    try {
                        int n20;
                        while ((n20 = bzip2BlockDecompressor.read()) >= 0) {
                            byteBuf2.writeByte(n20);
                        }
                        int n21 = bzip2BlockDecompressor.checkCRC();
                        this.streamCRC = (this.streamCRC << 1 | this.streamCRC >>> 31) ^ n21;
                        list.add(byteBuf2);
                        bl5 = true;
                    }
                    finally {
                        if (!bl5) {
                            byteBuf2.release();
                        }
                    }
                    this.currentState = Bzip2Decoder$State.INIT_BLOCK;
                    continue block15;
                }
                case EOF: {
                    byteBuf.skipBytes(byteBuf.readableBytes());
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public boolean isClosed() {
        return this.currentState == Bzip2Decoder$State.EOF;
    }
}

