/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.handler.codec.compression.Bzip2BitReader;
import io.netty.handler.codec.compression.Bzip2HuffmanStageDecoder;
import io.netty.handler.codec.compression.Bzip2MoveToFrontTable;
import io.netty.handler.codec.compression.Bzip2Rand;
import io.netty.handler.codec.compression.Crc32;
import io.netty.handler.codec.compression.DecompressionException;

final class Bzip2BlockDecompressor {
    private final Bzip2BitReader reader;
    private final Crc32 crc = new Crc32();
    private final int blockCRC;
    private final boolean blockRandomised;
    int huffmanEndOfBlockSymbol;
    int huffmanInUse16;
    final byte[] huffmanSymbolMap = new byte[256];
    private final int[] bwtByteCounts = new int[256];
    private final byte[] bwtBlock;
    private final int bwtStartPointer;
    private int[] bwtMergedPointers;
    private int bwtCurrentMergedPointer;
    private int bwtBlockLength;
    private int bwtBytesDecoded;
    private int rleLastDecodedByte = -1;
    private int rleAccumulator;
    private int rleRepeat;
    private int randomIndex;
    private int randomCount = Bzip2Rand.rNums(0) - 1;
    private final Bzip2MoveToFrontTable symbolMTF = new Bzip2MoveToFrontTable();
    private int repeatCount;
    private int repeatIncrement = 1;
    private int mtfValue;

    Bzip2BlockDecompressor(int n2, int n3, boolean bl2, int n4, Bzip2BitReader bzip2BitReader) {
        this.bwtBlock = new byte[n2];
        this.blockCRC = n3;
        this.blockRandomised = bl2;
        this.bwtStartPointer = n4;
        this.reader = bzip2BitReader;
    }

    boolean decodeHuffmanData(Bzip2HuffmanStageDecoder bzip2HuffmanStageDecoder) {
        Bzip2BitReader bzip2BitReader = this.reader;
        byte[] byArray = this.bwtBlock;
        byte[] byArray2 = this.huffmanSymbolMap;
        int n2 = this.bwtBlock.length;
        int n3 = this.huffmanEndOfBlockSymbol;
        int[] nArray = this.bwtByteCounts;
        Bzip2MoveToFrontTable bzip2MoveToFrontTable = this.symbolMTF;
        int n4 = this.bwtBlockLength;
        int n5 = this.repeatCount;
        int n6 = this.repeatIncrement;
        int n7 = this.mtfValue;
        while (true) {
            byte by2;
            if (!bzip2BitReader.hasReadableBits(23)) {
                this.bwtBlockLength = n4;
                this.repeatCount = n5;
                this.repeatIncrement = n6;
                this.mtfValue = n7;
                return false;
            }
            int n8 = bzip2HuffmanStageDecoder.nextSymbol();
            if (n8 == 0) {
                n5 += n6;
                n6 <<= 1;
                continue;
            }
            if (n8 == 1) {
                n5 += n6 << 1;
                n6 <<= 1;
                continue;
            }
            if (n5 > 0) {
                if (n4 + n5 > n2) {
                    throw new DecompressionException("block exceeds declared block size");
                }
                by2 = byArray2[n7];
                int n9 = by2 & 0xFF;
                nArray[n9] = nArray[n9] + n5;
                while (--n5 >= 0) {
                    byArray[n4++] = by2;
                }
                n5 = 0;
                n6 = 1;
            }
            if (n8 == n3) break;
            if (n4 >= n2) {
                throw new DecompressionException("block exceeds declared block size");
            }
            n7 = bzip2MoveToFrontTable.indexToFront(n8 - 1) & 0xFF;
            by2 = byArray2[n7];
            int n10 = by2 & 0xFF;
            nArray[n10] = nArray[n10] + 1;
            byArray[n4++] = by2;
        }
        this.bwtBlockLength = n4;
        this.initialiseInverseBWT();
        return true;
    }

    private void initialiseInverseBWT() {
        int n2;
        int n3 = this.bwtStartPointer;
        byte[] byArray = this.bwtBlock;
        int[] nArray = new int[this.bwtBlockLength];
        int[] nArray2 = new int[256];
        if (n3 < 0 || n3 >= this.bwtBlockLength) {
            throw new DecompressionException("start pointer invalid");
        }
        System.arraycopy(this.bwtByteCounts, 0, nArray2, 1, 255);
        for (n2 = 2; n2 <= 255; ++n2) {
            int n4 = n2;
            nArray2[n4] = nArray2[n4] + nArray2[n2 - 1];
        }
        for (n2 = 0; n2 < this.bwtBlockLength; ++n2) {
            int n5;
            int n6 = n5 = byArray[n2] & 0xFF;
            int n7 = nArray2[n6];
            nArray2[n6] = n7 + 1;
            nArray[n7] = (n2 << 8) + n5;
        }
        this.bwtMergedPointers = nArray;
        this.bwtCurrentMergedPointer = nArray[n3];
    }

    public int read() {
        while (this.rleRepeat < 1) {
            if (this.bwtBytesDecoded == this.bwtBlockLength) {
                return -1;
            }
            int n2 = this.decodeNextBWTByte();
            if (n2 != this.rleLastDecodedByte) {
                this.rleLastDecodedByte = n2;
                this.rleRepeat = 1;
                this.rleAccumulator = 1;
                this.crc.updateCRC(n2);
                continue;
            }
            if (++this.rleAccumulator == 4) {
                int n3;
                this.rleRepeat = n3 = this.decodeNextBWTByte() + 1;
                this.rleAccumulator = 0;
                this.crc.updateCRC(n2, n3);
                continue;
            }
            this.rleRepeat = 1;
            this.crc.updateCRC(n2);
        }
        --this.rleRepeat;
        return this.rleLastDecodedByte;
    }

    private int decodeNextBWTByte() {
        int n2 = this.bwtCurrentMergedPointer;
        int n3 = n2 & 0xFF;
        this.bwtCurrentMergedPointer = this.bwtMergedPointers[n2 >>> 8];
        if (this.blockRandomised && --this.randomCount == 0) {
            n3 ^= 1;
            this.randomIndex = (this.randomIndex + 1) % 512;
            this.randomCount = Bzip2Rand.rNums(this.randomIndex);
        }
        ++this.bwtBytesDecoded;
        return n3;
    }

    public int blockLength() {
        return this.bwtBlockLength;
    }

    int checkCRC() {
        int n2 = this.crc.getCRC();
        if (this.blockCRC != n2) {
            throw new DecompressionException("block CRC error");
        }
        return n2;
    }
}

