/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.Bzip2BitWriter;
import io.netty.handler.codec.compression.Bzip2BlockCompressor$1;
import io.netty.handler.codec.compression.Bzip2DivSufSort;
import io.netty.handler.codec.compression.Bzip2HuffmanStageEncoder;
import io.netty.handler.codec.compression.Bzip2MTFAndRLE2StageEncoder;
import io.netty.handler.codec.compression.Crc32;
import io.netty.util.ByteProcessor;

final class Bzip2BlockCompressor {
    private final ByteProcessor writeProcessor = new Bzip2BlockCompressor$1(this);
    private final Bzip2BitWriter writer;
    private final Crc32 crc = new Crc32();
    private final byte[] block;
    private int blockLength;
    private final int blockLengthLimit;
    private final boolean[] blockValuesPresent = new boolean[256];
    private final int[] bwtBlock;
    private int rleCurrentValue = -1;
    private int rleLength;

    Bzip2BlockCompressor(Bzip2BitWriter bzip2BitWriter, int n2) {
        this.writer = bzip2BitWriter;
        this.block = new byte[n2 + 1];
        this.bwtBlock = new int[n2 + 1];
        this.blockLengthLimit = n2 - 6;
    }

    private void writeSymbolMap(ByteBuf byteBuf) {
        int n2;
        int n3;
        Bzip2BitWriter bzip2BitWriter = this.writer;
        boolean[] blArray = this.blockValuesPresent;
        boolean[] blArray2 = new boolean[16];
        for (int i2 = 0; i2 < blArray2.length; ++i2) {
            n3 = 0;
            n2 = i2 << 4;
            while (n3 < 16) {
                if (blArray[n2]) {
                    blArray2[i2] = true;
                }
                ++n3;
                ++n2;
            }
        }
        for (boolean bl2 : blArray2) {
            bzip2BitWriter.writeBoolean(byteBuf, bl2);
        }
        for (int i3 = 0; i3 < blArray2.length; ++i3) {
            if (!blArray2[i3]) continue;
            n3 = 0;
            n2 = i3 << 4;
            while (n3 < 16) {
                bzip2BitWriter.writeBoolean(byteBuf, blArray[n2]);
                ++n3;
                ++n2;
            }
        }
    }

    private void writeRun(int n2, int n3) {
        int n4 = this.blockLength;
        byte[] byArray = this.block;
        this.blockValuesPresent[n2] = true;
        this.crc.updateCRC(n2, n3);
        byte by2 = (byte)n2;
        switch (n3) {
            case 1: {
                byArray[n4] = by2;
                this.blockLength = n4 + 1;
                break;
            }
            case 2: {
                byArray[n4] = by2;
                byArray[n4 + 1] = by2;
                this.blockLength = n4 + 2;
                break;
            }
            case 3: {
                byArray[n4] = by2;
                byArray[n4 + 1] = by2;
                byArray[n4 + 2] = by2;
                this.blockLength = n4 + 3;
                break;
            }
            default: {
                this.blockValuesPresent[n3 -= 4] = true;
                byArray[n4] = by2;
                byArray[n4 + 1] = by2;
                byArray[n4 + 2] = by2;
                byArray[n4 + 3] = by2;
                byArray[n4 + 4] = (byte)n3;
                this.blockLength = n4 + 5;
            }
        }
    }

    boolean write(int n2) {
        if (this.blockLength > this.blockLengthLimit) {
            return false;
        }
        int n3 = this.rleCurrentValue;
        int n4 = this.rleLength;
        if (n4 == 0) {
            this.rleCurrentValue = n2;
            this.rleLength = 1;
        } else if (n3 != n2) {
            this.writeRun(n3 & 0xFF, n4);
            this.rleCurrentValue = n2;
            this.rleLength = 1;
        } else if (n4 == 254) {
            this.writeRun(n3 & 0xFF, 255);
            this.rleLength = 0;
        } else {
            this.rleLength = n4 + 1;
        }
        return true;
    }

    int write(ByteBuf byteBuf, int n2, int n3) {
        int n4 = byteBuf.forEachByte(n2, n3, this.writeProcessor);
        return n4 == -1 ? n3 : n4 - n2;
    }

    void close(ByteBuf byteBuf) {
        if (this.rleLength > 0) {
            this.writeRun(this.rleCurrentValue & 0xFF, this.rleLength);
        }
        this.block[this.blockLength] = this.block[0];
        Bzip2DivSufSort bzip2DivSufSort = new Bzip2DivSufSort(this.block, this.bwtBlock, this.blockLength);
        int n2 = bzip2DivSufSort.bwt();
        Bzip2BitWriter bzip2BitWriter = this.writer;
        bzip2BitWriter.writeBits(byteBuf, 24, 3227993L);
        bzip2BitWriter.writeBits(byteBuf, 24, 2511705L);
        bzip2BitWriter.writeInt(byteBuf, this.crc.getCRC());
        bzip2BitWriter.writeBoolean(byteBuf, false);
        bzip2BitWriter.writeBits(byteBuf, 24, n2);
        this.writeSymbolMap(byteBuf);
        Bzip2MTFAndRLE2StageEncoder bzip2MTFAndRLE2StageEncoder = new Bzip2MTFAndRLE2StageEncoder(this.bwtBlock, this.blockLength, this.blockValuesPresent);
        bzip2MTFAndRLE2StageEncoder.encode();
        Bzip2HuffmanStageEncoder bzip2HuffmanStageEncoder = new Bzip2HuffmanStageEncoder(bzip2BitWriter, bzip2MTFAndRLE2StageEncoder.mtfBlock(), bzip2MTFAndRLE2StageEncoder.mtfLength(), bzip2MTFAndRLE2StageEncoder.mtfAlphabetSize(), bzip2MTFAndRLE2StageEncoder.mtfSymbolFrequencies());
        bzip2HuffmanStageEncoder.encode(byteBuf);
    }

    int availableSize() {
        if (this.blockLength == 0) {
            return this.blockLengthLimit + 2;
        }
        return this.blockLengthLimit - this.blockLength + 1;
    }

    boolean isFull() {
        return this.blockLength > this.blockLengthLimit;
    }

    boolean isEmpty() {
        return this.blockLength == 0 && this.rleLength == 0;
    }

    int crc() {
        return this.crc.getCRC();
    }
}

