/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;

final class Bzip2BitWriter {
    private long bitBuffer;
    private int bitCount;

    Bzip2BitWriter() {
    }

    void writeBits(ByteBuf byteBuf, int n2, long l2) {
        if (n2 < 0 || n2 > 32) {
            throw new IllegalArgumentException("count: " + n2 + " (expected: 0-32)");
        }
        int n3 = this.bitCount;
        long l3 = this.bitBuffer | l2 << 64 - n2 >>> n3;
        if ((n3 += n2) >= 32) {
            byteBuf.writeInt((int)(l3 >>> 32));
            l3 <<= 32;
            n3 -= 32;
        }
        this.bitBuffer = l3;
        this.bitCount = n3;
    }

    void writeBoolean(ByteBuf byteBuf, boolean bl2) {
        int n2 = this.bitCount + 1;
        long l2 = this.bitBuffer | (bl2 ? 1L << 64 - n2 : 0L);
        if (n2 == 32) {
            byteBuf.writeInt((int)(l2 >>> 32));
            l2 = 0L;
            n2 = 0;
        }
        this.bitBuffer = l2;
        this.bitCount = n2;
    }

    void writeUnary(ByteBuf byteBuf, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("value: " + n2 + " (expected 0 or more)");
        }
        while (n2-- > 0) {
            this.writeBoolean(byteBuf, true);
        }
        this.writeBoolean(byteBuf, false);
    }

    void writeInt(ByteBuf byteBuf, int n2) {
        this.writeBits(byteBuf, 32, n2);
    }

    void flush(ByteBuf byteBuf) {
        int n2 = this.bitCount;
        if (n2 > 0) {
            long l2 = this.bitBuffer;
            int n3 = 64 - n2;
            if (n2 <= 8) {
                byteBuf.writeByte((int)(l2 >>> n3 << 8 - n2));
            } else if (n2 <= 16) {
                byteBuf.writeShort((int)(l2 >>> n3 << 16 - n2));
            } else if (n2 <= 24) {
                byteBuf.writeMedium((int)(l2 >>> n3 << 24 - n2));
            } else {
                byteBuf.writeInt((int)(l2 >>> n3 << 32 - n2));
            }
        }
    }
}

