/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;

class Bzip2BitReader {
    private static final int MAX_COUNT_OF_READABLE_BYTES = 0xFFFFFFF;
    private ByteBuf in;
    private long bitBuffer;
    private int bitCount;

    Bzip2BitReader() {
    }

    void setByteBuf(ByteBuf byteBuf) {
        this.in = byteBuf;
    }

    int readBits(int n2) {
        if (n2 < 0 || n2 > 32) {
            throw new IllegalArgumentException("count: " + n2 + " (expected: 0-32 )");
        }
        int n3 = this.bitCount;
        long l2 = this.bitBuffer;
        if (n3 < n2) {
            int n4;
            long l3;
            switch (this.in.readableBytes()) {
                case 1: {
                    l3 = this.in.readUnsignedByte();
                    n4 = 8;
                    break;
                }
                case 2: {
                    l3 = this.in.readUnsignedShort();
                    n4 = 16;
                    break;
                }
                case 3: {
                    l3 = this.in.readUnsignedMedium();
                    n4 = 24;
                    break;
                }
                default: {
                    l3 = this.in.readUnsignedInt();
                    n4 = 32;
                }
            }
            l2 = l2 << n4 | l3;
            n3 += n4;
            this.bitBuffer = l2;
        }
        this.bitCount = n3 -= n2;
        return (int)(l2 >>> n3 & (n2 != 32 ? (long)((1 << n2) - 1) : 0xFFFFFFFFL));
    }

    boolean readBoolean() {
        return this.readBits(1) != 0;
    }

    int readInt() {
        return this.readBits(32);
    }

    void refill() {
        short s2 = this.in.readUnsignedByte();
        this.bitBuffer = this.bitBuffer << 8 | (long)s2;
        this.bitCount += 8;
    }

    boolean isReadable() {
        return this.bitCount > 0 || this.in.isReadable();
    }

    boolean hasReadableBits(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("count: " + n2 + " (expected value greater than 0)");
        }
        return this.bitCount >= n2 || (this.in.readableBytes() << 3 & Integer.MAX_VALUE) >= n2 - this.bitCount;
    }

    boolean hasReadableBytes(int n2) {
        if (n2 < 0 || n2 > 0xFFFFFFF) {
            throw new IllegalArgumentException("count: " + n2 + " (expected: 0-" + 0xFFFFFFF + ')');
        }
        return this.hasReadableBits(n2 << 3);
    }
}

