/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.ByteBufChecksum$1;
import io.netty.handler.codec.compression.ByteBufChecksum$ReflectiveByteBufChecksum;
import io.netty.handler.codec.compression.ByteBufChecksum$SlowByteBufChecksum;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

abstract class ByteBufChecksum
implements Checksum {
    private static final Method ADLER32_UPDATE_METHOD = ByteBufChecksum.updateByteBuffer(new Adler32());
    private static final Method CRC32_UPDATE_METHOD = ByteBufChecksum.updateByteBuffer(new CRC32());
    private final ByteProcessor updateProcessor = new ByteBufChecksum$1(this);

    ByteBufChecksum() {
    }

    private static Method updateByteBuffer(Checksum checksum) {
        if (PlatformDependent.javaVersion() >= 8) {
            try {
                Method method = checksum.getClass().getDeclaredMethod("update", ByteBuffer.class);
                method.invoke((Object)method, ByteBuffer.allocate(1));
                return method;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    static ByteBufChecksum wrapChecksum(Checksum checksum) {
        ObjectUtil.checkNotNull(checksum, "checksum");
        if (checksum instanceof Adler32 && ADLER32_UPDATE_METHOD != null) {
            return new ByteBufChecksum$ReflectiveByteBufChecksum(checksum, ADLER32_UPDATE_METHOD);
        }
        if (checksum instanceof CRC32 && CRC32_UPDATE_METHOD != null) {
            return new ByteBufChecksum$ReflectiveByteBufChecksum(checksum, CRC32_UPDATE_METHOD);
        }
        return new ByteBufChecksum$SlowByteBufChecksum(checksum);
    }

    public void update(ByteBuf byteBuf, int n2, int n3) {
        if (byteBuf.hasArray()) {
            this.update(byteBuf.array(), byteBuf.arrayOffset() + n2, n3);
        } else {
            byteBuf.forEachByte(n2, n3, this.updateProcessor);
        }
    }
}

