/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.base64;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.base64.Base64$Decoder;
import io.netty.handler.codec.base64.Base64Dialect;
import java.nio.ByteOrder;

public final class Base64 {
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    private static byte[] alphabet(Base64Dialect base64Dialect) {
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        return base64Dialect.alphabet;
    }

    private static byte[] decodabet(Base64Dialect base64Dialect) {
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        return base64Dialect.decodabet;
    }

    private static boolean breakLines(Base64Dialect base64Dialect) {
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        return base64Dialect.breakLinesByDefault;
    }

    public static ByteBuf encode(ByteBuf byteBuf) {
        return Base64.encode(byteBuf, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, Base64.breakLines(base64Dialect), base64Dialect);
    }

    public static ByteBuf encode(ByteBuf byteBuf, boolean bl2) {
        return Base64.encode(byteBuf, bl2, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, boolean bl2, Base64Dialect base64Dialect) {
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        ByteBuf byteBuf2 = Base64.encode(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), bl2, base64Dialect);
        byteBuf.readerIndex(byteBuf.writerIndex());
        return byteBuf2;
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n2, int n3) {
        return Base64.encode(byteBuf, n2, n3, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n2, int n3, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, n2, n3, Base64.breakLines(base64Dialect), base64Dialect);
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n2, int n3, boolean bl2) {
        return Base64.encode(byteBuf, n2, n3, bl2, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n2, int n3, boolean bl2, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, n2, n3, bl2, base64Dialect, byteBuf.alloc());
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n2, int n3, boolean bl2, Base64Dialect base64Dialect, ByteBufAllocator byteBufAllocator) {
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        ByteBuf byteBuf2 = byteBufAllocator.buffer(Base64.encodedBufferSize(n3, bl2)).order(byteBuf.order());
        byte[] byArray = Base64.alphabet(base64Dialect);
        int n4 = 0;
        int n5 = 0;
        int n6 = n3 - 2;
        int n7 = 0;
        while (n4 < n6) {
            Base64.encode3to4(byteBuf, n4 + n2, 3, byteBuf2, n5, byArray);
            if (bl2 && (n7 += 4) == 76) {
                byteBuf2.setByte(n5 + 4, 10);
                ++n5;
                n7 = 0;
            }
            n4 += 3;
            n5 += 4;
        }
        if (n4 < n3) {
            Base64.encode3to4(byteBuf, n4 + n2, n3 - n4, byteBuf2, n5, byArray);
            n5 += 4;
        }
        if (n5 > 1 && byteBuf2.getByte(n5 - 1) == 10) {
            --n5;
        }
        return byteBuf2.slice(0, n5);
    }

    private static void encode3to4(ByteBuf byteBuf, int n2, int n3, ByteBuf byteBuf2, int n4, byte[] byArray) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            int n5;
            switch (n3) {
                case 1: {
                    n5 = Base64.toInt(byteBuf.getByte(n2));
                    break;
                }
                case 2: {
                    n5 = Base64.toIntBE(byteBuf.getShort(n2));
                    break;
                }
                default: {
                    n5 = n3 <= 0 ? 0 : Base64.toIntBE(byteBuf.getMedium(n2));
                }
            }
            Base64.encode3to4BigEndian(n5, n3, byteBuf2, n4, byArray);
        } else {
            int n6;
            switch (n3) {
                case 1: {
                    n6 = Base64.toInt(byteBuf.getByte(n2));
                    break;
                }
                case 2: {
                    n6 = Base64.toIntLE(byteBuf.getShort(n2));
                    break;
                }
                default: {
                    n6 = n3 <= 0 ? 0 : Base64.toIntLE(byteBuf.getMedium(n2));
                }
            }
            Base64.encode3to4LittleEndian(n6, n3, byteBuf2, n4, byArray);
        }
    }

    static int encodedBufferSize(int n2, boolean bl2) {
        long l2 = ((long)n2 << 2) / 3L;
        long l3 = l2 + 3L & 0xFFFFFFFFFFFFFFFCL;
        if (bl2) {
            l3 += l2 / 76L;
        }
        return l3 < Integer.MAX_VALUE ? (int)l3 : Integer.MAX_VALUE;
    }

    private static int toInt(byte by2) {
        return (by2 & 0xFF) << 16;
    }

    private static int toIntBE(short s2) {
        return (s2 & 0xFF00) << 8 | (s2 & 0xFF) << 8;
    }

    private static int toIntLE(short s2) {
        return (s2 & 0xFF) << 16 | s2 & 0xFF00;
    }

    private static int toIntBE(int n2) {
        return n2 & 0xFF0000 | n2 & 0xFF00 | n2 & 0xFF;
    }

    private static int toIntLE(int n2) {
        return (n2 & 0xFF) << 16 | n2 & 0xFF00 | (n2 & 0xFF0000) >>> 16;
    }

    private static void encode3to4BigEndian(int n2, int n3, ByteBuf byteBuf, int n4, byte[] byArray) {
        switch (n3) {
            case 3: {
                byteBuf.setInt(n4, byArray[n2 >>> 18] << 24 | byArray[n2 >>> 12 & 0x3F] << 16 | byArray[n2 >>> 6 & 0x3F] << 8 | byArray[n2 & 0x3F]);
                break;
            }
            case 2: {
                byteBuf.setInt(n4, byArray[n2 >>> 18] << 24 | byArray[n2 >>> 12 & 0x3F] << 16 | byArray[n2 >>> 6 & 0x3F] << 8 | 0x3D);
                break;
            }
            case 1: {
                byteBuf.setInt(n4, byArray[n2 >>> 18] << 24 | byArray[n2 >>> 12 & 0x3F] << 16 | 0x3D00 | 0x3D);
                break;
            }
        }
    }

    private static void encode3to4LittleEndian(int n2, int n3, ByteBuf byteBuf, int n4, byte[] byArray) {
        switch (n3) {
            case 3: {
                byteBuf.setInt(n4, byArray[n2 >>> 18] | byArray[n2 >>> 12 & 0x3F] << 8 | byArray[n2 >>> 6 & 0x3F] << 16 | byArray[n2 & 0x3F] << 24);
                break;
            }
            case 2: {
                byteBuf.setInt(n4, byArray[n2 >>> 18] | byArray[n2 >>> 12 & 0x3F] << 8 | byArray[n2 >>> 6 & 0x3F] << 16 | 0x3D000000);
                break;
            }
            case 1: {
                byteBuf.setInt(n4, byArray[n2 >>> 18] | byArray[n2 >>> 12 & 0x3F] << 8 | 0x3D0000 | 0x3D000000);
                break;
            }
        }
    }

    public static ByteBuf decode(ByteBuf byteBuf) {
        return Base64.decode(byteBuf, Base64Dialect.STANDARD);
    }

    public static ByteBuf decode(ByteBuf byteBuf, Base64Dialect base64Dialect) {
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        ByteBuf byteBuf2 = Base64.decode(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), base64Dialect);
        byteBuf.readerIndex(byteBuf.writerIndex());
        return byteBuf2;
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n2, int n3) {
        return Base64.decode(byteBuf, n2, n3, Base64Dialect.STANDARD);
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n2, int n3, Base64Dialect base64Dialect) {
        return Base64.decode(byteBuf, n2, n3, base64Dialect, byteBuf.alloc());
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n2, int n3, Base64Dialect base64Dialect, ByteBufAllocator byteBufAllocator) {
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        return new Base64$Decoder(null).decode(byteBuf, n2, n3, byteBufAllocator, base64Dialect);
    }

    static int decodedBufferSize(int n2) {
        return n2 - (n2 >>> 2);
    }

    private Base64() {
    }

    static /* synthetic */ byte[] access$100(Base64Dialect base64Dialect) {
        return Base64.decodabet(base64Dialect);
    }
}

