/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.base64;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64$1;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteOrder;

final class Base64$Decoder
implements ByteProcessor {
    private final byte[] b4 = new byte[4];
    private int b4Posn;
    private byte sbiCrop;
    private byte sbiDecode;
    private byte[] decodabet;
    private int outBuffPosn;
    private ByteBuf dest;

    private Base64$Decoder() {
    }

    ByteBuf decode(ByteBuf byteBuf, int n2, int n3, ByteBufAllocator byteBufAllocator, Base64Dialect base64Dialect) {
        this.dest = byteBufAllocator.buffer(Base64.decodedBufferSize(n3)).order(byteBuf.order());
        this.decodabet = Base64.access$100(base64Dialect);
        try {
            byteBuf.forEachByte(n2, n3, this);
            return this.dest.slice(0, this.outBuffPosn);
        }
        catch (Throwable throwable) {
            this.dest.release();
            PlatformDependent.throwException(throwable);
            return null;
        }
    }

    @Override
    public boolean process(byte by2) {
        this.sbiCrop = (byte)(by2 & 0x7F);
        this.sbiDecode = this.decodabet[this.sbiCrop];
        if (this.sbiDecode >= -5) {
            if (this.sbiDecode >= -1) {
                this.b4[this.b4Posn++] = this.sbiCrop;
                if (this.b4Posn > 3) {
                    this.outBuffPosn += Base64$Decoder.decode4to3(this.b4, this.dest, this.outBuffPosn, this.decodabet);
                    this.b4Posn = 0;
                    if (this.sbiCrop == 61) {
                        return false;
                    }
                }
            }
            return true;
        }
        throw new IllegalArgumentException("invalid bad Base64 input character: " + (short)(by2 & 0xFF) + " (decimal)");
    }

    private static int decode4to3(byte[] byArray, ByteBuf byteBuf, int n2, byte[] byArray2) {
        int n3;
        byte by2 = byArray[0];
        byte by3 = byArray[1];
        byte by4 = byArray[2];
        if (by4 == 61) {
            int n4;
            try {
                n4 = (byArray2[by2] & 0xFF) << 2 | (byArray2[by3] & 0xFF) >>> 4;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalArgumentException("not encoded in Base64");
            }
            byteBuf.setByte(n2, n4);
            return 1;
        }
        byte by5 = byArray[3];
        if (by5 == 61) {
            int n5;
            byte by6 = byArray2[by3];
            try {
                n5 = byteBuf.order() == ByteOrder.BIG_ENDIAN ? ((byArray2[by2] & 0x3F) << 2 | (by6 & 0xF0) >> 4) << 8 | (by6 & 0xF) << 4 | (byArray2[by4] & 0xFC) >>> 2 : (byArray2[by2] & 0x3F) << 2 | (by6 & 0xF0) >> 4 | ((by6 & 0xF) << 4 | (byArray2[by4] & 0xFC) >>> 2) << 8;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalArgumentException("not encoded in Base64");
            }
            byteBuf.setShort(n2, n5);
            return 2;
        }
        try {
            if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
                n3 = (byArray2[by2] & 0x3F) << 18 | (byArray2[by3] & 0xFF) << 12 | (byArray2[by4] & 0xFF) << 6 | byArray2[by5] & 0xFF;
            } else {
                byte by7 = byArray2[by3];
                byte by8 = byArray2[by4];
                n3 = (byArray2[by2] & 0x3F) << 2 | (by7 & 0xF) << 12 | (by7 & 0xF0) >>> 4 | (by8 & 3) << 22 | (by8 & 0xFC) << 6 | (byArray2[by5] & 0xFF) << 16;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("not encoded in Base64");
        }
        byteBuf.setMedium(n2, n3);
        return 3;
    }

    /* synthetic */ Base64$Decoder(Base64$1 base64$1) {
        this();
    }
}

