/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.ByteProcessor;
import io.netty.util.Signal;
import io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

final class ReplayingDecoderByteBuf
extends ByteBuf {
    private static final Signal REPLAY = ReplayingDecoder.REPLAY;
    private ByteBuf buffer;
    private boolean terminated;
    private SwappedByteBuf swapped;
    static final ReplayingDecoderByteBuf EMPTY_BUFFER = new ReplayingDecoderByteBuf(Unpooled.EMPTY_BUFFER);

    ReplayingDecoderByteBuf() {
    }

    ReplayingDecoderByteBuf(ByteBuf byteBuf) {
        this.setCumulation(byteBuf);
    }

    void setCumulation(ByteBuf byteBuf) {
        this.buffer = byteBuf;
    }

    void terminate() {
        this.terminated = true;
    }

    @Override
    public int capacity() {
        if (this.terminated) {
            return this.buffer.capacity();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public ByteBuf capacity(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int maxCapacity() {
        return this.capacity();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.buffer.alloc();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf clear() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int compareTo(ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf copy() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf copy(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.buffer.copy(n2, n3);
    }

    @Override
    public ByteBuf discardReadBytes() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf ensureWritable(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int ensureWritable(int n2, boolean bl2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf duplicate() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf retainedDuplicate() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public boolean getBoolean(int n2) {
        this.checkIndex(n2, 1);
        return this.buffer.getBoolean(n2);
    }

    @Override
    public byte getByte(int n2) {
        this.checkIndex(n2, 1);
        return this.buffer.getByte(n2);
    }

    @Override
    public short getUnsignedByte(int n2) {
        this.checkIndex(n2, 1);
        return this.buffer.getUnsignedByte(n2);
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkIndex(n2, n4);
        this.buffer.getBytes(n2, byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray) {
        this.checkIndex(n2, byArray.length);
        this.buffer.getBytes(n2, byArray);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkIndex(n2, n4);
        this.buffer.getBytes(n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int getBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int getInt(int n2) {
        this.checkIndex(n2, 4);
        return this.buffer.getInt(n2);
    }

    @Override
    public int getIntLE(int n2) {
        this.checkIndex(n2, 4);
        return this.buffer.getIntLE(n2);
    }

    @Override
    public long getUnsignedInt(int n2) {
        this.checkIndex(n2, 4);
        return this.buffer.getUnsignedInt(n2);
    }

    @Override
    public long getUnsignedIntLE(int n2) {
        this.checkIndex(n2, 4);
        return this.buffer.getUnsignedIntLE(n2);
    }

    @Override
    public long getLong(int n2) {
        this.checkIndex(n2, 8);
        return this.buffer.getLong(n2);
    }

    @Override
    public long getLongLE(int n2) {
        this.checkIndex(n2, 8);
        return this.buffer.getLongLE(n2);
    }

    @Override
    public int getMedium(int n2) {
        this.checkIndex(n2, 3);
        return this.buffer.getMedium(n2);
    }

    @Override
    public int getMediumLE(int n2) {
        this.checkIndex(n2, 3);
        return this.buffer.getMediumLE(n2);
    }

    @Override
    public int getUnsignedMedium(int n2) {
        this.checkIndex(n2, 3);
        return this.buffer.getUnsignedMedium(n2);
    }

    @Override
    public int getUnsignedMediumLE(int n2) {
        this.checkIndex(n2, 3);
        return this.buffer.getUnsignedMediumLE(n2);
    }

    @Override
    public short getShort(int n2) {
        this.checkIndex(n2, 2);
        return this.buffer.getShort(n2);
    }

    @Override
    public short getShortLE(int n2) {
        this.checkIndex(n2, 2);
        return this.buffer.getShortLE(n2);
    }

    @Override
    public int getUnsignedShort(int n2) {
        this.checkIndex(n2, 2);
        return this.buffer.getUnsignedShort(n2);
    }

    @Override
    public int getUnsignedShortLE(int n2) {
        this.checkIndex(n2, 2);
        return this.buffer.getUnsignedShortLE(n2);
    }

    @Override
    public char getChar(int n2) {
        this.checkIndex(n2, 2);
        return this.buffer.getChar(n2);
    }

    @Override
    public float getFloat(int n2) {
        this.checkIndex(n2, 4);
        return this.buffer.getFloat(n2);
    }

    @Override
    public double getDouble(int n2) {
        this.checkIndex(n2, 8);
        return this.buffer.getDouble(n2);
    }

    @Override
    public CharSequence getCharSequence(int n2, int n3, Charset charset) {
        this.checkIndex(n2, n3);
        return this.buffer.getCharSequence(n2, n3, charset);
    }

    @Override
    public int hashCode() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int indexOf(int n2, int n3, byte by2) {
        if (n2 == n3) {
            return -1;
        }
        if (Math.max(n2, n3) > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.indexOf(n2, n3, by2);
    }

    @Override
    public int bytesBefore(byte by2) {
        int n2 = this.buffer.bytesBefore(by2);
        if (n2 < 0) {
            throw REPLAY;
        }
        return n2;
    }

    @Override
    public int bytesBefore(int n2, byte by2) {
        return this.bytesBefore(this.buffer.readerIndex(), n2, by2);
    }

    @Override
    public int bytesBefore(int n2, int n3, byte by2) {
        int n4 = this.buffer.writerIndex();
        if (n2 >= n4) {
            throw REPLAY;
        }
        if (n2 <= n4 - n3) {
            return this.buffer.bytesBefore(n2, n3, by2);
        }
        int n5 = this.buffer.bytesBefore(n2, n4 - n2, by2);
        if (n5 < 0) {
            throw REPLAY;
        }
        return n5;
    }

    @Override
    public int forEachByte(ByteProcessor byteProcessor) {
        int n2 = this.buffer.forEachByte(byteProcessor);
        if (n2 < 0) {
            throw REPLAY;
        }
        return n2;
    }

    @Override
    public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
        int n4 = this.buffer.writerIndex();
        if (n2 >= n4) {
            throw REPLAY;
        }
        if (n2 <= n4 - n3) {
            return this.buffer.forEachByte(n2, n3, byteProcessor);
        }
        int n5 = this.buffer.forEachByte(n2, n4 - n2, byteProcessor);
        if (n5 < 0) {
            throw REPLAY;
        }
        return n5;
    }

    @Override
    public int forEachByteDesc(ByteProcessor byteProcessor) {
        if (this.terminated) {
            return this.buffer.forEachByteDesc(byteProcessor);
        }
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int forEachByteDesc(int n2, int n3, ByteProcessor byteProcessor) {
        if (n2 + n3 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.forEachByteDesc(n2, n3, byteProcessor);
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.buffer.markReaderIndex();
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (byteOrder == null) {
            throw new NullPointerException("endianness");
        }
        if (byteOrder == this.order()) {
            return this;
        }
        SwappedByteBuf swappedByteBuf = this.swapped;
        if (swappedByteBuf == null) {
            this.swapped = swappedByteBuf = new SwappedByteBuf(this);
        }
        return swappedByteBuf;
    }

    @Override
    public boolean isReadable() {
        return this.terminated ? this.buffer.isReadable() : true;
    }

    @Override
    public boolean isReadable(int n2) {
        return this.terminated ? this.buffer.isReadable(n2) : true;
    }

    @Override
    public int readableBytes() {
        if (this.terminated) {
            return this.buffer.readableBytes();
        }
        return Integer.MAX_VALUE - this.buffer.readerIndex();
    }

    @Override
    public boolean readBoolean() {
        this.checkReadableBytes(1);
        return this.buffer.readBoolean();
    }

    @Override
    public byte readByte() {
        this.checkReadableBytes(1);
        return this.buffer.readByte();
    }

    @Override
    public short readUnsignedByte() {
        this.checkReadableBytes(1);
        return this.buffer.readUnsignedByte();
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.checkReadableBytes(n3);
        this.buffer.readBytes(byArray, n2, n3);
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray) {
        this.checkReadableBytes(byArray.length);
        this.buffer.readBytes(byArray);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n2, int n3) {
        this.checkReadableBytes(n3);
        this.buffer.readBytes(byteBuf, n2, n3);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf) {
        this.checkReadableBytes(byteBuf.writableBytes());
        this.buffer.readBytes(byteBuf);
        return this;
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l2, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf readBytes(int n2) {
        this.checkReadableBytes(n2);
        return this.buffer.readBytes(n2);
    }

    @Override
    public ByteBuf readSlice(int n2) {
        this.checkReadableBytes(n2);
        return this.buffer.readSlice(n2);
    }

    @Override
    public ByteBuf readRetainedSlice(int n2) {
        this.checkReadableBytes(n2);
        return this.buffer.readRetainedSlice(n2);
    }

    @Override
    public ByteBuf readBytes(OutputStream outputStream, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    @Override
    public ByteBuf readerIndex(int n2) {
        this.buffer.readerIndex(n2);
        return this;
    }

    @Override
    public int readInt() {
        this.checkReadableBytes(4);
        return this.buffer.readInt();
    }

    @Override
    public int readIntLE() {
        this.checkReadableBytes(4);
        return this.buffer.readIntLE();
    }

    @Override
    public long readUnsignedInt() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedInt();
    }

    @Override
    public long readUnsignedIntLE() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedIntLE();
    }

    @Override
    public long readLong() {
        this.checkReadableBytes(8);
        return this.buffer.readLong();
    }

    @Override
    public long readLongLE() {
        this.checkReadableBytes(8);
        return this.buffer.readLongLE();
    }

    @Override
    public int readMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readMedium();
    }

    @Override
    public int readMediumLE() {
        this.checkReadableBytes(3);
        return this.buffer.readMediumLE();
    }

    @Override
    public int readUnsignedMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMedium();
    }

    @Override
    public int readUnsignedMediumLE() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMediumLE();
    }

    @Override
    public short readShort() {
        this.checkReadableBytes(2);
        return this.buffer.readShort();
    }

    @Override
    public short readShortLE() {
        this.checkReadableBytes(2);
        return this.buffer.readShortLE();
    }

    @Override
    public int readUnsignedShort() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShort();
    }

    @Override
    public int readUnsignedShortLE() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShortLE();
    }

    @Override
    public char readChar() {
        this.checkReadableBytes(2);
        return this.buffer.readChar();
    }

    @Override
    public float readFloat() {
        this.checkReadableBytes(4);
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() {
        this.checkReadableBytes(8);
        return this.buffer.readDouble();
    }

    @Override
    public CharSequence readCharSequence(int n2, Charset charset) {
        this.checkReadableBytes(n2);
        return this.buffer.readCharSequence(n2, charset);
    }

    @Override
    public ByteBuf resetReaderIndex() {
        this.buffer.resetReaderIndex();
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBoolean(int n2, boolean bl2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setZero(int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int setBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setIndex(int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setInt(int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setIntLE(int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setLong(int n2, long l2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setLongLE(int n2, long l2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setMediumLE(int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setShort(int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setShortLE(int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setChar(int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setFloat(int n2, float f2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setDouble(int n2, double d2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf skipBytes(int n2) {
        this.checkReadableBytes(n2);
        this.buffer.skipBytes(n2);
        return this;
    }

    @Override
    public ByteBuf slice() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf retainedSlice() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf slice(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.buffer.slice(n2, n3);
    }

    @Override
    public ByteBuf retainedSlice(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.buffer.slice(n2, n3);
    }

    @Override
    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.buffer.nioBuffer(n2, n3);
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.buffer.nioBuffers(n2, n3);
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.buffer.internalNioBuffer(n2, n3);
    }

    @Override
    public String toString(int n2, int n3, Charset charset) {
        this.checkIndex(n2, n3);
        return this.buffer.toString(n2, n3, charset);
    }

    @Override
    public String toString(Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + "ridx=" + this.readerIndex() + ", widx=" + this.writerIndex() + ')';
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritable(int n2) {
        return false;
    }

    @Override
    public int writableBytes() {
        return 0;
    }

    @Override
    public int maxWritableBytes() {
        return 0;
    }

    @Override
    public ByteBuf writeBoolean(boolean bl2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeByte(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writeBytes(InputStream inputStream, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writeBytes(FileChannel fileChannel, long l2, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeInt(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeIntLE(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeLong(long l2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeLongLE(long l2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeMedium(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeMediumLE(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeZero(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    @Override
    public ByteBuf writerIndex(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeShort(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeShortLE(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeChar(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeFloat(float f2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeDouble(double d2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int setCharSequence(int n2, CharSequence charSequence, Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    private void checkIndex(int n2, int n3) {
        if (n2 + n3 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
    }

    private void checkReadableBytes(int n2) {
        if (this.buffer.readableBytes() < n2) {
            throw REPLAY;
        }
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int refCnt() {
        return this.buffer.refCnt();
    }

    @Override
    public ByteBuf retain() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf retain(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf touch() {
        this.buffer.touch();
        return this;
    }

    @Override
    public ByteBuf touch(Object object) {
        this.buffer.touch(object);
        return this;
    }

    @Override
    public boolean release() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public boolean release(int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf unwrap() {
        throw ReplayingDecoderByteBuf.reject();
    }

    private static UnsupportedOperationException reject() {
        return new UnsupportedOperationException("not a replayable operation");
    }

    static {
        EMPTY_BUFFER.terminate();
    }
}

