/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.ReplayingDecoderByteBuf;
import io.netty.util.Signal;
import io.netty.util.internal.StringUtil;
import java.util.List;

public abstract class ReplayingDecoder<S>
extends ByteToMessageDecoder {
    static final Signal REPLAY = Signal.valueOf(ReplayingDecoder.class, "REPLAY");
    private final ReplayingDecoderByteBuf replayable = new ReplayingDecoderByteBuf();
    private S state;
    private int checkpoint = -1;

    protected ReplayingDecoder() {
        this(null);
    }

    protected ReplayingDecoder(S s2) {
        this.state = s2;
    }

    protected void checkpoint() {
        this.checkpoint = this.internalBuffer().readerIndex();
    }

    protected void checkpoint(S s2) {
        this.checkpoint();
        this.state(s2);
    }

    protected S state() {
        return this.state;
    }

    protected S state(S s2) {
        S s3 = this.state;
        this.state = s2;
        return s3;
    }

    @Override
    final void channelInputClosed(ChannelHandlerContext channelHandlerContext, List<Object> list) {
        try {
            this.replayable.terminate();
            if (this.cumulation != null) {
                this.callDecode(channelHandlerContext, this.internalBuffer(), list);
            } else {
                this.replayable.setCumulation(Unpooled.EMPTY_BUFFER);
            }
            this.decodeLast(channelHandlerContext, this.replayable, list);
        }
        catch (Signal signal) {
            signal.expect(REPLAY);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void callDecode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        this.replayable.setCumulation(byteBuf);
        try {
            while (byteBuf.isReadable()) {
                int n2 = this.checkpoint = byteBuf.readerIndex();
                int n3 = list.size();
                if (n3 > 0) {
                    ReplayingDecoder.fireChannelRead(channelHandlerContext, list, n3);
                    list.clear();
                    if (channelHandlerContext.isRemoved()) {
                        return;
                    }
                    n3 = 0;
                }
                S s2 = this.state;
                int n4 = byteBuf.readableBytes();
                try {
                    this.decodeRemovalReentryProtection(channelHandlerContext, this.replayable, list);
                    if (channelHandlerContext.isRemoved()) {
                        return;
                    }
                    if (n3 == list.size()) {
                        if (n4 != byteBuf.readableBytes() || s2 != this.state) continue;
                        throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() must consume the inbound data or change its state if it did not decode anything.");
                    }
                }
                catch (Signal signal) {
                    signal.expect(REPLAY);
                    if (channelHandlerContext.isRemoved()) {
                        return;
                    }
                    int n5 = this.checkpoint;
                    if (n5 < 0) return;
                    byteBuf.readerIndex(n5);
                    return;
                }
                if (n2 == byteBuf.readerIndex() && s2 == this.state) {
                    throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() method must consume the inbound data or change its state if it decoded something.");
                }
                if (this.isSingleDecode()) return;
            }
            return;
        }
        catch (DecoderException decoderException) {
            throw decoderException;
        }
        catch (Exception exception) {
            throw new DecoderException(exception);
        }
    }
}

