/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.CodecOutputList;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class MessageToMessageEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected MessageToMessageEncoder() {
        this.matcher = TypeParameterMatcher.find(this, MessageToMessageEncoder.class, "I");
    }

    protected MessageToMessageEncoder(Class<? extends I> clazz) {
        this.matcher = TypeParameterMatcher.get(clazz);
    }

    public boolean acceptOutboundMessage(Object object) {
        return this.matcher.match(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        CodecOutputList codecOutputList = null;
        try {
            if (this.acceptOutboundMessage(object)) {
                codecOutputList = CodecOutputList.newInstance();
                Object object2 = object;
                try {
                    this.encode(channelHandlerContext, object2, codecOutputList);
                }
                finally {
                    ReferenceCountUtil.release(object2);
                }
                if (codecOutputList.isEmpty()) {
                    codecOutputList.recycle();
                    codecOutputList = null;
                    throw new EncoderException(StringUtil.simpleClassName(this) + " must produce at least one message.");
                }
            } else {
                channelHandlerContext.write(object, channelPromise);
            }
            if (codecOutputList == null) return;
        }
        catch (EncoderException encoderException) {
            try {
                throw encoderException;
                catch (Throwable throwable) {
                    throw new EncoderException(throwable);
                }
            }
            catch (Throwable throwable) {
                if (codecOutputList == null) throw throwable;
                int n2 = codecOutputList.size() - 1;
                if (n2 == 0) {
                    channelHandlerContext.write(codecOutputList.get(0), channelPromise);
                } else if (n2 > 0) {
                    ChannelPromise channelPromise2 = channelHandlerContext.voidPromise();
                    boolean bl2 = channelPromise == channelPromise2;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        ChannelPromise channelPromise3 = bl2 ? channelPromise2 : channelHandlerContext.newPromise();
                        channelHandlerContext.write(codecOutputList.getUnsafe(i2), channelPromise3);
                    }
                    channelHandlerContext.write(codecOutputList.getUnsafe(n2), channelPromise);
                }
                codecOutputList.recycle();
                throw throwable;
            }
        }
        int n3 = codecOutputList.size() - 1;
        if (n3 == 0) {
            channelHandlerContext.write(codecOutputList.get(0), channelPromise);
        } else if (n3 > 0) {
            ChannelPromise channelPromise4 = channelHandlerContext.voidPromise();
            boolean bl3 = channelPromise == channelPromise4;
            for (int i3 = 0; i3 < n3; ++i3) {
                ChannelPromise channelPromise5 = bl3 ? channelPromise4 : channelHandlerContext.newPromise();
                channelHandlerContext.write(codecOutputList.getUnsafe(i3), channelPromise5);
            }
            channelHandlerContext.write(codecOutputList.getUnsafe(n3), channelPromise);
        }
        codecOutputList.recycle();
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, List<Object> var3);
}

